/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.event;

import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import oracle.jdbc.OracleDriver;
import oracle.xdb.XDBOutputStream;
import oracle.xdb.XMLType;
import oracle.xdb.event.XDBEvent;
import oracle.xdb.event.XDBHandlerList;
import oracle.xdb.event.XDBLink;
import oracle.xdb.event.XDBLock;
import oracle.xdb.event.XDBPath;
import oracle.xdb.event.XDBRenderStream;
import oracle.xdb.servlet.XDBServletRequest;
import oracle.xdb.spi.XDBResource;

public class XDBRepositoryEvent
extends XDBEvent {
    private static final int OPEN_ACCESS_READ = 1;
    private static final int OPEN_ACCESS_WRITE = 2;
    private static final int OPEN_ACCESS_READ_WRITE = 3;
    private static final int OPEN_DENY_NONE = 0;
    private static final int OPEN_DENY_READ = 1;
    private static final int OPEN_DENY_READ_WRITE = 2;
    protected Connection m_conn;

    private synchronized native String getInterfaceNative(long var1, long var3);

    private synchronized native boolean checkServletNative(long var1, long var3);

    private synchronized native long getPathNative(long var1, long var3);

    private synchronized native long getResourceNative(long var1, long var3);

    private synchronized native long getParentNative(long var1, long var3);

    private synchronized native long getLockNative(long var1, long var3);

    private synchronized native long getLinkNative(long var1, long var3);

    private synchronized native long getOldResourceNative(long var1, long var3);

    private synchronized native long getHandlerListNative(long var1, long var3);

    private synchronized native String getParameterNative(long var1, long var3, String var5);

    private synchronized native long getOutputStreamNative(long var1, long var3);

    private synchronized native int getStreamOffsetNative(long var1, long var3);

    private synchronized native void setRenderStreamNative(long var1, long var3, long var5);

    private synchronized native void setRenderPathNative(long var1, long var3, String var5);

    private synchronized native long getApplicationDataNative(long var1, long var3);

    XDBRepositoryEvent(long ev) {
        super(ev);
    }

    public String getInterface() {
        return this.getInterfaceNative(XDBResource.getServerEnv(), this.m_evcstate);
    }

    public HttpServletRequest getServletRequest() {
        this.checkServletNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBServletRequest();
    }

    public XMLType getApplicationData() {
        XMLType xt;
        long cstate = this.getApplicationDataNative(XDBResource.getServerEnv(), this.m_evcstate);
        try {
            if (this.m_conn == null) {
                DriverManager.registerDriver((Driver)new OracleDriver());
                OracleDriver ora = new OracleDriver();
                this.m_conn = ora.defaultConnection();
            }
            xt = new XMLType(this.m_conn, cstate);
        }
        catch (SQLException e) {
            return null;
        }
        return xt;
    }

    public XDBPath getPath() {
        long cstate = this.getPathNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBPath(cstate);
    }

    public XDBResource getResource() {
        long cstate = this.getResourceNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBResource(null, null, cstate);
    }

    public XDBResource getParent() {
        long cstate = this.getParentNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBResource(null, null, cstate);
    }

    public XDBHandlerList getHandlerList() {
        long cstate = this.getHandlerListNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBHandlerList(cstate);
    }

    public XDBLink getLink() {
        long cstate = this.getLinkNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBLink(cstate);
    }

    public String getParameter(String key) {
        return this.getParameterNative(XDBResource.getServerEnv(), this.m_evcstate, key);
    }

    public XDBResource getOldResource() {
        long cstate = this.getOldResourceNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBResource(null, null, cstate);
    }

    public XDBOutputStream getOutputStream() {
        long gp = XDBResource.getServerEnv();
        long os = this.getOutputStreamNative(gp, this.m_evcstate);
        int offset = this.getStreamOffsetNative(gp, this.m_evcstate);
        return new XDBRenderStream(gp, os, this.m_evcstate, offset);
    }

    public void setRenderStream(InputStream istr) throws SQLException {
        long strmHeap = XMLType.allocHeapNative(XDBResource.getServerEnv(), 0L, 0L);
        long segstream = XMLType.inputToSegStream(XDBResource.getServerEnv(), istr, 0L, 0L, strmHeap);
        this.setRenderStreamNative(XDBResource.getServerEnv(), this.m_evcstate, segstream);
    }

    public void setRenderPath(String path) {
        this.setRenderPathNative(XDBResource.getServerEnv(), this.m_evcstate, path);
    }

    public XDBLock getLock() {
        long cstate = this.getLockNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBLock(cstate);
    }

    private BigInteger getUpdateByteOffset() {
        return null;
    }

    private long getUpdateByteCount() {
        return 0L;
    }

    private int getOpenAccessMode() {
        return 0;
    }

    private int getOpenDenyMode() {
        return 0;
    }
}

