/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.CellComponent;
import oracle.jdevimpl.help.ActionWrapper;
import oracle.jdevimpl.help.ColorUtils;

public class Button
extends JButton
implements CellComponent {
    private Cell _cell;

    public Button() {
        this.setFont(this.getFont().deriveFont(1, ColorUtils.getDefaultFontSize(this, 11.0f)));
        this.setForeground(ColorUtils.buttonTextColor);
        this.setBorderPainted(true);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setHorizontalAlignment(10);
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 8, 10, 8);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width, 21);
    }

    @Override
    public void setCell(Cell cell) {
        this._cell = cell;
        ResourceUtils.resButton((AbstractButton)this, (String)cell.getName());
        this.setAction(new ActionWrapper(cell));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        RoundRectangle2D fillRectangle = this.getRoundedRectangle();
        Action action = this.getAction();
        if (action != null) {
            this.setEnabled(action.isEnabled());
        } else {
            this.setEnabled(true);
        }
        if (this.getModel().isRollover()) {
            ColorUtils.buttonRolloverFill.paint(g2, (Shape)fillRectangle);
        }
        if (this.getModel().isPressed()) {
            ColorUtils.buttonPressedFill.paint(g2, (Shape)fillRectangle);
        } else {
            ColorUtils.buttonNormalFill.paint(g2, (Shape)fillRectangle);
        }
        super.paintComponent(g2);
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        RoundRectangle2D fillRectangle = this.getRoundedRectangle();
        if (this.hasFocus()) {
            g2.setColor(ColorUtils.focusLine);
            g2.draw(fillRectangle);
        } else {
            g2.setColor(ColorUtils.buttonLineColor);
            g2.draw(fillRectangle);
        }
    }

    private void setRenderingHints(Graphics2D g2) {
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            rhints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.addRenderingHints(rhints);
        }
    }

    private RoundRectangle2D getRoundedRectangle() {
        return new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 5.0, 5.0);
    }
}

