/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import com.oracle.jdeveloper.nbwindowsystem.plaf.OracleLFCustoms;
import java.awt.GraphicsEnvironment;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.docking.DockStation;
import oracle.ide.extension.RoleManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class Installer
extends ModuleInstall {
    public void restored() {
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent wse) {
                RoleManager rm;
                String role;
                if (OracleLFCustoms.isDefaultTheme()) {
                    UIManager.put("NbMainWindow.showCustomBackground", Boolean.TRUE);
                }
                if ("Default".equals(role = (rm = ExtensionRegistry.getExtensionRegistry().getRoleManager()).getActiveRole().getId())) {
                    role = null;
                }
                WindowManager.getDefault().setRole(role);
                DockStation ds = DockStation.getDockStation();
                if (ds instanceof NbDockStation) {
                    ((NbDockStation)ds).beforeWindowSystemLoad();
                }
            }

            public void afterLoad(WindowSystemEvent wse) {
                WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                DockStation ds = DockStation.getDockStation();
                if (ds instanceof NbDockStation) {
                    ((NbDockStation)ds).afterWindowSystemLoad();
                }
            }

            public void beforeSave(WindowSystemEvent wse) {
            }

            public void afterSave(WindowSystemEvent wse) {
            }
        });
    }

    public boolean closing() {
        NbMainWindow mw;
        if (!Ide.isQuitting() && !GraphicsEnvironment.isHeadless() && (mw = (NbMainWindow)Lookup.getDefault().lookup(NbMainWindow.class)) != null) {
            Context context = mw.getIdeMainWindowView().getContext();
            int res = Ide.quit((IdeAction)IdeActions.getFileExitAction(), (Context)context);
            if (res == 1) {
                return false;
            }
        }
        return true;
    }

    static {
        if (System.getProperty("nb.core.windows.no.lazy.loading") == null) {
            System.setProperty("nb.core.windows.no.lazy.loading", "true");
        }
        UIManager.put("Nb.Oracle2LFCustoms", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new OracleLFCustoms();
            }
        });
    }
}

