/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class NbStructuredPropertyAccess
extends DefaultStructuredPropertyAccess {
    private static final String ESCAPE_STRING = "_escaped";
    private static final String ESCAPE_VALUE_STRING = "_escapedValue";
    private static final String TEXT = "TEXT";
    private static final Pattern pattern = Pattern.compile("^[./$<> ]|[/$<> ]+|^[0-9]$");

    public NbStructuredPropertyAccess(String name) {
        super(name);
    }

    public static String toString(StructuredPropertyAccess structuredPropertyAccess) throws IOException {
        XMLDocument xmlDocument = new XMLDocument();
        Element element = NbStructuredPropertyAccess.saveToElement(structuredPropertyAccess, xmlDocument);
        xmlDocument.appendChild((Node)element);
        StringWriter writer = new StringWriter();
        xmlDocument.print((Writer)writer);
        writer.flush();
        return writer.toString();
    }

    private static Element saveToElement(StructuredPropertyAccess structuredPropertyAccess, XMLDocument ownerDocument) {
        Element element;
        String nodeName = structuredPropertyAccess.getName();
        if (NbStructuredPropertyAccess.isValidKey(nodeName)) {
            try {
                element = ownerDocument.createElement(nodeName);
            }
            catch (DOMException e) {
                FeedbackManager.addFeedback((String)("Failed to create element [" + nodeName + "]"));
                throw e;
            }
        } else {
            element = ownerDocument.createElement(ESCAPE_STRING);
            element.setAttribute(ESCAPE_VALUE_STRING, nodeName);
        }
        int invalidKeys = 0;
        Iterator properties = structuredPropertyAccess.getProperties();
        while (properties.hasNext()) {
            String key = (String)properties.next();
            String property = structuredPropertyAccess.getProperty(key, null);
            if (NbStructuredPropertyAccess.isValidKey(key)) {
                element.setAttribute(key, property);
                continue;
            }
            element.setAttribute(ESCAPE_STRING + invalidKeys, property);
            element.setAttribute(ESCAPE_VALUE_STRING + invalidKeys, key);
            ++invalidKeys;
        }
        Iterator childNodes = structuredPropertyAccess.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess childPropertyAccess = (StructuredPropertyAccess)childNodes.next();
            try {
                Element childElement = NbStructuredPropertyAccess.saveToElement(childPropertyAccess, ownerDocument);
                element.appendChild(childElement);
            }
            catch (DOMException e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        return element;
    }

    private static boolean isValidKey(String name) {
        boolean valid;
        if (name == null || name.length() == 0) {
            Logger.getAnonymousLogger().info("Invalid key - empty or null string");
            return false;
        }
        Matcher m = pattern.matcher(name);
        boolean bl = valid = !m.find();
        if (!valid) {
            Logger.getAnonymousLogger().info("Invalid key = " + name);
        }
        return valid;
    }

    public static NbStructuredPropertyAccess fromString(String text) throws SAXException, XMLParseException, IOException {
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(false);
        domParser.parse((Reader)new StringReader(text));
        XMLDocument xmlDocument = domParser.getDocument();
        Element root = xmlDocument.getDocumentElement();
        NbStructuredPropertyAccess defaultStructuredPropertyAccess = NbStructuredPropertyAccess.loadFromElement(root);
        return defaultStructuredPropertyAccess;
    }

    private static NbStructuredPropertyAccess loadFromElement(Element root) {
        String escapedKeyKey;
        String escapedKey;
        String nodeName = root.getNodeName();
        NbStructuredPropertyAccess defaultStructuredPropertyAccess = new NbStructuredPropertyAccess(nodeName);
        NamedNodeMap attributes = root.getAttributes();
        int attributesLength = attributes.getLength();
        for (int i = 0; i < attributesLength; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String key = attribute.getNodeName();
            String value = attribute.getNodeValue();
            defaultStructuredPropertyAccess.setProperty(key, value);
        }
        if (ESCAPE_STRING.equals(nodeName)) {
            String realNodeName = defaultStructuredPropertyAccess.getProperty(ESCAPE_VALUE_STRING, "");
            defaultStructuredPropertyAccess.setName(realNodeName);
            defaultStructuredPropertyAccess.removeProperty(ESCAPE_VALUE_STRING);
        }
        int escapedKeyCounter = 0;
        while ((escapedKey = defaultStructuredPropertyAccess.getProperty(escapedKeyKey = ESCAPE_STRING + escapedKeyCounter, null)) != null) {
            defaultStructuredPropertyAccess.removeProperty(escapedKeyKey);
            String escapedValueKey = ESCAPE_VALUE_STRING + escapedKeyCounter;
            String escapedValue = defaultStructuredPropertyAccess.getProperty(escapedValueKey, null);
            if (escapedValue == null) continue;
            defaultStructuredPropertyAccess.removeProperty(ESCAPE_VALUE_STRING + escapedKeyCounter);
            defaultStructuredPropertyAccess.setProperty(escapedKey, escapedValue);
        }
        NodeList childNodes = root.getChildNodes();
        int childrenLength = childNodes.getLength();
        block7: for (int i = 0; i < childrenLength; ++i) {
            Node childNode = childNodes.item(i);
            short nodeType = childNode.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)childNode;
                    NbStructuredPropertyAccess child = NbStructuredPropertyAccess.loadFromElement(element);
                    defaultStructuredPropertyAccess.appendChild((StructuredPropertyAccess)child);
                    continue block7;
                }
                case 3: {
                    NbStructuredPropertyAccess child = new NbStructuredPropertyAccess(TEXT);
                    String value = childNode.getNodeValue();
                    child.put(TEXT, value);
                    defaultStructuredPropertyAccess.appendChild((StructuredPropertyAccess)child);
                    continue block7;
                }
                case 8: {
                    continue block7;
                }
            }
        }
        return defaultStructuredPropertyAccess;
    }
}

