/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.awt.event.MouseEvent;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.runner.Debugger;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.jdevimpl.debugger.breakpoint.SourceIcon;

public class DebuggerEditorListener
implements EditorListener,
GutterClickListener {
    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor ceditor = (CodeEditor)editor;
            SourceIcon.gutterCreated(ceditor);
            CodeEditorGutter gutter = ceditor.getGutter();
            gutter.addGutterClickListener((GutterClickListener)this);
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor ceditor = (CodeEditor)editor;
            SourceIcon.gutterDestroyed(ceditor);
            CodeEditorGutter gutter = ceditor.getGutter();
            if (gutter != null) {
                gutter.removeGutterClickListener((GutterClickListener)this);
            }
        }
    }

    public void lineClicked(Gutter gutter, int clickedLine, MouseEvent event) {
        Debugger debugger;
        CodeEditorGutter codeEditorGutter;
        Context context;
        if (gutter instanceof CodeEditorGutter && (context = (codeEditorGutter = (CodeEditorGutter)gutter).getContext()) != null && (debugger = Debugger.getDebugger()) instanceof GutterClickListener) {
            ((GutterClickListener)debugger).lineClicked(gutter, clickedLine, event);
        }
    }
}

