/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.ArrayList;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;

public class KeywordTopicTreeNode
extends TopicTreeNode {
    private ArrayList _entries = null;

    public KeywordTopicTreeNode(View view, Topic topic) {
        this(view, topic, null);
    }

    public KeywordTopicTreeNode(View view, Topic topic, TopicTreeNode parent) {
        super(view, topic, parent);
    }

    public ArrayList getEntries() {
        return this._entries;
    }

    public KeywordTopicTreeNode getEntryByIndex(int index) throws IndexOutOfBoundsException {
        KeywordTopicTreeNode anEntry = null;
        if (index >= this.getNumEntries()) {
            throw new IndexOutOfBoundsException("Entry Index out of Bounds");
        }
        anEntry = (KeywordTopicTreeNode)this._entries.get(index);
        return anEntry;
    }

    public final int getNumEntries() {
        if (this._entries == null) {
            return 0;
        }
        return this._entries.size();
    }

    public KeywordTopicTreeNode addEntry(Topic entryTopic) {
        return this.addEntry(new KeywordTopicTreeNode(this.getView(), entryTopic));
    }

    public KeywordTopicTreeNode addEntry(KeywordTopicTreeNode entry) {
        entry.setParent(this);
        if (this._entries == null) {
            this._entries = new ArrayList(5);
        }
        this._entries.add(entry);
        return entry;
    }

    public void removeAllEntries() {
        if (this._entries != null) {
            this._entries.clear();
        }
    }
}

