/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.util.LineIterator;

public class TipURLFileSystemHelper
extends URLFileSystemHelper {
    public static final String PROTOCOL_NAME = "tip";
    public static final String ROOT_SEPARATOR = "!/";
    private static Map indexes = new HashMap();
    private static TipIndex NULL_INDEX = new TipIndex();

    @Override
    public URL canonicalize(URL url) {
        String oldPath;
        int separator;
        if (TipURLFileSystemHelper.isTipUrl(url) && (separator = (oldPath = url.getPath()).lastIndexOf(ROOT_SEPARATOR)) >= 0) {
            String urlPath = oldPath.substring(0, separator);
            String entryName = oldPath.substring(separator + 2);
            URL fileURL = TipURLFileSystemHelper.newTipUrl(urlPath);
            if (fileURL != null) {
                String newFilePath;
                URL newFileURL = URLFileSystem.canonicalize(fileURL);
                String canonicalEntryName = entryName;
                String oldFilePath = fileURL.getPath();
                if (!oldFilePath.equals(newFilePath = newFileURL.getPath()) || !canonicalEntryName.equals(entryName)) {
                    String basePath = oldFilePath.equals(newFilePath) ? urlPath : urlPath.substring(0, urlPath.indexOf(oldFilePath)) + newFilePath;
                    String newPath = basePath + ROOT_SEPARATOR + canonicalEntryName;
                    return URLFactory.replacePathPart(url, newPath);
                }
            } else {
                return null;
            }
        }
        return url;
    }

    @Override
    public boolean canRead(URL url) {
        return this.exists(url);
    }

    @Override
    public boolean canWrite(URL url) {
        return false;
    }

    @Override
    public boolean canCreate(URL url) {
        return this.exists(url);
    }

    @Override
    public boolean exists(URL url) {
        return TipURLFileSystemHelper.index(url).exists(TipURLFileSystemHelper.getTipEntryName(url));
    }

    @Override
    public Icon getDefaultIcon(URL url) {
        String entryName = TipURLFileSystemHelper.getTipEntryName(url);
        if (entryName != null && entryName.length() == 0) {
            return UIManager.getIcon("FileView.archiveIcon");
        }
        return super.getDefaultIcon(url);
    }

    @Override
    public String getFileName(URL url) {
        String path = url.getPath();
        int separator = path.lastIndexOf(ROOT_SEPARATOR);
        if (separator == path.length() - 2) {
            int lastSlash = path.lastIndexOf(47, separator);
            return path.substring(lastSlash + 1, separator);
        }
        return super.getFileName(url);
    }

    @Override
    public long getLength(URL url) {
        return TipURLFileSystemHelper.index(url).getLength(TipURLFileSystemHelper.getTipEntryName(url));
    }

    @Override
    public URL getParent(URL url) {
        String path = url.getPath();
        int startIndex = path.indexOf(ROOT_SEPARATOR);
        if (startIndex >= 0) {
            int searchStart = startIndex + 2;
            if (path.length() > searchStart) {
                int lastSlash;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                String newPath = path.substring(0, (lastSlash = path.lastIndexOf("/")) >= searchStart ? lastSlash + 1 : searchStart);
                return URLFactory.replacePathPart(url, newPath);
            }
            path = path.substring(0, path.length() - 2);
            return TipURLFileSystemHelper.newTipUrl(path);
        }
        return null;
    }

    @Override
    public String getPlatformPathName(URL url) {
        URL rootUrl = TipURLFileSystemHelper.getTipRootUrl(url);
        String rootName = url != rootUrl ? URLFileSystem.getPlatformPathName(rootUrl) : url.toString();
        String entry = TipURLFileSystemHelper.getTipEntryName(url);
        if (entry == null || entry.length() == 0) {
            return rootName;
        }
        StringBuffer buf = new StringBuffer(rootName);
        buf.append('!').append(File.separatorChar);
        buf.append(entry.replace('/', File.separatorChar));
        return buf.toString();
    }

    @Override
    public boolean isDirectory(URL url) {
        return TipURLFileSystemHelper.index(url).isDirectory(TipURLFileSystemHelper.getTipEntryName(url));
    }

    @Override
    public long lastModified(URL url) {
        URL jarFileURL = TipURLFileSystemHelper.getTipRootUrl(url);
        return URLFileSystem.lastModified(jarFileURL);
    }

    @Override
    public URL[] list(URL url) {
        return TipURLFileSystemHelper.index(url).list(TipURLFileSystemHelper.getTipEntryName(url));
    }

    @Override
    public InputStream openInputStream(URL url) throws IOException {
        return TipURLFileSystemHelper.index(url).openInputStream(TipURLFileSystemHelper.getTipEntryName(url));
    }

    @Override
    public void rename(URL oldURL, URL newURL) throws IOException {
        String oldJarEntry = TipURLFileSystemHelper.getTipEntryName(oldURL);
        if (oldJarEntry != null && oldJarEntry.length() != 0) {
            throw new IOException("Rename not supported inside JAR/ZIP files for oldURL: " + oldURL.toString());
        }
        String newJarEntry = TipURLFileSystemHelper.getTipEntryName(newURL);
        if (newJarEntry != null && newJarEntry.length() != 0) {
            throw new IOException("Rename not supported inside JAR/ZIP files for newURL: " + oldURL.toString());
        }
        URL oldJarFileURL = TipURLFileSystemHelper.getTipRootUrl(oldURL);
        URL newJarFileURL = TipURLFileSystemHelper.getTipRootUrl(newURL);
        URLFileSystem.renameEx(oldJarFileURL, newJarFileURL);
    }

    @Override
    public String toRelativeSpec(URL url, URL base) {
        String entry = TipURLFileSystemHelper.getTipEntryName(url);
        String baseEntry = TipURLFileSystemHelper.getTipEntryName(base);
        URL rootUrl = TipURLFileSystemHelper.getTipRootUrl(url);
        URL baseRootUrl = TipURLFileSystemHelper.getTipRootUrl(base);
        if (entry != null && entry.length() != 0 && baseEntry != null && baseEntry.length() != 0 && entry.startsWith(baseEntry) && URLFileSystem.equals(rootUrl, baseRootUrl)) {
            return super.toRelativeSpec(url, base);
        }
        return url.toString();
    }

    public static boolean isTipUrl(URL url) {
        return url != null && PROTOCOL_NAME.equals(url.getProtocol());
    }

    public static URL newTipUrl(URL url, String entryName) {
        if (!TipURLFileSystemHelper.isTipUrl(url)) {
            url = URLFactory.newURL(PROTOCOL_NAME, url.toString() + ROOT_SEPARATOR);
        }
        if (entryName == null || entryName.length() == 0) {
            return url;
        }
        return URLFactory.newURL(url, entryName);
    }

    public static String getTipEntryName(URL url) {
        String urlPathStr;
        int bangPos;
        if (TipURLFileSystemHelper.isTipUrl(url) && (bangPos = (urlPathStr = url.getPath()).lastIndexOf(ROOT_SEPARATOR)) >= 0) {
            return urlPathStr.substring(bangPos + 2);
        }
        return null;
    }

    public static URL getTipRootUrl(URL url) {
        String path;
        int separator;
        if (TipURLFileSystemHelper.isTipUrl(url) && (separator = (path = url.getPath()).lastIndexOf(ROOT_SEPARATOR)) >= 0) {
            String resultStr = path.substring(0, separator);
            return TipURLFileSystemHelper.newTipUrl(resultStr);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TipIndex index(URL url) {
        URL rootUrl = TipURLFileSystemHelper.getTipRootUrl(url);
        if (rootUrl == null) {
            return NULL_INDEX;
        }
        Map map = indexes;
        synchronized (map) {
            TipIndex tipIndex = (TipIndex)indexes.get(rootUrl);
            if (tipIndex == null) {
                tipIndex = new TipIndex(rootUrl);
                indexes.put(rootUrl, tipIndex);
            }
            return tipIndex;
        }
    }

    static URL newTipUrl(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class TipEntry {
        private String name;
        private byte[] data;
        private ArrayList children;

        public TipEntry(String name) {
            this.name = TipEntry.sanitize(name);
            this.children = new ArrayList();
        }

        public TipEntry(String name, byte[] data) {
            this.name = TipEntry.sanitize(name);
            this.data = data;
        }

        private static String sanitize(String name) {
            int last;
            if (name == null || name.length() == 0 || "/".equals(name)) {
                return "";
            }
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (name.charAt(last = name.length() - 1) == '/') {
                name = name.substring(0, last);
            }
            return name;
        }

        public void addChild(TipEntry child) {
            this.children.add(child);
        }

        private String getName() {
            return this.name;
        }

        public boolean isFile() {
            return this.data != null;
        }

        public boolean isDirectory() {
            return this.data == null;
        }

        public List getChildren() {
            return this.children;
        }

        public long getLength() {
            return this.data != null ? (long)this.data.length : -1L;
        }

        public InputStream openInputStream() throws IOException {
            if (this.data == null) {
                throw new FileNotFoundException(this.name);
            }
            return new ByteArrayInputStream(this.data);
        }

        public String toString() {
            if (this.data == null) {
                return this.name;
            }
            return this.name + "(" + this.children.size() + ")";
        }
    }

    private static class TipIndex {
        private URL url;
        private Map entries = new HashMap();
        private TipEntry rootEntry;

        public TipIndex() {
        }

        public TipIndex(URL url) {
            assert (!TipURLFileSystemHelper.isTipUrl(url));
            this.url = TipURLFileSystemHelper.newTipUrl(url, "");
            this.rootEntry = new TipEntry("");
            this.entries.put("", this.rootEntry);
            try {
                this.load(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void load(URL url) throws IOException {
            LineIterator iterator = new LineIterator(URLFileSystem.openInputStream(url));
            while (iterator.hasNext()) {
                String entryName;
                int i;
                int start;
                String line = (String)iterator.next();
                if (!line.startsWith("#### ")) continue;
                for (start = 5; start < line.length() && Character.isWhitespace(line.charAt(start)); ++start) {
                }
                if (line.charAt(start) == '#') continue;
                for (i = start + 1; i < line.length() && !Character.isWhitespace(line.charAt(i)); ++i) {
                }
                String directive = line.substring(start, i);
                HashMap<String, String> parameters = new HashMap<String, String>();
                start = ++i;
                while (i < line.length()) {
                    char c;
                    char c2;
                    while (i < line.length() && (c2 = line.charAt(i)) != '=') {
                        if (c2 == ',') {
                            throw new IOException("expected '=' at " + URLFileSystem.getPlatformPathName(url) + ", line " + iterator.getLineCount() + ", column " + i);
                        }
                        ++i;
                    }
                    String name = line.substring(start, i).trim();
                    start = ++i;
                    while (i < line.length() && (c = line.charAt(i)) != ',') {
                        ++i;
                    }
                    String value = line.substring(start, i).trim();
                    parameters.put(name, value);
                }
                if (directive.equals("file")) {
                    entryName = (String)parameters.get("path");
                    if (entryName == null || entryName.length() == 0) {
                        throw new IOException("parameter path missing at " + URLFileSystem.getPlatformPathName(url) + ", line " + iterator.getLineCount());
                    }
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter(data);
                    while (iterator.hasNext()) {
                        String line1 = (String)iterator.next();
                        if (line1.startsWith("#### ")) {
                            int i1;
                            int start1;
                            for (start1 = 5; start1 < line1.length() && Character.isWhitespace(line1.charAt(start1)); ++start1) {
                            }
                            if (line1.charAt(start1) == '#') continue;
                            for (i1 = start1 + 1; i1 < line1.length() && !Character.isWhitespace(line1.charAt(i1)); ++i1) {
                            }
                            String directive1 = line1.substring(start1, i1);
                            if (directive1.equals("file") || directive1.equals("directory")) {
                                iterator.repeat();
                                break;
                            }
                        }
                        writer.write(line1);
                        ((Writer)writer).write(10);
                    }
                    ((Writer)writer).close();
                    this.addEntry(new TipEntry(entryName, data.toByteArray()));
                    continue;
                }
                if (!directive.equals("directory")) continue;
                entryName = (String)parameters.get("path");
                if (entryName == null || entryName.length() == 0) {
                    throw new IOException("parameter path missing at " + URLFileSystem.getPlatformPathName(url) + ", line " + iterator.getLineCount());
                }
                this.addEntry(new TipEntry(entryName));
            }
        }

        private void addEntry(TipEntry entry) {
            String name = entry.getName();
            if (!this.entries.containsKey(name)) {
                TipEntry parentEntry;
                this.entries.put(name, entry);
                int slash = name.lastIndexOf(47);
                if (slash > 0) {
                    String parentName = name.substring(0, slash);
                    parentEntry = (TipEntry)this.entries.get(parentName);
                    if (parentEntry == null) {
                        parentEntry = new TipEntry(parentName);
                        this.addEntry(parentEntry);
                    }
                } else {
                    parentEntry = this.rootEntry;
                }
                parentEntry.addChild(entry);
            }
        }

        public TipEntry getEntry(String name) {
            if (name == null) {
                return null;
            }
            if (name.length() == 0) {
                return this.rootEntry;
            }
            int last = name.length() - 1;
            if (name.charAt(last) == '/') {
                name = name.substring(0, last);
            }
            return (TipEntry)this.entries.get(name);
        }

        public boolean exists(String name) {
            return this.getEntry(name) != null;
        }

        public boolean isFile(String name) {
            TipEntry entry = this.getEntry(name);
            return entry != null ? entry.isFile() : false;
        }

        public boolean isDirectory(String name) {
            TipEntry entry = this.getEntry(name);
            return entry != null ? entry.isDirectory() : false;
        }

        public long getLength(String name) {
            TipEntry entry = this.getEntry(name);
            return entry != null ? entry.getLength() : -1L;
        }

        public URL[] list(String name) {
            TipEntry entry = this.getEntry(name);
            if (entry == null) {
                return null;
            }
            List children = entry.getChildren();
            if (children == null) {
                return null;
            }
            URL[] list = new URL[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                TipEntry child = (TipEntry)children.get(i);
                list[i] = URLFactory.newURL(this.url, child.getName());
            }
            return list;
        }

        public InputStream openInputStream(String name) throws IOException {
            TipEntry entry = this.getEntry(name);
            if (entry == null) {
                throw new FileNotFoundException(name);
            }
            return entry.openInputStream();
        }
    }
}

