/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ide.performance.PerformanceHandler;
import oracle.ide.performance.PerformanceLogRecord;
import oracle.ide.util.Assert;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public final class PerformanceLogger {
    private static Map<Thread, PerformanceLogger> _loggersByThread;
    private int _size = 4;
    private String[] _ids = new String[this._size];
    private long[] _startTimes = new long[this._size];
    private int _depth = 0;
    private boolean unrecoverableError;
    @CodeSharingSafe(value="StaticField")
    private static Handler diagnosticLogHandler;
    @CodeSharingSafe(value="StaticField")
    private static final Logger _realLogger;

    private static Logger initRealLogger() {
        Logger logger = Logger.getLogger(PerformanceLogger.class.getName());
        logger.setUseParentHandlers(false);
        logger.addHandler(new PerformanceHandler());
        PerformanceLogger.attachDiagnosticLogHandler(logger);
        _loggersByThread = new WeakHashMap<Thread, PerformanceLogger>();
        return logger;
    }

    private PerformanceLogger() {
    }

    private Logger getLogger() {
        return _realLogger;
    }

    public void logConfigurationProperty(String key, String value) {
        _realLogger.log(new PropertyLogRecord(key, value));
    }

    public static synchronized PerformanceLogger get() {
        Thread currentThread = Thread.currentThread();
        PerformanceLogger logger = _loggersByThread.get(currentThread);
        if (logger == null) {
            logger = new PerformanceLogger();
            _loggersByThread.put(currentThread, logger);
        }
        return logger;
    }

    private static void attachDiagnosticLogHandler(Logger logger) {
        File diagnosticFile = Diagnostics.newLockedFile("PERFORMANCELOG");
        if (diagnosticFile == null) {
            return;
        }
        try {
            diagnosticLogHandler = new FileHandler(diagnosticFile.getAbsolutePath());
            diagnosticLogHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    if (record instanceof PerformanceLogRecord) {
                        PerformanceLogRecord p = (PerformanceLogRecord)record;
                        return String.format("id=[%s], target=[%s], elapsed=[%s]%n", p.getId(), p.getMessage(), p.getElapsedTime() / 1000000L);
                    }
                    if (record instanceof PropertyLogRecord) {
                        PropertyLogRecord p = (PropertyLogRecord)record;
                        return String.format("%s=%s%n", p.key(), p.value());
                    }
                    return null;
                }

                @Override
                public String getHead(Handler h) {
                    return Diagnostics.basicConfigurationData();
                }
            });
            diagnosticLogHandler.setFilter(new Filter(){

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (record instanceof PropertyLogRecord) {
                        return true;
                    }
                    return record instanceof PerformanceLogRecord && !((PerformanceLogRecord)record).getId().equals("no-id");
                }
            });
            logger.addHandler(diagnosticLogHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void log(Level level, String message) {
        this.getLogger().log(new PerformanceLogRecord(level, message, this._depth));
    }

    @Deprecated
    public void log(Level level, String message, long elapsedTime) {
        if (elapsedTime > 0L) {
            this.getLogger().log(new PerformanceLogRecord(level, message, this._depth, elapsedTime * 1000000L));
        }
    }

    public void log(String id, String message, long elapsedTime) {
        if (PerformanceLogger.isAboveGlobalThreshold(elapsedTime)) {
            this.getLogger().log(new PerformanceLogRecord(Level.INFO, id, message, this._depth, elapsedTime));
        }
    }

    public void startTiming(String id) {
        this.startTiming(id, null);
    }

    public void startTiming(String id, String startMessage) {
        int depth;
        if (id == null) {
            throw new IllegalArgumentException("id null");
        }
        if (this.unrecoverableError) {
            return;
        }
        if (startMessage != null) {
            this.log(Level.INFO, startMessage);
        }
        if ((depth = this._depth++) >= this._size) {
            int newSize = Math.max(this._depth, this._size) * 2;
            this._ids = new String[newSize];
            System.arraycopy(this._ids, 0, this._ids, 0, this._size);
            this._startTimes = new long[newSize];
            System.arraycopy(this._startTimes, 0, this._startTimes, 0, this._size);
        }
        this._ids[depth] = id;
        this._startTimes[depth] = System.nanoTime();
    }

    public void stopTiming(String id, String endMessage) {
        this.stopTiming(id, endMessage, -1);
    }

    public void stopTiming(String id, String endMessage, int threshold) {
        this.stopTiming(id, threshold, endMessage, (Object[])null, false);
    }

    public void stopTiming(String id, int threshold, String endMessage, Object ... arguments) {
        this.stopTiming(id, threshold, endMessage, arguments, true);
    }

    private void stopTiming(String id, int threshold, String endMessage, Object[] arguments, boolean appendId) {
        long actual;
        int depth;
        if (id == null) {
            throw new IllegalArgumentException("id null");
        }
        if (this.unrecoverableError) {
            return;
        }
        if (!id.equals(this._ids[depth = --this._depth])) {
            if (--depth > 0 && id.equals(this._ids[depth])) {
                this.log(Level.SEVERE, "recovering from missing stopTiming for id \"" + this._ids[depth] + "\" on thread " + Thread.currentThread());
                --this._depth;
            } else {
                this.log(Level.SEVERE, "no recovery from missing stopTiming for id \"" + this._ids[depth] + "\" on thread " + Thread.currentThread());
                this.unrecoverableError = true;
            }
        }
        if (endMessage != null && (actual = System.nanoTime() - this._startTimes[depth]) > (long)(threshold * 1000000) && PerformanceLogger.isAboveGlobalThreshold(actual)) {
            if (arguments != null && arguments.length > 0) {
                endMessage = MessageFormat.format(endMessage, arguments);
            }
            if (appendId) {
                endMessage = endMessage + " [" + id + ']';
            }
            this.log(id, endMessage, actual);
        }
    }

    public static boolean isAboveGlobalThreshold(long timingInNanos) {
        return timingInNanos > (long)(1000000 * Assert.printTimingThreshold());
    }

    static {
        diagnosticLogHandler = null;
        _realLogger = PerformanceLogger.initRealLogger();
    }

    private static class PropertyLogRecord
    extends LogRecord {
        private final String key;
        private final String value;

        PropertyLogRecord(String key, String value) {
            super(Level.INFO, key + "=" + value);
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }
    }
}

