/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.VectorBuffers;

abstract class EOLNormalizer {
    private int _countCR = 0;
    private int _countLF = 0;
    private int _countCRLF = 0;
    protected VectorBuffers _buffers = new VectorBuffers();
    private boolean _pushedCR = false;
    private String _eolType = AbstractTextBuffer.platformEOLType;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    EOLNormalizer() {
    }

    public String getEOLType() {
        return this._eolType;
    }

    protected void setEOLType(String eolType) {
        this._eolType = eolType;
    }

    protected char[] copyData(char[] data) {
        char[] copy = new char[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    protected void processStart() {
        this._countCRLF = 0;
        this._countLF = 0;
        this._countCR = 0;
        this._pushedCR = false;
    }

    protected void process(char[] data, int length) {
        int writePos = 0;
        int readPos = 0;
        while (readPos < length) {
            int c = data[readPos++];
            if (this._pushedCR) {
                this._pushedCR = false;
                if (c == 10) {
                    ++this._countCRLF;
                    continue;
                }
                ++this._countCR;
            }
            if (c == 13) {
                this._pushedCR = true;
                c = 10;
            } else if (c == 10) {
                ++this._countLF;
            }
            data[writePos++] = c;
        }
        this._buffers.addBuffer(data, writePos);
    }

    protected char[] processFinish() {
        if (this._pushedCR) {
            ++this._countCR;
        }
        int count = this._countCRLF;
        String eolType = "\r\n";
        if (this._countLF > count) {
            count = this._countLF;
            eolType = "\n";
        }
        if (this._countCR > count) {
            count = this._countCR;
            eolType = "\r";
        }
        if (count > 0) {
            this.setEOLType(eolType);
        }
        return this._buffers.getAllBuffers();
    }

    public abstract char[] normalizeData() throws IOException;

    static EOLNormalizer getNormalizer(char[] data) {
        return new ArrayNormalizer(data);
    }

    static EOLNormalizer getNormalizer(Reader reader) {
        return new ReaderNormalizer(reader);
    }

    static EOLNormalizer getNormalizer(FileChannel channel, CharsetDecoder decoder) {
        return new ChannelNormalizer(channel, decoder);
    }

    private static class ChannelNormalizer
    extends EOLNormalizer {
        private FileChannel _channel;
        private CharsetDecoder _decoder;

        private ChannelNormalizer(FileChannel channel, CharsetDecoder decoder) {
            this._channel = channel;
            this._decoder = decoder;
        }

        @Override
        public char[] normalizeData() throws IOException {
            if (this._channel == null) {
                return AbstractTextBuffer.EMPTY_CHARS;
            }
            if (this._decoder == null) {
                throw new IOException("no charset converter");
            }
            byte[] byteData = new byte[4096];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteData);
            this.processStart();
            while (true) {
                char[] charData = new char[4096];
                CharBuffer charBuffer = CharBuffer.wrap(charData);
                byteBuffer.clear();
                int bytesRead = this._channel.read(byteBuffer);
                if (bytesRead == -1) break;
                byteBuffer.flip();
                charBuffer.clear();
                this._decoder.decode(byteBuffer, charBuffer, false);
                charBuffer.flip();
                this.process(charData, charBuffer.remaining());
            }
            this._channel.close();
            char[] bufferData = this.processFinish();
            return bufferData;
        }
    }

    private static class ReaderNormalizer
    extends EOLNormalizer {
        private Reader _reader;

        private ReaderNormalizer(Reader reader) {
            this._reader = reader;
        }

        @Override
        public char[] normalizeData() throws IOException {
            char[] buffer;
            int charsRead;
            if (this._reader == null) {
                return AbstractTextBuffer.EMPTY_CHARS;
            }
            this.processStart();
            while ((charsRead = this._reader.read(buffer = new char[4096])) != -1) {
                this.process(buffer, charsRead);
            }
            this._reader.close();
            char[] bufferData = this.processFinish();
            return bufferData;
        }
    }

    private static class ArrayNormalizer
    extends EOLNormalizer {
        private char[] _data;

        private ArrayNormalizer(char[] data) {
            this._data = data;
        }

        @Override
        public char[] normalizeData() {
            if (this._data == null) {
                return AbstractTextBuffer.EMPTY_CHARS;
            }
            char[] copy = this.copyData(this._data);
            this.processStart();
            this.process(copy, copy.length);
            char[] bufferData = this.processFinish();
            return bufferData;
        }
    }
}

