/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer2;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.SelfVariable;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InvokeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;

abstract class CompilerLayer3a
extends CompilerLayer2
implements CallerContext.Constants {
    private Map<String, JavaHasType> importedNameCache;

    CompilerLayer3a() {
    }

    public final void setImportedNames(Map<String, JavaHasType> importedNames) {
        this.importedNameCache = importedNames;
    }

    protected final JavaHasType resolveName(TreeSym hasName, JavaHasType primary, boolean ambiguous) {
        String name = hasName.getName();
        if (name.length() == 0) {
            return null;
        }
        return this.resolveName(hasName, primary, hasName.getNameSym(), name, ambiguous);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaHasType resolveName(Sym cookie, JavaHasType primary, Sym nameSym, String name, boolean ambiguous) {
        CompilerContext oldContext = this.getCompilerContext();
        try {
            JavaHasType javaHasType;
            JavaHasType result;
            CompilerContext context = this.newContext(cookie);
            this.setCompilerContext(context);
            if (primary == null) {
                JavaHasType found = this.processSimpleName(name, ambiguous, true);
                if (found == null && !cookie.testSymFlag((byte)64)) {
                    Sym parentSym;
                    Sym errorSym = nameSym != null ? ((parentSym = nameSym.getParentSym()) != null && parentSym.symKind == 73 ? parentSym : nameSym) : cookie;
                    this.error(errorSym, (short)62, name);
                    if (this.flag_forgiving) {
                        found = this.processSimpleName(name, ambiguous, false);
                    }
                }
                result = found;
            } else {
                JavaType primaryType = this.processLhs(primary);
                result = this.processSimpleSelector(name, nameSym, primaryType, ambiguous);
                if (result == null && !cookie.testSymFlag((byte)64)) {
                    JavaType scope = primaryType;
                    String scopeName = scope == null ? primary.getUnresolvedType().getSimplifiedName() : primaryType.getQualifiedName();
                    this.error(nameSym != null ? nameSym : cookie, (short)59, name, scope, scopeName);
                }
            }
            if (result == null) {
                javaHasType = null;
                return javaHasType;
            }
            if (primary != null) {
                context.cleanScope();
                if (primary instanceof JavaType) {
                    context.flag_instance = false;
                }
            }
            if (this.flag_forgiving || context.allowAccess(result, primary)) {
                javaHasType = result;
                return javaHasType;
            }
            this.error(cookie, (short)63, result);
            javaHasType = null;
            return javaHasType;
        }
        finally {
            this.setCompilerContext(oldContext);
        }
    }

    protected final JavaMethod resolveMethodCall(MethodCallExpr e, JavaHasType primary, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, boolean isConstructor) {
        String name = isConstructor ? "<init>" : e.getName();
        if (name.length() == 0) {
            return (JavaMethod)this.error(e, (short)56);
        }
        NameSym nameSym = e.getNameSym();
        Sym cookie = e;
        if (nameSym != null) {
            cookie = nameSym;
        }
        return this.resolveMethodCall(cookie, e, name, primary, typeArguments, arguments, argumentTypes);
    }

    protected final JavaMethod resolveMethodCall(ClassCreatorExpr e, JavaHasType primary, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes) {
        TypeSym typeSym = e.getTypeSym();
        TreeSym cookie = e;
        if (typeSym != null) {
            cookie = typeSym;
        }
        return this.resolveMethodCall(cookie, e, "<init>", primary, typeArguments, arguments, argumentTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod resolveMethodCall(Sym cookie, InvokeExpr invokeExpression, String name, JavaHasType primary, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes) {
        CompilerContext savedContext = this.getCompilerContext();
        try {
            JavaType scopeClass;
            JavaMethod result;
            CompilerContext context = this.newContext(cookie);
            this.setCompilerContext(context);
            boolean hasNullArgument = false;
            int argumentCount = argumentTypes.length;
            for (int i = 0; i < argumentCount; ++i) {
                if (argumentTypes[i] != null) continue;
                hasNullArgument = true;
            }
            if (hasNullArgument) {
                context.suppressErrors = true;
            }
            if ((result = primary == null ? this.processSimpleMethodCall(invokeExpression, name, arguments, argumentTypes, true) : this.processSelectorMethodCall(invokeExpression, name, primary, typeArguments, arguments, argumentTypes, true)) != null) {
                JavaMethod i = result;
                return i;
            }
            String scopeClassName = primary != null ? ((scopeClass = this.processLhs(primary)) == null ? primary.getUnresolvedType().getSimplifiedName() : scopeClass.getQualifiedName()) : ((scopeClass = cookie.getOwningClassSym()) != null ? scopeClass.getQualifiedName() : null);
            this.error(cookie, (short)60, name, argumentTypes, scopeClass, scopeClassName);
            if (!this.flag_forgiving) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            result = primary == null ? this.processSimpleMethodCall(invokeExpression, name, arguments, argumentTypes, false) : this.processSelectorMethodCall(invokeExpression, name, primary, typeArguments, arguments, argumentTypes, false);
            JavaMethod javaMethod = result;
            return javaMethod;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JavaMethod> resolveMethod(Sym cookie, String name, JavaHasType primary, JavaType[] typeArguments) {
        CompilerContext savedContext = this.getCompilerContext();
        List<JavaMethod> result = null;
        try {
            JavaType scopeClass;
            CompilerContext context = this.newContext(cookie);
            this.setCompilerContext(context);
            context.suppressErrors = true;
            result = primary == null ? this.processSimpleMethod(name) : this.processSelectorMethod(name, primary, typeArguments);
            if (result != null && !result.isEmpty()) {
                List<JavaMethod> list = result;
                return list;
            }
            String scopeClassName = primary != null ? ((scopeClass = this.processLhs(primary)) == null ? primary.getUnresolvedType().getSimplifiedName() : scopeClass.getQualifiedName()) : ((scopeClass = cookie.getOwningClassSym()) != null ? scopeClass.getQualifiedName() : null);
            this.error(cookie, (short)60, name, null, scopeClass, scopeClassName);
            List<JavaMethod> list = result;
            return list;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void compileExceptions(Expr e, JavaMethod method) {
        if (this.skipCompilations()) {
            return;
        }
        CompilerContext savedContext = this.getCompilerContext();
        NameSym nameSym = e.getNameSym();
        Sym cookie = e;
        if (nameSym != null) {
            cookie = nameSym;
        }
        try {
            this.setCompilerContext(this.newContext(cookie));
            this.processExceptions(e, method);
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkException(Sym cookie, JavaType thrown) {
        assert (!this.skipCompilations());
        if (thrown == null) {
            return;
        }
        JavaClass javaLangThrowable = this.getPreloadedClass((byte)7);
        if (thrown.isSubtypeOf(javaLangThrowable)) {
            CompilerContext savedContext = this.getCompilerContext();
            try {
                this.setCompilerContext(this.newContext(cookie));
                this.processException(thrown);
            }
            finally {
                this.setCompilerContext(savedContext);
            }
        } else {
            this.error(cookie, (short)67, thrown);
        }
    }

    protected final ClassSym resolveEnclosingScope(Sym inputScope, JavaType target) {
        CompilerContext tmpContext = this.newContext(inputScope);
        Sym scope = tmpContext.cleanAndInitializeScope();
        while (scope != null) {
            ClassSym classSym;
            if (scope.symKind == 3 && (classSym = (ClassSym)scope).isSubtypeOf(target)) {
                return classSym;
            }
            if (scope.isStatic()) break;
            scope = tmpContext.nextScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void listNames(Sym cookie, JavaHasType lhs, InputImpl options, OutputImpl output) {
        if (options.input == 0) {
            return;
        }
        if (lhs == null && ("this".equals(options.name) || "super".equals(options.name))) {
            JavaHasType thisSuper = this.resolveName(cookie, null, null, options.name, true);
            if (thisSuper == null) {
                return;
            }
            lhs = thisSuper;
            options.name = "<init>";
        }
        CompilerContext savedContext = this.getCompilerContext();
        try {
            this.setCompilerContext(this.newContext(cookie));
            if (lhs == null) {
                this.processAllPrimaries(options, output);
            } else {
                this.processAllSelectors(lhs, options, output);
            }
        }
        finally {
            this.setCompilerContext(savedContext);
        }
        if (lhs == null && !options.squash(2) && options.input(2)) {
            options.input = 2;
            JavaPackage root = this.provider.getPackage("");
            this.listNames(cookie, root, options, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void listNames(Sym cookie, JavaPackage lhs, InputImpl options, OutputImpl output) {
        if (lhs == null) {
            if (options.squash(2)) {
                options.input &= 0xFFFFFFFD;
            }
            lhs = this.provider.getPackage("");
        }
        if (options.input == 0) {
            return;
        }
        CompilerContext savedContext = this.getCompilerContext();
        try {
            CompilerContext context = this.newContext(cookie);
            this.setCompilerContext(context);
            context.listNames(lhs, options, output);
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    private JavaHasType processSimpleName(String name, boolean ambiguous, boolean useStrict) {
        boolean thisName = "this".equals(name);
        boolean superName = "super".equals(name);
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym scope = context.cleanAndInitializeScope();
        while (scope != null) {
            switch (scope.symKind) {
                case 3: {
                    ClassSym classSym = (ClassSym)scope;
                    if (thisName) {
                        JavaVariable thing = classSym.getThisVariable();
                        if (!context.flag_instance) {
                            this.error(context.symCookie, (short)68, name);
                        }
                        return thing;
                    }
                    if (superName) {
                        if (context.flag_instance) {
                            return classSym.getSuperVariable();
                        }
                        return classSym.getSuperclass();
                    }
                    if (context.findVisibleVariable(classSym, name)) {
                        return context.findMemberVariable(classSym, name);
                    }
                    if (!ambiguous) break;
                    if (context.findVisibleType(classSym, name)) {
                        return context.findMemberType(classSym, name);
                    }
                    JavaType foundParameter = context.findType(classSym, name);
                    if (foundParameter == null) break;
                    return foundParameter;
                }
                case 57: {
                    JavaType resolvedType;
                    SwitchStmt switchStmt = (SwitchStmt)scope;
                    Expr switchExpr = switchStmt.getExpressionSym();
                    if (switchExpr != null && (resolvedType = switchExpr.getResolvedType()) != null && resolvedType.isEnum()) {
                        if (context.findVisibleVariable(resolvedType, name)) {
                            return context.findMemberVariable(resolvedType, name);
                        }
                        return null;
                    }
                }
                default: {
                    JavaType foundType;
                    JavaVariable foundVariable = context.findVariable(scope, name, useStrict);
                    if (foundVariable != null) {
                        return foundVariable;
                    }
                    if (!ambiguous || (foundType = context.findType(scope, name)) == null) break;
                    return foundType;
                }
            }
            scope = context.nextScope();
        }
        context.cleanScope();
        return this.findImportedName(name, ambiguous);
    }

    private JavaHasType processSimpleSelector(String name, Sym nameSym, JavaType primaryType, boolean ambiguous) {
        SourceClass enclosingType;
        if (primaryType == null) {
            return null;
        }
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        boolean superName = "super".equals(name);
        if (superName && (enclosingType = CompilerLayer3a.getEnclosingType(nameSym)) != null) {
            for (JavaType enclosingSuper = enclosingType.getSuperclass(); enclosingSuper != null; enclosingSuper = enclosingSuper.getOwningClass()) {
                if (!enclosingSuper.equals(primaryType)) continue;
                if (context.flag_instance) {
                    return ((ClassSym)enclosingType).getSuperVariable();
                }
                return enclosingType.getSuperclass();
            }
        }
        if (context.findVisibleVariable(primaryType, name)) {
            return context.findMemberVariable(primaryType, name);
        }
        if (ambiguous && context.findVisibleType(primaryType, name)) {
            return context.findMemberType(primaryType, name);
        }
        return null;
    }

    private JavaMethod processSimpleMethodCall(InvokeExpr invokeExpression, String name, JavaHasType[] arguments, JavaType[] argumentTypes, boolean strict) {
        boolean thisName = "this".equals(name);
        boolean superName = "super".equals(name);
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym scope = context.cleanAndInitializeScope();
        while (scope != null) {
            byte scopeType = scope.symKind;
            if (scopeType == 3) {
                ClassSym classSym = (ClassSym)scope;
                if (thisName || superName) {
                    if (!context.flag_instance) {
                        return (JavaMethod)this.error(context.symCookie, (short)68, name);
                    }
                    JavaType searchClass = classSym;
                    if (superName) {
                        searchClass = classSym.getSuperclass();
                    }
                    if (searchClass == null) {
                        return null;
                    }
                    return context.findMethod(invokeExpression, searchClass, "<init>", null, arguments, argumentTypes, null);
                }
                if (strict) {
                    boolean visible = context.findVisibleMethod(classSym, name);
                    if (visible) {
                        return context.findMethod(invokeExpression, classSym, name, null, arguments, argumentTypes, null);
                    }
                } else {
                    JavaMethod single = context.findSingleMethod(classSym, name, argumentTypes);
                    if (single != null) {
                        return single;
                    }
                }
            }
            scope = context.nextScope();
        }
        if (strict) {
            return this.findImportedMethod(invokeExpression, name, arguments, argumentTypes);
        }
        return null;
    }

    private List<JavaMethod> processSimpleMethod(String name) {
        List<JavaMethod> result = null;
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return result;
        }
        Sym scope = context.cleanAndInitializeScope();
        while (scope != null) {
            ClassSym classSym;
            boolean visible;
            byte scopeType = scope.symKind;
            if (scopeType == 3 && (visible = context.findVisibleMethod(classSym = (ClassSym)scope, name))) {
                return context.findMethods(classSym, name, null, null);
            }
            scope = context.nextScope();
        }
        return this.findImportedMethods(name);
    }

    private JavaMethod processSelectorMethodCall(InvokeExpr invokeExpression, String name, JavaHasType primary, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, boolean strict) {
        JavaMethod m;
        JavaType resolvedType = this.processLhs(primary);
        if (resolvedType == null) {
            return null;
        }
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        if (!(primary.getElementKind() == 21 && "this".equals(((SelfVariable)primary).getName()) || !resolvedType.hasTypeParameters() || resolvedType.hasActualTypeArguments())) {
            resolvedType = CommonUtilities.createTypeErasedClass(this.provider, resolvedType);
        }
        if (strict) {
            if (primary instanceof JavaType) {
                context.flag_instance = "<init>".equals(name);
            }
            return context.findMethod(invokeExpression, resolvedType, name, typeArguments, arguments, argumentTypes, primary);
        }
        if (!"<init>".equals(name) && (m = context.findMethod(invokeExpression, resolvedType, name, typeArguments, arguments, argumentTypes, primary)) != null) {
            return m;
        }
        return context.findSingleMethod(resolvedType, name, argumentTypes);
    }

    private List<JavaMethod> processSelectorMethod(String name, JavaHasType primary, JavaType[] typeArguments) {
        JavaType resolvedType = this.processLhs(primary);
        if (resolvedType == null) {
            return new ArrayList<JavaMethod>();
        }
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return new ArrayList<JavaMethod>();
        }
        context.flag_instance = true;
        if (resolvedType.hasTypeParameters() && !resolvedType.hasActualTypeArguments()) {
            resolvedType = CommonUtilities.createTypeErasedClass(this.provider, resolvedType);
        }
        return context.findMethods(resolvedType, name, typeArguments, primary);
    }

    private void processAllPrimaries(InputImpl options, OutputImpl output) {
        boolean initializedScope;
        Sym scope;
        ClassSym classSym;
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return;
        }
        Sym cookie = context.symCookie;
        if (options.squash(64) && options.input(4) && cookie != null && (classSym = cookie.getOwningClassSym()) != null) {
            output.keys().add(classSym.getName());
        }
        if (cookie == null) {
            scope = context.cleanAndInitializeScope();
            initializedScope = true;
        } else {
            context.cleanScope();
            initializedScope = false;
            scope = cookie;
        }
        while (scope != null) {
            if (options.input == 0) {
                return;
            }
            if (scope.symKind == 3) {
                ClassSym classSym2 = (ClassSym)scope;
                context.listMembers(classSym2, options, output);
            } else {
                context.listNames(scope, options, output);
            }
            if (!initializedScope) {
                initializedScope = true;
                scope = context.initializeScope();
                continue;
            }
            scope = context.nextScope();
        }
    }

    private void processAllSelectors(JavaHasType lhs, InputImpl options, OutputImpl output) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return;
        }
        JavaType resolvedLhs = this.processLhs(lhs);
        if (resolvedLhs == null) {
            return;
        }
        if (options.input(256)) {
            context.flag_instance = true;
        }
        context.listMembers(resolvedLhs, options, output);
    }

    private JavaType processLhs(JavaHasType primary) {
        if (primary == null) {
            return null;
        }
        JavaType resolvedType = primary.getResolvedType();
        if (resolvedType == null) {
            return null;
        }
        if (primary.getElementKind() == 8 && !this.jdkVersion.isJdk8OrAbove() && resolvedType instanceof ParameterizedClass) {
            resolvedType = ((ParameterizedClass)resolvedType).eraseUnresolvedMethodTypeArguments((JavaMethod)primary);
        }
        if (resolvedType.isPrimitive()) {
            this.error(null, (short)57, resolvedType);
            return resolvedType;
        }
        CompilerContext context = this.getCompilerContext();
        if (context != null) {
            if (primary instanceof JavaType) {
                context.flag_instance = false;
            } else {
                context.flag_static = false;
            }
        }
        return resolvedType;
    }

    private void processExceptions(Expr e, JavaMethod method) {
        assert (!this.skipCompilations());
        if (method == null) {
            return;
        }
        for (JavaType exception : method.getExceptions()) {
            JavaClass cloneable;
            JavaType lhsType;
            if ("clone".equals(method.getName()) && "java/lang/CloneNotSupportedException".equals(exception.getVMName()) && ((lhsType = this.processLhs(e.getResolvedLhs())) == null || (cloneable = this.provider.getClassByVMName("java/lang/Cloneable")) != null && lhsType.isSubtypeOf(cloneable))) continue;
            this.processException(exception);
        }
    }

    public boolean isUncheckedException(JavaType javaType) {
        JavaClass runtimeException = this.getPreloadedClass((byte)5);
        if (javaType.isSubtypeOf(runtimeException)) {
            return true;
        }
        JavaClass error = this.getPreloadedClass((byte)2);
        return javaType.isSubtypeOf(error);
    }

    private final void processException(JavaType thrown) {
        assert (!this.skipCompilations());
        if (this.isUncheckedException(thrown)) {
            return;
        }
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return;
        }
        Sym scope = context.cleanAndInitializeScope();
        while (scope != null && !context.checkException(scope, thrown)) {
            scope = context.nextScope();
        }
    }

    private JavaMethod findImportedMethod(InvokeExpr invokeExpression, String name, JavaHasType[] arguments, JavaType[] argumentTypes) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        context.cleanAndInitializeScope();
        return context.findImportedMethod(invokeExpression, name, arguments, argumentTypes);
    }

    private List<JavaMethod> findImportedMethods(String name) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return new ArrayList<JavaMethod>();
        }
        context.cleanAndInitializeScope();
        return context.findImportedMethods(name);
    }

    private JavaHasType findImportedName(String name, boolean ambiguous) {
        JavaHasType found = null;
        Map<String, JavaHasType> currentCache = this.importedNameCache;
        if (currentCache != null && currentCache.containsKey(name)) {
            found = currentCache.get(name);
            if (found != null) {
                return found;
            }
            if (ambiguous) {
                return this.findImportedType(name);
            }
            return null;
        }
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        context.cleanAndInitializeScope();
        found = context.findImportedVariable(name);
        if (currentCache != null) {
            currentCache.put(name, found);
        }
        if (found == null && ambiguous) {
            return this.findImportedType(name);
        }
        return found;
    }

    protected final JavaHasType processExpression(Expr e) {
        JavaElement out = e.resolve((CompilerDriver)this);
        if (out != null) {
            return (JavaHasType)out;
        }
        return null;
    }

    protected final JavaType processExpressionType(Expr e, boolean typeAllowed) {
        boolean typeIsFine;
        JavaHasType hasType = this.processExpression(e);
        if (hasType == null) {
            return null;
        }
        if (e.symKind == 79) {
            JavaType returnType;
            if (hasType instanceof JavaMethod && (returnType = ((JavaMethod)hasType).getReturnType()) != null && "void".equals(returnType.getRawName())) {
                return returnType;
            }
            return e.getResolvedType();
        }
        boolean bl = typeIsFine = e.getSymbolKind() == 78;
        if (!typeIsFine && e.getSymbolKind() == 72) {
            SourceExpression questionOperand = e.getSecondOperand();
            if (questionOperand != null && questionOperand.getSymbolKind() == 78) {
                typeIsFine = true;
            } else {
                questionOperand = e.getThirdOperand();
                if (questionOperand != null && questionOperand.getSymbolKind() == 78) {
                    typeIsFine = true;
                }
            }
        }
        if (!typeIsFine && hasType instanceof JavaType) {
            JavaType type = (JavaType)hasType;
            if (!typeAllowed) {
                this.error(e, (short)74, type);
            }
            return (JavaType)hasType;
        }
        return hasType.getResolvedType();
    }
}

