/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceModuleProvides;
import oracle.javatools.parser.java.v2.model.SourceModuleProvidesWith;
import oracle.javatools.parser.java.v2.model.SourceName;

public class ModuleProvidesSym
extends TreeSym
implements SourceModuleProvides {
    public boolean equals(Object o) {
        if (o instanceof ModuleProvidesSym) {
            ModuleProvidesSym other = (ModuleProvidesSym)o;
            if (this.getName().equals(other.getName())) {
                return this.getSourceModuleProvidesWith().equals(other.getSourceModuleProvidesWith());
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.getSourceModuleProvidesWith().hashCode();
    }

    @Override
    public int getElementKind() {
        return 17;
    }

    @Override
    public String getServiceInterface() {
        return this.getName();
    }

    @Override
    public void setServiceInterface(String serviceInterface) {
        if (!ModuleSym.isValidServiceInterfaceName(serviceInterface)) {
            throw new IllegalArgumentException("Not a valid service interface name: " + serviceInterface);
        }
        this.setName(serviceInterface);
    }

    @Override
    public Collection<String> getServiceImplementations() {
        if (this.hasSourceModuleProvidesWith()) {
            List<SourceName> serviceImplementations = this.getSourceModuleProvidesWith().getServiceImplementations();
            ArrayList<String> names = new ArrayList<String>(serviceImplementations.size());
            for (SourceName serviceImplementation : serviceImplementations) {
                names.add(serviceImplementation.getName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasSourceModuleProvidesWith() {
        return this.getChild((byte)39) != null;
    }

    @Override
    public SourceModuleProvidesWith getSourceModuleProvidesWith() {
        return (SourceModuleProvidesWith)((Object)this.getChildOrCreateSkeleton((byte)39));
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        if (symKind == 20 || symKind == 39) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                return 0;
            }
            case 39: {
                return this.getChild((byte)20) != null ? 1 : 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(' ');
        buffer.append(this.getServiceInterface());
        Collection<String> serviceImplementations = this.getServiceImplementations();
        if (serviceImplementations != null && !serviceImplementations.isEmpty()) {
            buffer.append(" with ");
            String comma = "";
            for (String serviceImplementation : serviceImplementations) {
                buffer.append(comma);
                buffer.append(serviceImplementation);
                comma = ", ";
            }
        }
    }
}

