/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import oracle.javatools.util.NamedThreadFactory;

public final class Executors {
    private Executors() {
    }

    public static ThreadFactory namedThreadFactory(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName is null");
        }
        return new NamedThreadFactory(baseName);
    }

    public static void shutdown(final ExecutorService executor) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                executor.shutdown();
                return null;
            }
        };
        Executors.perform(action);
    }

    public static List<Runnable> shutdownNow(final ExecutorService executor) {
        PrivilegedAction<List<Runnable>> action = new PrivilegedAction<List<Runnable>>(){

            @Override
            public List<Runnable> run() {
                return executor.shutdownNow();
            }
        };
        return Executors.perform(action);
    }

    private static <T> T perform(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }
}

