/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util.deferred;

public abstract class Thunk<T> {
    private State s = State.INITIALIZED;
    private T value;

    public T get() {
        return this.s.get(this);
    }

    public T getIfSet() {
        if (this.s == State.COMPUTED) {
            return this.getValue();
        }
        return null;
    }

    protected abstract T compute();

    protected T getValue() {
        return this.value;
    }

    protected void setValue(T value) {
        this.value = value;
    }

    protected void resetState() {
        this.s = State.INITIALIZED;
    }

    public static <T> Thunk<T> synchronizedThunk(final Thunk<T> thunk) {
        return new Thunk<T>(){
            private Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object object = this.lock;
                synchronized (object) {
                    return super.get();
                }
            }

            @Override
            protected T compute() {
                return thunk.compute();
            }
        };
    }

    public static <T> Thunk<T> directReference(final T object) {
        return new Thunk<T>(){

            @Override
            protected T compute() {
                return object;
            }
        };
    }

    private static enum State {
        INITIALIZED{

            @Override
            public <T> T get(Thunk<T> thunk) {
                thunk.setValue(thunk.compute());
                ((Thunk)thunk).s = COMPUTED;
                return thunk.getValue();
            }
        }
        ,
        COMPUTED{

            @Override
            public <T> T get(Thunk<T> thunk) {
                return thunk.getValue();
            }
        };


        public abstract <T> T get(Thunk<T> var1);
    }

    public static class ThunkException
    extends RuntimeException {
        public ThunkException(Throwable cause) {
            super(cause);
        }

        public ThunkException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

