/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dbtools.common.Translatables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.i18n.Translatable;

class TranslatableTemplate
implements Translatable {
    private final Class<?> baseClass;
    private final String defaultTemplate;
    private final String messageId;

    TranslatableTemplate(Class<?> baseClass, String messageId, String defaultTemplate) {
        this.baseClass = baseClass;
        this.messageId = messageId;
        this.defaultTemplate = defaultTemplate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TranslatableTemplate other = (TranslatableTemplate)obj;
        if (this.baseClass == null ? other.baseClass != null : !this.baseClass.getName().equals(other.baseClass.getName())) {
            return false;
        }
        if (this.defaultTemplate == null ? other.defaultTemplate != null : !this.defaultTemplate.equals(other.defaultTemplate)) {
            return false;
        }
        return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseClass == null ? 0 : this.baseClass.getName().hashCode());
        result = 31 * result + (this.defaultTemplate == null ? 0 : this.defaultTemplate.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        return result;
    }

    public String toString() {
        return this.toString(Iterables.iterable(Locale.getDefault()));
    }

    public String toString(Iterable<Locale> localePreference) {
        String value;
        ResourceBundle bundle;
        String template = this.defaultTemplate;
        if (this.baseClass != null && (bundle = Translatables.getBundle(this.baseClass, localePreference)) != null && (value = bundle.getString(this.messageId)) != null) {
            template = value;
        }
        return template;
    }
}

