/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.dbtools.common.reflect.MethodInvocation;
import oracle.dbtools.common.reflect.MethodInvocationDecorator;
import oracle.dbtools.common.reflect.MethodInvocationImpl;
import oracle.dbtools.common.util.Closeables;

public class MethodInvocationHandler
implements InvocationHandler {
    private final MethodInvocationDecorator decorator;
    private final Object target;

    public MethodInvocationHandler(Object target, MethodInvocationDecorator decorator) {
        this.target = target;
        this.decorator = decorator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        MethodInvocationImpl original = new MethodInvocationImpl(proxy, this.target, method, args);
        MethodInvocation modifiedInvocation = this.decorator.before(original);
        try {
            result = modifiedInvocation.method().invoke(modifiedInvocation.target(), modifiedInvocation.parameters());
            Object modifiedResult = this.decorator.after(result, modifiedInvocation);
            return modifiedResult;
        }
        catch (InvocationTargetException e) {
            Closeables.close(result);
            Throwable t = e.getCause();
            for (Class<?> ex : method.getExceptionTypes()) {
                if (!ex.isAssignableFrom(t.getClass())) continue;
                throw this.decorator.onException(t, modifiedInvocation);
            }
            throw this.decorator.onException(t, modifiedInvocation);
        }
        catch (Throwable t) {
            Closeables.close(result);
            throw t;
        }
    }
}

