/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.xml;

import java.util.Arrays;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.xml.XMLSerializerOptions;
import oracle.dbtools.objects.ImmutableBean;

class XMLSerializerOptionsImpl
implements XMLSerializerOptions,
ImmutableBean {
    private final Set<QName> cdataElements;
    private final boolean emitDecl;
    private final int indent;

    private XMLSerializerOptionsImpl(Set<QName> cdataElements, int indent, boolean emitDecl) {
        this.cdataElements = cdataElements;
        this.indent = indent;
        this.emitDecl = emitDecl;
    }

    @Override
    public Set<QName> cdataElements() {
        return this.cdataElements;
    }

    @Override
    public boolean emitDecl() {
        return this.emitDecl;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XMLSerializerOptions)) {
            return false;
        }
        XMLSerializerOptions other = (XMLSerializerOptions)obj;
        if (!XMLSerializerOptionsImpl._equals(this.cdataElements, other.cdataElements())) {
            return false;
        }
        if (!XMLSerializerOptionsImpl._equals(this.indent, other.indent())) {
            return false;
        }
        return XMLSerializerOptionsImpl._equals(this.emitDecl, other.emitDecl());
    }

    public int hashCode() {
        int result = XMLSerializerOptionsImpl._hashCode(this.cdataElements, this.indent, this.emitDecl);
        return result;
    }

    @Override
    public int indent() {
        return this.indent;
    }

    @Override
    public Builder modify() {
        return XMLSerializerOptionsImpl.builder(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XMLSerializerOptionsImpl [");
        builder.append("cdataElements=");
        builder.append(this.cdataElements);
        builder.append("indent=");
        builder.append(this.indent);
        builder.append("emitDecl=");
        builder.append(this.emitDecl);
        builder.append("]");
        return builder.toString();
    }

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(XMLSerializerOptions existing) {
        return new Builder(existing);
    }

    private static boolean _equals(Object obj1, Object obj2) {
        if (null == obj1) {
            return null == obj2;
        }
        return obj1.equals(obj2);
    }

    private static int _hashCode(Object ... values) {
        return Arrays.hashCode(values);
    }

    static class Dependencies {
        Dependencies() {
        }
    }

    static class Builder
    implements XMLSerializerOptions.Builder {
        private final ImmutableSet.Builder<QName> cdataElements = Immutables.sets().builder();
        private boolean emitDecl;
        private int indent;

        Builder() {
        }

        Builder(XMLSerializerOptions existing) {
            this();
            this.cdataElements.add((QName)((Object)existing.cdataElements()));
            this.indent = existing.indent();
            this.emitDecl = existing.emitDecl();
        }

        @Override
        public XMLSerializerOptions build() {
            return new XMLSerializerOptionsImpl(this.cdataElements.build(), this.indent, this.emitDecl);
        }

        @Override
        public Builder cdata(QName ... elements) {
            for (QName element : elements) {
                this.cdataElements.add(element);
            }
            return this;
        }

        @Override
        public Builder emitDecl(boolean emitDecl) {
            this.emitDecl = emitDecl;
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof XMLSerializerOptions)) {
                return false;
            }
            XMLSerializerOptions other = (XMLSerializerOptions)obj;
            if (!XMLSerializerOptionsImpl._equals(this.cdataElements, other.cdataElements())) {
                return false;
            }
            if (!XMLSerializerOptionsImpl._equals(this.indent, other.indent())) {
                return false;
            }
            return XMLSerializerOptionsImpl._equals(this.emitDecl, other.emitDecl());
        }

        public int hashCode() {
            int result = XMLSerializerOptionsImpl._hashCode(new Object[]{this.cdataElements, this.indent, this.emitDecl});
            return result;
        }

        @Override
        public Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("XMLSerializerOptionsImpl [");
            builder.append("cdataElements=");
            builder.append(this.cdataElements);
            builder.append("indent=");
            builder.append(this.indent);
            builder.append("emitDecl=");
            builder.append(this.emitDecl);
            builder.append("]");
            return builder.toString();
        }
    }
}

