/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdeveloper.library.Library;

abstract class LibrarySearchQueryFilter {
    protected String m_queryText;
    protected final String m_originalQueryText;

    public LibrarySearchQueryFilter(String queryText) {
        this.m_originalQueryText = queryText;
        this.m_queryText = queryText;
    }

    public abstract boolean queryLibraries(DefaultMutableTreeNode var1, SearchProgress var2);

    public abstract void filterSearchResults(DefaultMutableTreeNode var1);

    public abstract Icon getHitChildIcon();

    public void preSearch(DefaultMutableTreeNode treeRoot) {
    }

    public void postSearch() {
    }

    public List<DefaultMutableTreeNode> getLibraryTreeNodeSubset(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> allChildrenUnderRoot = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode nextChild = (DefaultMutableTreeNode)root.getChildAt(i);
            if (nextChild.getUserObject() instanceof Library) {
                allChildrenUnderRoot.add(nextChild);
            }
            if (nextChild.getChildCount() <= 0) continue;
            allChildrenUnderRoot.addAll(this.getLibraryTreeNodeSubset(nextChild));
        }
        return allChildrenUnderRoot;
    }

    public static void removeLibraryTreeNodeByLibraryName(List<DefaultMutableTreeNode> libraryTreeNodes, String libraryName) {
        for (int i = 0; i < libraryTreeNodes.size(); ++i) {
            String libraryNameFromUserObject;
            DefaultMutableTreeNode libraryNode = libraryTreeNodes.get(i);
            if (!(libraryNode.getUserObject() instanceof Library) || !libraryName.equals(libraryNameFromUserObject = ((Library)libraryNode.getUserObject()).getName())) continue;
            libraryTreeNodes.remove(i);
            return;
        }
    }

    public static String findAndEscapeDollarSigns(String source) {
        StringBuffer resultBuffer = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '$') {
                resultBuffer.append(source.charAt(i));
                continue;
            }
            resultBuffer.append("\\$");
        }
        return resultBuffer.toString();
    }

    public static String findAndChangeQuestionMarksToDots(String source) {
        StringBuffer resultBuffer = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '?') {
                resultBuffer.append(source.charAt(i));
                continue;
            }
            resultBuffer.append(".");
        }
        return resultBuffer.toString();
    }

    public static String findAndScapeBackwardSlashDotAndStar(String source) {
        StringBuffer resultBuffer = new StringBuffer();
        block5: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '.': {
                    resultBuffer.append("\\.");
                    continue block5;
                }
                case '*': {
                    resultBuffer.append(".*");
                    continue block5;
                }
                case '\\': {
                    char next = LibrarySearchQueryFilter.nextChar(source, i + 1);
                    if (next == '\\') {
                        ++i;
                    }
                    if (next != '.') {
                        resultBuffer.append("\\\\");
                        continue block5;
                    }
                    resultBuffer.append("\\");
                    continue block5;
                }
                default: {
                    resultBuffer.append(c);
                }
            }
        }
        return resultBuffer.toString();
    }

    private static final char nextChar(String source, int index) {
        if (index >= source.length()) {
            return '\u0000';
        }
        return source.charAt(index);
    }

    private static final char prevChar(StringBuffer source) {
        int index = source.length() - 1;
        if (index < 0) {
            return '\u0000';
        }
        return source.charAt(index);
    }

    public final Pattern compilePattern() {
        String patternString = LibrarySearchQueryFilter.findAndScapeBackwardSlashDotAndStar(this.m_queryText);
        patternString = LibrarySearchQueryFilter.findAndEscapeDollarSigns(patternString);
        patternString = LibrarySearchQueryFilter.findAndChangeQuestionMarksToDots(patternString);
        patternString = patternString + "$";
        return Pattern.compile(patternString);
    }
}

