/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.components;

import java.awt.Component;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.sdovis.JSDOGeometry;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ROWID;

public class MapViewerHelper {
    public static String[] getMarkerNamesArray() {
        String[] stringArray = new String[]{SpatialArb.getString("Circle"), SpatialArb.getString("Star"), SpatialArb.getString("Rect"), SpatialArb.getString("Arrow")};
        return stringArray;
    }

    public static Connection getCurrentTabCnx() throws Exception {
        return Connections.getInstance().getConnection(SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getCurrentConnectionName());
    }

    public static boolean isValidSpatialQuery(String string, Connection connection) throws Exception {
        String string2;
        Statement statement = connection.createStatement();
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        int n = 0;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        for (int i = 1; i <= n2; ++i) {
            int n4 = resultSetMetaData.getColumnType(i);
            if (n4 != 2002) continue;
            arrayList.add(i);
        }
        if (arrayList.size() > 1) {
            resultSet.close();
            statement.close();
            throw new Exception(SpatialArb.getString("NonUniqueGeomColumnException"));
        }
        if (arrayList.size() < 1) {
            resultSet.close();
            statement.close();
            throw new Exception(SpatialArb.getString("NoSpatialColumnException"));
        }
        ResultSet resultSet2 = statement2.executeQuery("SELECT COUNT(*) AS TOTAL FROM ( " + string + ")");
        for (String string3 : list) {
            String string4;
            if (!string3.matches(string4 = ".*Xmx.*")) continue;
            string2 = string3.substring(4, string3.length() - 1);
            n = Integer.parseInt(string2);
        }
        while (resultSet2.next()) {
            boolean bl;
            int n5 = resultSet2.getInt(1);
            boolean bl2 = false;
            if (n < 256 && n5 > 100) {
                bl2 = true;
            } else if (n < 512 && n5 > 1000) {
                bl2 = true;
            } else if (n5 > 5000) {
                bl2 = true;
            }
            if (!bl2 || (bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)(SpatialArb.getString("HeavyTask1") + n5 + " " + SpatialArb.getString("HeavyTask2") + SpatialArb.getString("HeavyTask3") + " (" + n + " MB)"), (String)SpatialArb.getString("HeavyTaskTitle"), null))) continue;
            return false;
        }
        int n6 = 0;
        while (resultSet.next()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n7 = (Integer)iterator.next();
                string2 = JSDOGeometry.load((byte[])resultSet.getBytes(n7));
                int n8 = string2.getSRID();
                int n9 = string2.getDimensions();
                if (n6 == 0) {
                    n3 = n8;
                }
                if (n8 != n3) {
                    resultSet.close();
                    statement.close();
                    throw new Exception(SpatialArb.getString("NonUniqueSRIDException"));
                }
                if (n9 <= 2) continue;
                resultSet.close();
                statement.close();
                throw new Exception(SpatialArb.getString("Non2dElementDetectedException"));
            }
            ++n6;
        }
        String[] stringArray = new String[resultSetMetaData.getColumnCount()];
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            stringArray[i - 1] = resultSetMetaData.getColumnName(i);
        }
        String string5 = MapViewerHelper.buildLabelsAndGeomQuery(string, stringArray, resultSetMetaData.getColumnName((Integer)arrayList.get(0)));
        resultSet = statement.executeQuery(string5);
        resultSet.close();
        statement.close();
        return true;
    }

    public static boolean isConnectionValid(Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            if (connection.isClosed()) {
                return false;
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public static boolean isDuplicatedTitleInTable(String string, TableModel tableModel) {
        List list = ((SpatialReorderableTableModel)((Object)tableModel)).getRowList();
        for (int i = 0; i < list.size(); ++i) {
            QueryObject queryObject = (QueryObject)list.get(i);
            if (!queryObject.getQueryTitle().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String purgeLastSemicolon(String string) {
        if (string.trim().endsWith(";")) {
            string = string.replace(";", "");
        }
        return string;
    }

    public static String[] getColumnNames(String string, Connection connection) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        Object[] objectArray = new String[]{""};
        Vector<String> vector = new Vector<String>();
        vector.add("");
        for (int i = 1; i <= n; ++i) {
            int n3 = resultSetMetaData.getColumnType(i);
            String string2 = resultSetMetaData.getColumnName(i);
            if (n3 == 2002 || string2.equals("ROWID")) continue;
            vector.add(string2);
        }
        resultSet.close();
        statement.close();
        n2 = n - vector.size();
        if (vector.size() == 0) {
            return objectArray;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Vector<Integer[]> getQuerySRIDS(String string, Connection connection) throws Exception {
        int n;
        Vector<Integer[]> vector = new Vector<Integer[]>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string.trim());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int n3 = 0;
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int i = 1; i <= n2; ++i) {
            n = resultSetMetaData.getColumnType(i);
            if (n != 2002) continue;
            ++n3;
            vector2.add(i);
        }
        if (n3 == 0) {
            return vector;
        }
        while (resultSet.next()) {
            Integer[] integerArray = new Integer[vector2.size()];
            n = 0;
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                JGeometry jGeometry = JSDOGeometry.load((byte[])resultSet.getBytes(n4));
                integerArray[n] = jGeometry.getSRID();
                ++n;
            }
            vector.add(integerArray);
        }
        return vector;
    }

    public static boolean isSRIDUnique(int n, Vector<Integer[]> vector) {
        for (Integer[] integerArray : vector) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (n == integerArray[i]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areQuerySRIDsValid(int n, Vector<Integer[]> vector) {
        if (vector.isEmpty()) {
            return true;
        }
        boolean bl = MapViewerHelper.isSRIDUnique(vector.get(0)[0], vector);
        if (n == -10 && bl) {
            return true;
        }
        return bl && MapViewerHelper.isSRIDUnique(n, vector);
    }

    public static List<HashMap<String, String>> getColumnValuesMaps(ResultSet resultSet) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        ArrayList<HashMap<String, String>> arrayList = new ArrayList<HashMap<String, String>>(n);
        for (int i = 0; i < n; ++i) {
            HashMap hashMap = new HashMap();
            arrayList.add(hashMap);
        }
        while (resultSet.next()) {
            ROWID rOWID = new ROWID(resultSet.getBytes("ROWID"));
            block12: for (int i = 1; i <= n; ++i) {
                int n2 = resultSetMetaData.getColumnType(i);
                HashMap<String, String> hashMap = arrayList.get(i - 1);
                String string = " ";
                switch (n2) {
                    case -1: 
                    case 1: 
                    case 12: {
                        string = resultSet.getString(i);
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case 4: {
                        string = Integer.toString(resultSet.getInt(i));
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case 5: {
                        string = Short.toString(resultSet.getShort(i));
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case -5: {
                        string = Long.toString(resultSet.getLong(i));
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case 7: {
                        string = Float.toString(resultSet.getFloat(i));
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case 6: {
                        string = Double.toString(resultSet.getDouble(i));
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case 8: {
                        string = Double.toString(resultSet.getDouble(i));
                        if (string == null) {
                            string = "";
                        }
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                    case 2: {
                        BigDecimal bigDecimal = resultSet.getBigDecimal(i);
                        string = bigDecimal == null ? "" : bigDecimal.toString();
                        hashMap.put(rOWID.stringValue(), string);
                        continue block12;
                    }
                }
            }
        }
        return arrayList;
    }

    public static String buildLabelsAndGeomQuery(String string, String[] stringArray, String string2) {
        String string3 = "SELECT ROWID, " + string2 + ", ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = i < stringArray.length - 1 ? stringArray[i] + "," : stringArray[i];
            string3 = string3 + string4;
        }
        string3 = string3 + " FROM (" + string + " )";
        return string3;
    }

    public static JGeometry[] getQueryGeometries(String string, Connection connection) throws Exception {
        JGeometry[] jGeometryArray = new JGeometry[]{};
        ArrayList<JGeometry> arrayList = new ArrayList<JGeometry>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 1;
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n2 = resultSetMetaData.getColumnType(i);
            if (n2 != 2002) continue;
            n = i;
            break;
        }
        while (resultSet.next()) {
            JGeometry jGeometry = JSDOGeometry.load((byte[])resultSet.getBytes(n));
            arrayList.add(jGeometry);
        }
        jGeometryArray = arrayList.toArray(jGeometryArray);
        return jGeometryArray;
    }

    public static boolean isGeometryValid(Struct struct, Connection connection) throws SQLException, Exception {
        boolean bl = false;
        String string = "SELECT SDO_GEOM.VALIDATE_GEOMETRY_WITH_CONTEXT(\n  ?,\n  0.5\n  ) IS_VALID FROM DUAL";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setObject(1, struct);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string2;
            String string3;
            Object object = resultSet.getObject("IS_VALID");
            if (!(object instanceof String) || !(string3 = (String)object).equals(string2 = "TRUE")) continue;
            bl = true;
        }
        return bl;
    }
}

