/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnErrorDialog;
import oracle.dbtools.rest.connection.RestConnection;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.utils.RestCache;
import oracle.dbtools.rest.utils.RestJSONUtil;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.utils.RestXMLUtil;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class RestUpload {
    private static final String XML_CONTENT_TYPE = "application/vnd.oracle.apex+xml; charset=UTF-8";
    private static String _errMsg;
    private String _entityTag;
    private String _location;

    public static boolean uploadModule(List<RestModule> list) {
        if (list != null) {
            RestModule restModule;
            boolean bl = false;
            Iterator<RestModule> iterator = list.iterator();
            while (iterator.hasNext() && (bl = RestUpload.uploadModule(restModule = iterator.next()))) {
            }
            return bl;
        }
        return false;
    }

    public static boolean uploadModule(RestModule restModule, boolean bl) {
        if (restModule == null) {
            return false;
        }
        if (bl && RestUtils.emptyValue(restModule.getEntityTag()) && RestCache.getInstance().containsModule(restModule.getName())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RestArb.format("OBJECT_EXIST_UPDATE", RestArb.getString("LABEL_MODULE_LC"), restModule.getName())).append(System.getProperty("line.separator")).append(RestArb.getString("QUESTION_CONTINUE"));
            boolean bl2 = MessageDialog.confirm(null, (Object)stringBuilder.toString(), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            if (bl2) {
                RestModule restModule2 = RestCache.getInstance().getModule(restModule.getName());
                restModule.setURL(restModule2.getURL());
                restModule.setEntityTag(restModule2.getEntityTag());
            } else {
                return false;
            }
        }
        return RestUpload.uploadModule(restModule);
    }

    public static boolean uploadModule(final RestModule restModule) {
        if (restModule == null) {
            return false;
        }
        _errMsg = null;
        boolean bl = false;
        RestUpload restUpload = new RestUpload();
        bl = restModule.getURL() == null || restModule.getURL().isEmpty() ? restUpload.uploadNewModule(restModule) : restUpload.uploadExistingModule(restModule);
        if (bl) {
            if (restUpload.getEntityTag() != null) {
                restModule.setEntityTag(restUpload.getEntityTag());
            } else {
                Logger.getLogger(RestUpload.class.getName()).log(Level.WARNING, "Entity Tag is Missing.");
            }
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information(null, (Object)RestArb.format("REST_STATUS", RestArb.getString("LABEL_MODULE"), restModule.getName(), RestArb.getString("UPLOADED")), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        } else {
            final String string = RestUtils.emptyValue(restUpload.getErrorMessage()) ? RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()) : restUpload.getErrorMessage();
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.error(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadNewModule(RestModule restModule) {
        boolean bl = false;
        if (restModule != null && RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            try {
                stringEntity = new StringEntity(RestXMLUtil.resourceModuletoXML(restModule), "UTF-8");
                stringEntity.setContentType(XML_CONTENT_TYPE);
                HttpPost httpPost = RestConnection.getInstance().getConnection().createPost("/rt/modules/");
                httpPost.setEntity((HttpEntity)stringEntity);
                bl = this.upload((HttpUriRequest)httpPost);
                if (bl) {
                    restModule.setURL(this._location);
                }
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName());
                _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()) + "\n" + exception.getMessage());
            }
            finally {
                if (stringEntity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)stringEntity);
                    }
                    catch (Exception exception) {
                        stringEntity = null;
                    }
                }
            }
        } else {
            String string = RestArb.format("ERROR_UPLOAD", "LABEL_MODULE", restModule.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean uploadExistingModule(RestModule restModule) {
        boolean bl = false;
        if (RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            try {
                stringEntity = new StringEntity(RestXMLUtil.resourceModuletoXML(restModule), "UTF-8");
                stringEntity.setContentType(XML_CONTENT_TYPE);
                HttpPut httpPut = RestConnection.getInstance().getConnection().createPut(new URI(restModule.getURL()));
                httpPut.setEntity((HttpEntity)stringEntity);
                bl = this.upload((HttpUriRequest)httpPut);
                if (bl) return bl;
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName());
                _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
                return bl;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()) + "\n" + exception.getMessage());
                return bl;
            }
            finally {
                if (stringEntity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)stringEntity);
                    }
                    catch (Exception exception) {
                        stringEntity = null;
                    }
                }
            }
        }
        String string = RestArb.format("ERROR_UPLOAD", "LABEL_MODULE", restModule.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
        RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        return bl;
    }

    public static boolean uploadPrivilege(List<RestPrivilege> list) {
        if (list != null) {
            RestPrivilege restPrivilege;
            boolean bl = false;
            Iterator<RestPrivilege> iterator = list.iterator();
            while (iterator.hasNext() && (bl = RestUpload.uploadPrivilege(restPrivilege = iterator.next()))) {
            }
            return bl;
        }
        return false;
    }

    public static boolean uploadPrivilege(RestPrivilege restPrivilege, boolean bl) {
        if (restPrivilege == null) {
            return false;
        }
        if (bl && RestUtils.emptyValue(restPrivilege.getEntityTag()) && RestCache.getInstance().containsPrivilege(restPrivilege.getName())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RestArb.format("OBJECT_EXIST_UPDATE", RestArb.getString("LABEL_PRIVILEGE_LC"), restPrivilege.getName())).append(System.getProperty("line.separator")).append(RestArb.getString("QUESTION_CONTINUE"));
            boolean bl2 = MessageDialog.confirm(null, (Object)stringBuilder.toString(), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            if (bl2) {
                RestPrivilege restPrivilege2 = RestCache.getInstance().getPrivilege(restPrivilege.getName());
                restPrivilege.setURL(restPrivilege2.getURL());
                restPrivilege.setEntityTag(restPrivilege2.getEntityTag());
            } else {
                return false;
            }
        }
        return RestUpload.uploadPrivilege(restPrivilege);
    }

    public static boolean uploadPrivilege(final RestPrivilege restPrivilege) {
        if (restPrivilege == null) {
            return false;
        }
        _errMsg = null;
        boolean bl = false;
        RestUpload restUpload = new RestUpload();
        bl = restPrivilege.getURL() == null || restPrivilege.getURL().isEmpty() ? restUpload.uploadNewPrivilege(restPrivilege) : restUpload.uploadExistingPrivilege(restPrivilege);
        if (bl) {
            if (restUpload.getEntityTag() != null) {
                restPrivilege.setEntityTag(restUpload.getEntityTag());
            }
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information(null, (Object)RestArb.format("REST_STATUS", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName(), RestArb.getString("UPLOADED")), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        } else {
            final String string = RestUtils.emptyValue(restUpload.getErrorMessage()) ? RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName()) : restUpload.getErrorMessage();
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.error(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadNewPrivilege(RestPrivilege restPrivilege) {
        boolean bl = false;
        if (restPrivilege != null && RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            try {
                stringEntity = new StringEntity(RestJSONUtil.restPrivilegetoJSON(restPrivilege));
                stringEntity.setContentType("application/json");
                HttpPost httpPost = RestConnection.getInstance().getConnection().createPost("/oauth2/scopes/");
                httpPost.setEntity((HttpEntity)stringEntity);
                bl = this.upload((HttpUriRequest)httpPost);
                if (bl) {
                    restPrivilege.setURL(this._location);
                }
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
            }
            catch (Exception exception) {
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string, exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName()) + "\n" + exception.getMessage());
            }
            finally {
                if (stringEntity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)stringEntity);
                    }
                    catch (Exception exception) {
                        stringEntity = null;
                    }
                }
            }
        } else {
            String string = RestArb.format("ERROR_UPLOAD", "LABEL_PRIVILEGE", restPrivilege.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean uploadExistingPrivilege(RestPrivilege restPrivilege) {
        boolean bl = false;
        if (restPrivilege != null && RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            try {
                stringEntity = new StringEntity(RestJSONUtil.restPrivilegetoJSON(restPrivilege));
                stringEntity.setContentType("application/json");
                HttpPut httpPut = RestConnection.getInstance().getConnection().createPut(new URI(restPrivilege.getURL()));
                httpPut.setEntity((HttpEntity)stringEntity);
                bl = this.upload((HttpUriRequest)httpPut);
                if (bl) return bl;
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
                return bl;
            }
            catch (Exception exception) {
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string, exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName()) + "\n" + exception.getMessage());
                return bl;
            }
            finally {
                if (stringEntity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)stringEntity);
                    }
                    catch (Exception exception) {
                        stringEntity = null;
                    }
                }
            }
        }
        String string = RestArb.format("ERROR_UPLOAD", "LABEL_PRIVILEGE", restPrivilege.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
        RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        return bl;
    }

    private boolean upload(HttpUriRequest httpUriRequest) throws SessionException {
        this._entityTag = null;
        httpUriRequest.addHeader("Accept-Language", Locale.getDefault().toString());
        boolean bl = (Boolean)RestConnection.getInstance().getConnection().executeRequest(httpUriRequest, (ResponseHandler)new ResponseHandler<Boolean>(){

            public Boolean handleResponse(HttpResponse httpResponse) {
                String string;
                String string2;
                StatusLine statusLine = httpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                if (n == 200 || n == 201) {
                    Header header = httpResponse.getFirstHeader("ETag");
                    if (header != null) {
                        RestUpload.this._entityTag = header.getValue();
                    }
                    if ((header = httpResponse.getFirstHeader("Location")) != null) {
                        RestUpload.this._location = header.getValue();
                    } else {
                        RestUpload.this._location = null;
                    }
                    return new Boolean(true);
                }
                String string3 = "";
                Header header = httpResponse.getFirstHeader("Error-Reason");
                if (header != null && !RestUtils.emptyValue(string2 = header.getValue()) && !RestUtils.emptyValue(string = RestConnection.getInstance().getErrorReasonDetails(string2))) {
                    string3 = "\n" + string;
                }
                string2 = RestArb.format("RESPONSE_STATUS", Integer.toString(n), statusLine.getReasonPhrase()) + string3;
                RestUpload.this.setErrorMessage(string2);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string2);
                return new Boolean(false);
            }
        });
        return bl;
    }

    private void setErrorMessage(String string) {
        _errMsg = string;
    }

    public String getErrorMessage() {
        if (_errMsg != null) {
            return _errMsg;
        }
        return "";
    }

    private String getEntityTag() {
        return this._entityTag;
    }

    private static void runOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

