/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class ConnectionPanel
extends JPanel {
    private static String DEFAULT_DB_HOST = "localhost";
    private static String DEFAULT_DB_PORT = "1521";
    private static String DEFAULT_DB_SERVICNAME = "orcl";
    private static String TNSNAMES_ORA = "tnsnames.ora";
    private CONNECTION_TYPES[] _ctList = CONNECTION_TYPES.values();
    private JPanel _connPanel;
    private JPanel _connTypePanel;
    private JPanel _basicPanel;
    private JPanel _tnsPanel;
    private JPanel _customUrlPanel;
    private BasicEditorPane _customUrlEditor;
    private URLFileChooser.URLFileChooserPanel _tnsNamesChooser;
    private JComboBox<String> _connType;
    private JTextField _hostname;
    private JTextField _port;
    private JTextField _sid;
    private JTextField _servicename;
    private JRadioButton _sidBtn;
    private JRadioButton _servicenameBtn;
    private JComboBox<String> _tnsAliasNamesCB;
    private DefaultComboBoxModel<String> _model;

    public ConnectionPanel(Map<String, String> map) {
        this.init(map);
    }

    private void init(Map<String, String> map) {
        String string = map.get("db.connectionType");
        if (InstallUtils.nullOrEmpty(string) || !string.equalsIgnoreCase("basic") && !string.equalsIgnoreCase("tns") && !string.equalsIgnoreCase("customurl")) {
            string = "basic";
        }
        string = string.toLowerCase();
        boolean bl = this.showConnectionType(map);
        this.initPanel(string, bl);
        switch (string) {
            case "tns": {
                this.setTNSValues(map);
                break;
            }
            case "customurl": {
                this.setCustomUrlValues(map);
                break;
            }
            default: {
                this.setBasicValues(map);
            }
        }
    }

    private void initPanel(String string, boolean bl) {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(200, 275));
        int n = 0;
        if (bl) {
            this._connTypePanel = this.getConnectionTypePanel(string);
            this.add((Component)this._connTypePanel, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 23, 2, new Insets(0, 8, 0, 8), 0, 0));
            this._connPanel = this.getConnPanel();
        } else {
            this._connPanel = this.getBasicConnectionPanel();
        }
        CONNECTION_TYPES cONNECTION_TYPES = this._ctList[this._connType.getSelectedIndex()];
        if (cONNECTION_TYPES == CONNECTION_TYPES.CUSTOMURL) {
            this.add((Component)this._connPanel, new GridBagConstraints(0, 1, 2, 4, 1.0, 1.0, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        } else {
            this.add((Component)this._connPanel, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        }
    }

    private JPanel getConnectionTypePanel(String string) {
        CONNECTION_TYPES cONNECTION_TYPES = CONNECTION_TYPES.valueOf(string.toUpperCase());
        this._connType = new JComboBox<String>(this.getConnectionTypes());
        this._connType.setSelectedIndex(cONNECTION_TYPES.ordinal());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this._connType, (String)RestArb.getString("CONN_TYPE"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 0, 3, 6), 0, 0));
        jPanel.add(this._connType, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 0, 3, 8), 0, 0));
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)2);
        this._connType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ConnectionPanel.this.changeConnTypePanel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return jPanel;
    }

    private void changeConnTypePanel() {
        this.remove(this._connPanel);
        this._connPanel = this.getConnPanel();
        CONNECTION_TYPES cONNECTION_TYPES = this._ctList[this._connType.getSelectedIndex()];
        if (cONNECTION_TYPES == CONNECTION_TYPES.CUSTOMURL) {
            this.add((Component)this._connPanel, new GridBagConstraints(0, 1, 2, 4, 1.0, 1.0, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        } else {
            this.add((Component)this._connPanel, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        }
        this._connPanel.revalidate();
        this._connPanel.repaint();
    }

    private JPanel getConnPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        CONNECTION_TYPES cONNECTION_TYPES = this._ctList[this._connType.getSelectedIndex()];
        switch (cONNECTION_TYPES) {
            case TNS: {
                jPanel = this.getTNSConnectionPanel();
                break;
            }
            case CUSTOMURL: {
                jPanel = this.getCustomURLPanel();
                break;
            }
            default: {
                jPanel = this.getBasicConnectionPanel();
            }
        }
        return jPanel;
    }

    private JPanel getBasicConnectionPanel() {
        if (this._basicPanel != null) {
            return this._basicPanel;
        }
        this._basicPanel = new JPanel(new GridBagLayout());
        this._hostname = new JTextField();
        this._port = new JTextField();
        this._sid = new JTextField();
        this._servicename = new JTextField();
        this._sidBtn = new JRadioButton();
        this._servicenameBtn = new JRadioButton();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._hostname, (String)RestArb.getString("HOST"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._port, (String)RestArb.getString("PORT"));
        ResourceUtils.resButton((AbstractButton)this._sidBtn, (String)RestArb.getString("SID"));
        ResourceUtils.resButton((AbstractButton)this._servicenameBtn, (String)RestArb.getString("SERVICE_NAME"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._sidBtn);
        buttonGroup.add(this._servicenameBtn);
        this._servicenameBtn.setSelected(true);
        this.enableDisableSidServiceNameFields();
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this._hostname, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this._port, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this._servicenameBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this._servicename, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this._sidBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this._sid, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        this._basicPanel = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("CONN_TYPE_BASIC"), (Component)jPanel);
        this._sidBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ConnectionPanel.this.enableDisableSidServiceNameFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._servicenameBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ConnectionPanel.this.enableDisableSidServiceNameFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return this._basicPanel;
    }

    private void enableDisableSidServiceNameFields() {
        this._sid.setEnabled(this._sidBtn.isSelected());
        this._servicename.setEnabled(this._servicenameBtn.isSelected());
    }

    private JPanel getTNSConnectionPanel() {
        if (this._tnsPanel != null) {
            return this._tnsPanel;
        }
        this._tnsPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this._tnsAliasNamesCB, (String)RestArb.getString("TNS_ALIAS_NAME"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("TNS_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        this._tnsNamesChooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)RestArb.getString("FILE_NAME"), (String)RestArb.getString("WIZ_SELECT_TNS_FILE"), (boolean)false, (boolean)true, (String)RestArb.getString("BROWSE_BTN"));
        this._tnsNamesChooser.setEnabled(true);
        this._tnsNamesChooser.clearChooseableURLFilters();
        WildcardURLFilter wildcardURLFilter = new WildcardURLFilter(TNSNAMES_ORA, URLFileSystem.isLocalFileSystemCaseSensitive(), RestArb.getString("ORA_FILTER_NAME"));
        this._tnsNamesChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        this._tnsNamesChooser.setSelectionScope(0);
        this._tnsNamesChooser.setSelectionMode(0);
        this._tnsNamesChooser.setShowJarsAsDirs(false);
        this._tnsNamesChooser.setCheckIfFileExists(true);
        this._tnsNamesChooser.setPathContext("REST_TNS_FILE");
        this._tnsNamesChooser.setText(null);
        this.initTnsNamesComboBox();
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this._tnsNamesChooser, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add(this._tnsAliasNamesCB, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._tnsPanel = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("CONN_TYPE_TNS"), (Component)jPanel);
        this._tnsNamesChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel.this.updateTNSPanel();
            }
        });
        return this._tnsPanel;
    }

    private void initTnsNamesComboBox() {
        Path path;
        File file;
        List list = null;
        File file2 = null;
        String string = DBConfig.getInstance().getString("TNS_NAMES_DIR");
        if (!RestUtils.nullOrEmpty(string) && (file = new File(string)).isDirectory() && (path = Paths.get(string, new String[0]).resolve(TNSNAMES_ORA)) != null && this.verifyTnsNamesOraExist(path.toFile())) {
            try {
                list = TNSHelper.parseTnsFile((File)path.toFile());
                file2 = path.toFile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this._model = new DefaultComboBoxModel();
        this.updateModel(list);
        this._tnsAliasNamesCB = new JComboBox();
        this._tnsAliasNamesCB.setModel(this._model);
        if (this._tnsNamesChooser != null) {
            this._tnsNamesChooser.setSelectedFile(file2);
        }
    }

    private void updateModel(List<TCPTNSEntry> list) {
        if (this._model.getSize() > 0) {
            this._model.removeAllElements();
        }
        if (list != null) {
            for (TCPTNSEntry tCPTNSEntry : list) {
                this._model.addElement(tCPTNSEntry.getName());
            }
        }
    }

    private JPanel getCustomURLPanel() {
        if (this._customUrlPanel != null) {
            return this._customUrlPanel;
        }
        this._customUrlPanel = LayoutControl.GBC.createPanel();
        JScrollPane jScrollPane = this.customUrlEditor();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jScrollPane, (String)RestArb.getString("CUSTOM_URL"));
        this._customUrlPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)4, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        UIUtils.makeTitledBorder((JComponent)this._customUrlPanel, (String)RestArb.getString("CONN_TYPE_CUSTOM"));
        return this._customUrlPanel;
    }

    private JScrollPane customUrlEditor() {
        this._customUrlEditor = EditorFactory.createIdeEditorPane();
        this._customUrlEditor.setDocument((Document)new BasicDocument("foo.plsql"));
        this._customUrlEditor.installPlugin((EditorPlugin)new LineGutterPlugin());
        this._customUrlEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._customUrlEditor.installPlugin((EditorPlugin)new HighlightEditorPlugin());
        this._customUrlEditor.setPreferredSize(null);
        JScrollPane jScrollPane = new JScrollPane((Component)this._customUrlEditor, 22, 32);
        jScrollPane.setPreferredSize(this._customUrlEditor.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        return jScrollPane;
    }

    private String[] getConnectionTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CONNECTION_TYPES cONNECTION_TYPES : CONNECTION_TYPES.values()) {
            arrayList.add(cONNECTION_TYPES.getNLSName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void updateConnectionPanel(Map<String, String> map) {
        String string = this.getDbConnType(map.get("db.connectionType"));
        boolean bl = this.showConnectionType(map);
        this.remove(this._connPanel);
        if (this._connType != null) {
            this.remove(this._connTypePanel);
        }
        if (!bl) {
            string = "basic";
        }
        this.initPanel(string, bl);
        switch (string) {
            case "tns": {
                this.setTNSValues(map);
                break;
            }
            case "customurl": {
                this.setCustomUrlValues(map);
                break;
            }
            default: {
                this.setBasicValues(map);
            }
        }
        if (bl && this._connType != null) {
            this._connTypePanel.revalidate();
            this._connTypePanel.repaint();
        }
        this._connPanel.revalidate();
        this._connPanel.repaint();
    }

    private void updateTNSPanel() {
        File file = this._tnsNamesChooser.getSelectedFile();
        String string = null;
        if (this.verifyTnsNamesOraExist(file)) {
            try {
                List list = TNSHelper.parseTnsFile((File)file);
                this.updateModel(list);
                this._tnsAliasNamesCB.revalidate();
                this._tnsAliasNamesCB.repaint();
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
        } else {
            string = RestArb.getString("WIZ_ERR_INVALID_FILE");
        }
        if (string != null) {
            this.updateModel(null);
            this._tnsAliasNamesCB.revalidate();
            this._tnsAliasNamesCB.repaint();
        }
    }

    private boolean verifyTnsNamesOraExist(File file) {
        String string;
        return file != null && file.isFile() && (string = file.getName()) != null && string.equalsIgnoreCase(TNSNAMES_ORA);
    }

    private String getDbConnType(String string) {
        String string2 = string;
        if (InstallUtils.nullOrEmpty(string2) || !string2.equalsIgnoreCase("basic") && !string2.equalsIgnoreCase("tns") && !string2.equalsIgnoreCase("customurl")) {
            string2 = "basic";
        }
        return string2.toLowerCase();
    }

    private void setBasicValues(Map<String, String> map) {
        this._hostname.setText(map.get("db.hostname") != null ? map.get("db.hostname") : DEFAULT_DB_HOST);
        this._port.setText(map.get("db.port") != null ? map.get("db.port") : DEFAULT_DB_PORT);
        String string = map.get("db.servicename");
        String string2 = map.get("db.sid");
        if (!InstallUtils.nullOrEmpty(string)) {
            this._servicenameBtn.setSelected(true);
            this._servicename.setText(string);
        } else if (!InstallUtils.nullOrEmpty(string2)) {
            this._sidBtn.setSelected(true);
            this._sid.setText(string2);
        } else {
            this._servicenameBtn.setSelected(true);
            this._servicename.setText(DEFAULT_DB_SERVICNAME);
        }
        this.enableDisableSidServiceNameFields();
    }

    private void setTNSValues(Map<String, String> map) {
        boolean bl;
        String string;
        File file;
        String string2 = map.get("db.tnsDirectory");
        String string3 = map.get("db.tnsAliasName");
        if (!InstallUtils.nullOrEmpty(string2) && (file = new File(string = string2 + File.separatorChar + TNSNAMES_ORA)) != null && file.isFile() && (bl = this.verifyAliasName(file, string3, new StringBuilder()))) {
            this._tnsNamesChooser.setSelectedFile(file);
            this._tnsAliasNamesCB.setSelectedItem(string3);
        }
    }

    private void setCustomUrlValues(Map<String, String> map) {
        if (!InstallUtils.nullOrEmpty(map.get("db.customURL"))) {
            this._customUrlEditor.setText(map.get("db.customURL"));
        }
    }

    private void validateBasicConnType() throws TraversalException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (this._hostname.getText() == null || this._hostname.getText().trim().length() == 0) {
            stringBuilder.append(RestArb.getString("ERROR_HOST_MISSING"));
            this._hostname.requestFocus();
        }
        if (this._port.getText() == null || this._port.getText().trim().length() == 0) {
            if (stringBuilder.toString().length() > 0) {
                stringBuilder.append("\n");
            } else {
                this._port.requestFocus();
            }
            stringBuilder.append(RestArb.getString("ERROR_PORT_MISSING"));
        }
        String string2 = string = this._sidBtn.isSelected() ? this._sid.getText() : this._servicename.getText();
        if (string == null || string.trim().length() == 0) {
            if (stringBuilder.toString().length() > 0) {
                stringBuilder.append("\n");
            } else if (this._sidBtn.isSelected()) {
                this._sid.requestFocus();
            } else {
                this._servicename.requestFocus();
            }
            stringBuilder.append(this._sidBtn.isSelected() ? RestArb.getString("ERROR_SID_MISSING") : RestArb.getString("ERROR_SERVICENAME_MISSING"));
        }
        if (stringBuilder.toString().length() > 0) {
            throw new TraversalException(stringBuilder.toString());
        }
    }

    private void validateTNSConnType() throws TraversalException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._tnsNamesChooser != null) {
            File file = this._tnsNamesChooser.getSelectedFile();
            if (!this.verifyTnsNamesOraExist(file)) {
                stringBuilder.append(RestArb.getString("WIZ_ERR_INVALID_FILE")).append("\n");
                this._tnsNamesChooser.requestFocus();
            } else if (this._tnsAliasNamesCB != null) {
                String string = (String)this._tnsAliasNamesCB.getSelectedItem();
                if (RestUtils.nullOrEmpty(string)) {
                    stringBuilder.append(RestArb.getString("ERROR_TNS_ALIAS_MISSING"));
                    this._tnsAliasNamesCB.requestFocus();
                } else {
                    this.verifyAliasName(file, string, stringBuilder);
                }
            }
            if (stringBuilder.toString().length() > 0) {
                throw new TraversalException(stringBuilder.toString());
            }
        }
        if (stringBuilder.toString().length() > 0) {
            throw new TraversalException(stringBuilder.toString());
        }
    }

    private boolean verifyAliasName(File file, String string, StringBuilder stringBuilder) {
        List list = null;
        try {
            list = TNSHelper.parseTnsFile((File)file);
        }
        catch (IOException iOException) {
            stringBuilder.append(iOException.getLocalizedMessage());
            this._tnsAliasNamesCB.requestFocus();
            return false;
        }
        String string2 = null;
        for (TCPTNSEntry tCPTNSEntry : list) {
            if (!string.equalsIgnoreCase(tCPTNSEntry.getName())) continue;
            string2 = tCPTNSEntry.getJDBCUrl();
            break;
        }
        if (InstallUtils.nullOrEmpty(string2)) {
            stringBuilder.append(RestArb.getString("ERROR_TNS_ALIAS_MISSING"));
            this._tnsAliasNamesCB.requestFocus();
            return false;
        }
        return true;
    }

    private void validateCustomUrlConnType() throws TraversalException {
        String string = null;
        String string2 = null;
        try {
            string2 = this._customUrlEditor.getText();
        }
        catch (Exception exception) {
            this._customUrlEditor.requestFocus();
            throw new TraversalException(exception.getLocalizedMessage());
        }
        if (InstallUtils.nullOrEmpty(string2)) {
            string = RestArb.getString("ERROR_CUSTOM_URL_MISSING");
            this._customUrlEditor.requestFocus();
            throw new TraversalException(string);
        }
    }

    private boolean showConnectionType(Map<String, String> map) {
        String string = map.get("product.version");
        return !InstallUtils.nullOrEmpty(string) && !string.startsWith("3.0.") && !string.startsWith("17.") && !string.startsWith("18.") && !string.startsWith("19.1.") && !string.startsWith("19.2.");
    }

    public Properties getProperties() throws TraversalException {
        Properties properties = new Properties();
        CONNECTION_TYPES cONNECTION_TYPES = this._connType != null ? this._ctList[this._connType.getSelectedIndex()] : CONNECTION_TYPES.BASIC;
        switch (cONNECTION_TYPES) {
            case BASIC: {
                properties.put("db.connectionType", "basic");
                properties.put("db.hostname", this._hostname.getText());
                properties.put("db.port", this._port.getText());
                if (this._servicenameBtn.isSelected()) {
                    properties.put("db.servicename", this._servicename.getText());
                    break;
                }
                properties.put("db.sid", this._sid.getText());
                break;
            }
            case TNS: {
                properties.put("db.connectionType", "tns");
                String string = (String)this._tnsAliasNamesCB.getSelectedItem();
                properties.put("db.tnsAliasName", string);
                File file = this._tnsNamesChooser.getSelectedFile();
                String string2 = null;
                if (file != null) {
                    string2 = file.getParentFile().getAbsolutePath();
                }
                if (string2 == null) {
                    string2 = "";
                }
                properties.put("db.tnsDirectory", string2);
                break;
            }
            case CUSTOMURL: {
                properties.put("db.connectionType", "customurl");
                properties.put("db.customURL", this._customUrlEditor.getText());
                break;
            }
            default: {
                throw new TraversalException(RestArb.getString("ERROR_UNKNOWN_CONN_TYPE"));
            }
        }
        return properties;
    }

    public void validateValues() throws TraversalException {
        CONNECTION_TYPES cONNECTION_TYPES = this._connType != null ? this._ctList[this._connType.getSelectedIndex()] : CONNECTION_TYPES.BASIC;
        switch (cONNECTION_TYPES) {
            case BASIC: {
                this.validateBasicConnType();
                break;
            }
            case TNS: {
                this.validateTNSConnType();
                break;
            }
            case CUSTOMURL: {
                this.validateCustomUrlConnType();
                break;
            }
            default: {
                throw new TraversalException(RestArb.getString("ERROR_UNKNOWN_CONN_TYPE"));
            }
        }
    }

    public void setConnValues(Map<String, String> map, Properties properties) {
        String string = properties.getProperty("db.connectionType");
        if (string == null) {
            string = "basic";
        }
        map.put("db.connectionType", properties.getProperty("db.connectionType"));
        switch (string) {
            case "basic": {
                map.put("db.hostname", properties.getProperty("db.hostname"));
                map.put("db.port", properties.getProperty("db.port"));
                if (!InstallUtils.nullOrEmpty(properties.getProperty("db.servicename"))) {
                    map.put("db.servicename", properties.getProperty("db.servicename"));
                    map.remove("db.sid");
                    break;
                }
                map.put("db.sid", properties.getProperty("db.sid"));
                map.remove("db.servicename");
                break;
            }
            case "tns": {
                map.put("db.tnsAliasName", properties.getProperty("db.tnsAliasName"));
                map.put("db.tnsDirectory", properties.getProperty("db.tnsDirectory"));
                break;
            }
            case "customurl": {
                map.put("db.customURL", properties.getProperty("db.customURL"));
            }
        }
    }

    private static enum CONNECTION_TYPES {
        BASIC("basic", RestArb.getString("CONN_TYPE_BASIC")),
        TNS("tns", RestArb.getString("CONN_TYPE_TNS")),
        CUSTOMURL("customurl", RestArb.getString("CONN_TYPE_CUSTOM"));

        private String type;
        private String nlsName;

        private CONNECTION_TYPES(String string2, String string3) {
            this.type = string2;
            this.nlsName = string3;
        }

        public String getType() {
            return this.type;
        }

        public String getNLSName() {
            return this.nlsName;
        }
    }
}

