/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.dbtools.rest.install.wizard.InstallVerifyUserDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class InstallWizAPEXUsersPanel
extends DefaultTraversablePanel {
    private JPanel m_titledPublicPanel;
    private JPanel m_titledListenerPanel;
    private JTextPane m_publicDescrip = new JTextPane();
    private JTextPane m_listenerDescrip = new JTextPane();
    private JButton m_verifyBtn = new JButton();
    private JCheckBox m_useAPEXRestCB = new JCheckBox();
    private JLabel m_publicUsername = new JLabel();
    private JPasswordField m_publicPassword = new JPasswordField();
    private JPasswordField m_publicConfirmPassword = new JPasswordField();
    private JLabel m_listenerUsername = new JLabel();
    private JPasswordField m_listenerPassword = new JPasswordField();
    private JPasswordField m_listenerConfirmPassword = new JPasswordField();
    private String m_installer;
    private String m_prevConnInfo = "";
    private boolean m_canMigrateAPEXRest;
    private boolean m_init;

    public InstallWizAPEXUsersPanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_publicUsername.setText("APEX_REST_PUBLIC_USER");
        this.m_listenerUsername.setText("APEX_LISTENER");
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_verifyBtn, (String)RestArb.getString("VERIFY_BTN"));
        ResourceUtils.resButton((AbstractButton)this.m_useAPEXRestCB, (String)RestArb.getString("WIZ_USE_APEX_REST"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_publicUsername, (String)StringUtils.stripMnemonic((String)RestArb.getString("USERNAME")));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_publicPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_publicConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_listenerUsername, (String)StringUtils.stripMnemonic((String)RestArb.getString("USERNAME")));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.m_listenerPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this.m_listenerConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this.m_verifyBtn, (String)RestArb.getString("VERIFY_DB_USERS"));
        this.m_publicDescrip.setText(RestArb.getString("WIZ_APEX_PUBLIC_USER_DESCRIP"));
        this.m_publicDescrip.setEditable(false);
        this.m_publicDescrip.setOpaque(false);
        this.m_publicDescrip.setRequestFocusEnabled(false);
        this.m_publicDescrip.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this.m_publicDescrip, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_publicUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_publicPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_publicConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        this.m_titledPublicPanel = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_APEX_PUBLIC_USER"), (Component)jPanel);
        this.m_listenerDescrip.setText(RestArb.getString("WIZ_APEX_LISTENER_DESCRIP"));
        this.m_listenerDescrip.setEditable(false);
        this.m_listenerDescrip.setOpaque(false);
        this.m_listenerDescrip.setRequestFocusEnabled(false);
        this.m_listenerDescrip.setFocusable(false);
        n = 0;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        jPanel2.add((Component)this.m_listenerDescrip, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_listenerUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jLabel5, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_listenerPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jLabel6, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_listenerConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        this.m_titledListenerPanel = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_APEX_LISTENER"), (Component)jPanel2);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jLabel7, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_verifyBtn, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        n = 0;
        this.add(this.m_useAPEXRestCB, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        this.add(this.m_titledPublicPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this.m_titledListenerPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.enableDisableOptions(false);
        this.m_useAPEXRestCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InstallWizAPEXUsersPanel.this.enableDisableOptions(InstallWizAPEXUsersPanel.this.m_useAPEXRestCB.isSelected());
            }
        });
    }

    private void enableDisableOptions(boolean bl) {
        this.m_titledPublicPanel.setEnabled(bl);
        this.m_publicDescrip.setEnabled(bl);
        this.m_publicUsername.setEnabled(bl);
        this.m_publicPassword.setEnabled(bl);
        this.m_publicConfirmPassword.setEnabled(bl);
        this.m_titledListenerPanel.setEnabled(bl);
        this.m_listenerUsername.setEnabled(bl);
        this.m_listenerPassword.setEnabled(bl);
        this.m_listenerConfirmPassword.setEnabled(bl);
        this.m_listenerDescrip.setEnabled(bl);
        this.m_verifyBtn.setEnabled(bl);
    }

    private void validateValues() throws TraversalException {
        InstallValidator.validatePasswords(this.m_publicUsername.getText(), this.m_publicPassword, this.m_publicConfirmPassword);
        InstallValidator.validatePasswords(this.m_listenerUsername.getText(), this.m_listenerPassword, this.m_listenerConfirmPassword);
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            final Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            boolean bl = Boolean.valueOf((String)map2.get("rest.services.apex.add"));
            this.m_useAPEXRestCB.setSelected(bl);
            ActionListener[] actionListenerArray = this.m_verifyBtn.getActionListeners();
            if (actionListenerArray != null) {
                for (ActionListener actionListener : actionListenerArray) {
                    this.m_verifyBtn.removeActionListener(actionListener);
                }
            }
            this.m_verifyBtn.addActionListener(new ActionListener(){
                final Map<String, String> params;
                {
                    this.params = map2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InstallWizAPEXUsersPanel.this.validateUsers(this.params);
                }
            });
        }
    }

    protected void validateUsers(Map<String, String> map) {
        String string = map.get("db.url");
        if (string == null || string.isEmpty()) {
            return;
        }
        try {
            this.validateValues();
        }
        catch (TraversalException traversalException) {
            MessageDialog.error((Component)((Object)this), (Object)traversalException.getMessage(), (String)RestArb.getString("VERIFY_DB_USERS"), null);
            return;
        }
        String string2 = null;
        if ("tns".equals(map.get("db.connectionType"))) {
            if (!InstallUtils.nullOrEmpty(map.get("db.tnsDirectory"))) {
                string2 = map.get("db.tnsDirectory");
            } else {
                MessageDialog.error((Component)((Object)this), (Object)RestArb.getString("ERROR_TNS_DIR_MISSING"), (String)RestArb.getString("VERIFY_DB_USERS"), null);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = this.verifyDBUserConnection(string, "APEX_REST_PUBLIC_USER", this.m_publicPassword, string2);
        if (string3 != null) {
            stringBuilder.append(RestArb.format("ERR_CONN_FAILED", "APEX_REST_PUBLIC_USER", string, string3)).append("\n");
            arrayList.add("APEX_REST_PUBLIC_USER");
        } else {
            stringBuilder.append(RestArb.format("VALID_DB_CONN", "APEX_REST_PUBLIC_USER", string)).append("\n\n");
        }
        string3 = this.verifyDBUserConnection(string, "APEX_LISTENER", this.m_listenerPassword, string2);
        if (string3 != null) {
            stringBuilder.append(RestArb.format("ERR_CONN_FAILED", "APEX_LISTENER", string, string3)).append("\n");
            arrayList.add("APEX_LISTENER");
        } else {
            stringBuilder.append(RestArb.format("VALID_DB_CONN", "APEX_LISTENER", string)).append("\n\n");
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            boolean bl = false;
            Map<String, String> map2 = null;
            if (!map.containsKey("sys.user") && !map.containsKey("sys.password")) {
                InstallVerifyUserDialog installVerifyUserDialog = new InstallVerifyUserDialog();
                if (installVerifyUserDialog.checkUser((Component)((Object)this), string, stringArray, string2)) {
                    map2 = installVerifyUserDialog.getUserAccounts();
                    if (map2 == null) {
                        stringBuilder.append(RestArb.format("CANNOT_VERIFY_DB_ACCOUNT_STATUS", installVerifyUserDialog.getErrorMessage()));
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else {
                try {
                    map2 = InstallDBUtils.getUserStatus(string, string2, InstallDBUtils.getDBAUsername(map.get("sys.user")), map.get("sys.password"), stringArray);
                }
                catch (Exception exception) {
                    stringBuilder.append(exception.getLocalizedMessage()).append("\n");
                }
            }
            if (!bl) {
                if (map2 == null) {
                    stringBuilder.append(RestArb.getString("ERROR_VERIFY_APEX_REST_ACCT"));
                } else {
                    for (String string4 : arrayList) {
                        if (map2.containsKey(string4.toUpperCase())) {
                            stringBuilder.append(RestArb.format("ACCOUNT_STATUS", string4, map2.get(string4)));
                        } else {
                            stringBuilder.append(RestArb.format("USER_NOT_FOUND", string4));
                        }
                        stringBuilder.append("\n");
                    }
                }
            }
        }
        MessageDialog.information((Component)((Object)this), (Object)stringBuilder.toString(), (String)RestArb.getString("VERIFY_DB_USERS"), null);
    }

    private String verifyDBUserConnection(String string, String string2, JPasswordField jPasswordField, String string3) {
        String string4 = new String(jPasswordField.getPassword());
        String string5 = InstallDBUtils.validateConnection(string, string2, string4, string3);
        return string5;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_installer = (String)map2.get("installer");
            if (this.m_useAPEXRestCB.isSelected()) {
                this.validateValues();
                map2.put("user.name.apex.restpublic", "APEX_REST_PUBLIC_USER");
                String string = "@" + Passwords.goingOut((String)new String(this.m_publicPassword.getPassword()));
                map2.put("user.apex.restpublic.password", string);
                map2.put("user.name.apex.listener", "APEX_LISTENER");
                string = "@" + Passwords.goingOut((String)new String(this.m_listenerPassword.getPassword()));
                map2.put("user.apex.listener.password", string);
            } else {
                map2.remove("APEX_REST_PUBLIC_USER");
                map2.remove("user.apex.restpublic.password");
                map2.remove("user.name.apex.listener");
                map2.remove("user.apex.listener.password");
                if (this.m_installer.equals("install")) {
                    String string = (String)map2.get("db.url");
                    String string2 = (String)map2.get("sys.user");
                    String string3 = string + string2;
                    if (!string3.equals(this.m_prevConnInfo) || !this.m_init) {
                        String string4;
                        String string5 = (String)map.get("product.version");
                        String string6 = null;
                        if ("tns".equals(map.get("db.connectionType")) && !InstallUtils.nullOrEmpty((String)map2.get("db.tnsDirectory"))) {
                            string6 = (String)map2.get("db.tnsDirectory");
                        }
                        this.m_canMigrateAPEXRest = InstallDBUtils.canMigrateAPEXRest(string, string6, InstallDBUtils.getDBAUsername(string2), (String)map2.get("sys.password"), string5);
                        if (this.m_canMigrateAPEXRest && (string4 = InstallDBUtils.getAPEXVersion((String)map2.get("db.url"), InstallDBUtils.getDBAUsername((String)map2.get("sys.user")), string5)) != null) {
                            map.put("apex.version", string4);
                        }
                        this.m_init = true;
                    }
                    this.m_prevConnInfo = string + (String)map2.get("sys.user");
                }
            }
            map2.put("rest.services.apex.add", Boolean.toString(this.m_useAPEXRestCB.isSelected()));
        }
    }

    public Object getExitTransition() {
        if ("install".equals(this.m_installer) && this.m_canMigrateAPEXRest) {
            return "Transition.Migrate";
        }
        return "Transition.Features";
    }
}

