/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.utils.RestLoadData;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.wizard.RestWizPublishPanel;
import oracle.dbtools.rest.wizard.RestWizPublishSummaryTabPanel;
import oracle.dbtools.rest.wizard.RestWizard;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.Step;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class RestPublishWizard
extends RestWizard {
    public static final String KEY_ADD_PUBLISHED = "ADD_PUBLISHED";
    public static final String KEY_BIND_LIST = "BIND_LIST";
    public static final String KEY_BIND_MAPS = "BIND_MAPS";
    public static final String KEY_NEW_MODULE = "NEW_MODULE";
    public static final String KEY_NEW_TEMPLATE = "NEW_TEMPLATE";
    public static final String KEY_REST_MODULE_LIST = "REST_MODULE_LIST";
    public static final String KEY_SCHEMA = "SCHEMA";
    public static final String KEY_SQL = "SQL";
    private static RestPublishWizard INSTANCE;
    private Logger logger = Logger.getLogger(RestPublishWizard.class.getName());
    private static Map<String, RestSchema> ordsInstallStatus;
    private String statusMsg = null;

    public static RestPublishWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestPublishWizard();
        }
        return INSTANCE;
    }

    public void launchPublishToRest(String string, String string2, Map<String, ?> map, List<?> list) {
        if (!ordsInstallStatus.isEmpty() && ordsInstallStatus.containsKey(string)) {
            if (this.verifyORDSInstall(string)) {
                this.launchPublishWizard(string, string2, map, list);
            }
        } else {
            this.verifyORDSInstallAndLaunch(string, string2, map, list);
        }
    }

    private void verifyORDSInstallAndLaunch(final String string, String string2, Map<String, ?> map, List<?> list) {
        final WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        RaptorTask<RestSchema> raptorTask = new RaptorTask<RestSchema>(RestArb.getString("VERIFY_ORDS_INSTALL"), true, IRaptorTaskRunMode.MODAL){

            protected RestSchema doWork() throws TaskException {
                RestSchema restSchema = null;
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                    restSchema = InstallDBUtils.getSchemaInfo(connection);
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return restSchema;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask, string, string2, map, list){
            final /* synthetic */ RaptorTask val$task;
            final /* synthetic */ String val$connName;
            final /* synthetic */ String val$sql;
            final /* synthetic */ Map val$bindMap;
            final /* synthetic */ List val$bindList;
            {
                this.val$task = raptorTask;
                this.val$connName = string;
                this.val$sql = string2;
                this.val$bindMap = map;
                this.val$bindList = list;
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
                try {
                    RestSchema restSchema = (RestSchema)this.val$task.getResult();
                    ordsInstallStatus.put(this.val$connName, restSchema);
                    if (RestPublishWizard.this.verifyORDSInstall(this.val$connName)) {
                        RestPublishWizard.this.launchPublishWizard(this.val$connName, this.val$sql, this.val$bindMap, this.val$bindList);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
                }
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private boolean verifyORDSInstall(String string) {
        this.statusMsg = null;
        if (ordsInstallStatus.containsKey(string)) {
            RestSchema restSchema = ordsInstallStatus.get(string);
            if (restSchema != null) {
                String string2 = restSchema.getOrdsSchemaVersion();
                if (string2 != null) {
                    try {
                        if (!InstallDBUtils.isEarlierVersion(string2, "3.0.5.0.0")) {
                            return true;
                        }
                        this.statusMsg = RestArb.format("PUBLISH_ORDS_OLD_VER", string2, RestArb.getString("PUBLISH_DOWNLOAD_ORDS"));
                    }
                    catch (Exception exception) {
                        this.logger.warning(exception.getLocalizedMessage());
                    }
                } else {
                    this.statusMsg = RestArb.getString("PUBLISH_ERR_RETRIEVE_SCHEMA");
                }
            } else {
                this.statusMsg = RestArb.getString("PUBLISH_ERR_RETRIEVE_SCHEMA");
            }
            if (this.statusMsg != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.information(null, (Object)RestPublishWizard.this.statusMsg, (String)StringUtils.stripMnemonic((String)RestArb.getString("REST_MENU_PUBLISH")), null);
                    }
                });
            }
        }
        return false;
    }

    private boolean launchPublishWizard(String string, String string2, Map<String, ?> map, List<?> list) {
        Locatable locatable;
        NavigatorTreeNode navigatorTreeNode;
        String string3 = "";
        try {
            string3 = Connections.getInstance().getConnection(string).getMetaData().getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
            return false;
        }
        Object object = this.getModuleFolder(string, string3);
        if (object == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot obtain the REST module folder.");
            return false;
        }
        List<RestModule> list2 = null;
        URL uRL = null;
        if (object instanceof NavigatorTreeNode) {
            navigatorTreeNode = (NavigatorTreeNode)object;
            list2 = RestLoadData.createModules(navigatorTreeNode, null);
            if (navigatorTreeNode.getElement() instanceof Locatable) {
                locatable = (Locatable)navigatorTreeNode.getElement();
                uRL = locatable.getURL();
            }
        } else if (object instanceof ObjectFolder) {
            navigatorTreeNode = (ObjectFolder)object;
            list2 = RestLoadData.loadModules((ObjectFolder)navigatorTreeNode, null);
            uRL = navigatorTreeNode.getURL();
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The object cannot be determined. It requires to be a NavigatorTree or ObjectFolder");
            return false;
        }
        navigatorTreeNode = new Namespace();
        navigatorTreeNode.put(KEY_REST_MODULE_LIST, list2);
        navigatorTreeNode.put("KEY_DBOBJECT", (Object)new DBObject(uRL));
        navigatorTreeNode.put(KEY_SCHEMA, (Object)string3);
        navigatorTreeNode.put(KEY_SQL, (Object)string2);
        navigatorTreeNode.put(KEY_BIND_MAPS, map);
        locatable = RestPublishWizard.getFSMforPublishToRest();
        boolean bl = this.launchWizard((FSM)locatable, (Namespace)navigatorTreeNode, true);
        if (bl) {
            Boolean bl2 = (Boolean)navigatorTreeNode.get("SUCCESS_STATUS");
            if (bl2.booleanValue() && object instanceof NavigatorTreeNode) {
                this.refreshFolder((NavigatorTreeNode)object);
            }
            return bl2;
        }
        return false;
    }

    private Object getModuleFolder(String string, String string2) {
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"REST_MODULE");
        if (uRL != null) {
            NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(uRL);
            if (navigatorTreeNode != null) {
                return navigatorTreeNode;
            }
            ObjectFolder objectFolder = (ObjectFolder)NodeFactory.find((URL)uRL);
            if (objectFolder != null) {
                return objectFolder;
            }
            objectFolder = (ObjectFolder)DatabaseNavigatorElementFactory.getTypeFolder((URL)uRL, null);
            if (objectFolder != null) {
                return objectFolder;
            }
            String string3 = "WARNING Cannot determine the module URL,  protocol: sqldev.nav connName: " + string + " schema: " + string2 + " type: " + "REST_MODULE";
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string3);
        }
        return null;
    }

    private static FSM getFSMforPublishToRest() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_URI"), RestWizPublishPanel.class, "f1_rest_publish_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"Transition.Finish", (Object)"State.Finish");
        Step step2 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizPublishSummaryTabPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)"State.Finish", step2);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private void refreshFolder(NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode != null) {
            NavigatorTree navigatorTree = null;
            NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
            if (navigatorWindow != null) {
                navigatorTree = navigatorWindow.getTree();
            }
            if (navigatorTree != null) {
                navigatorTreeNode = navigatorTreeNode.findAncestorTreeNode(ObjectFolder.class, false);
                navigatorTree.refresh(navigatorTreeNode);
            }
        }
    }

    static {
        ordsInstallStatus = new HashMap<String, RestSchema>();
    }
}

