/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.wizard.RestBaseSummaryTabPanel;

public class RestSummaryTabPanel
extends RestBaseSummaryTabPanel {
    public RestSummaryTabPanel(RestModule restModule, RestTemplate restTemplate, RestResourceHandler restResourceHandler, JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper) {
        super(jEditorPaneScrollPaneWrapper);
        this.buildSummaryTree(restModule, restTemplate, restResourceHandler);
    }

    public void buildSummaryTree(RestModule restModule, RestTemplate restTemplate, RestResourceHandler restResourceHandler) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        this.getSummaryTree().removeAll();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_ROOT"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = this.getModuleSummaryNode(restModule);
        if (defaultMutableTreeNode4 != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        if ((defaultMutableTreeNode2 = this.getTemplateSummaryNode(restTemplate)) != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if ((defaultMutableTreeNode = this.getHandlerSummaryNode(restResourceHandler)) != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
        }
        this.getSummaryTree().setModel(new DefaultTreeModel(defaultMutableTreeNode3));
        if (defaultMutableTreeNode4 != null) {
            this.getSummaryTree().expandPath(new TreePath(defaultMutableTreeNode4.getPath()));
        }
        if (defaultMutableTreeNode2 != null) {
            this.getSummaryTree().expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        if (defaultMutableTreeNode != null) {
            this.getSummaryTree().expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private DefaultMutableTreeNode getModuleSummaryNode(RestModule restModule) {
        if (restModule == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_MODULE"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("MODULE_NAME")), restModule.getName())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PREFIX")), restModule.getURIPrefix())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("PUBLISH")), restModule.isPublished())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restModule.getPaginationSize()))));
        List list = restModule.getOrigins();
        if (list != null && !list.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("ORIGINS_ALLOWED"));
            for (String string : restModule.getOrigins()) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(string)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(RestArb.getString("WIZ_ORIGINS_NONE")));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getTemplateSummaryNode(RestTemplate restTemplate) {
        if (restTemplate == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_TEMPLATE"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PATTERN")), restTemplate.getURIPattern())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PRIORITY")), Long.toString(restTemplate.getPriority()))));
        if (restTemplate.getEntityTag() == RestTemplate.ENTITY_TAG_TYPE.QUERY) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("ENTITY_TAG")), restTemplate.getEntityTag().getNLS()));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(restTemplate.getEntityTagQuery())));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("ENTITY_TAG")), restTemplate.getEntityTag().getNLS())));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getHandlerSummaryNode(RestResourceHandler restResourceHandler) {
        if (restResourceHandler == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_RESOURCE_HANDLER"));
        switch (restResourceHandler.getMethodType()) {
            case GET: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("GET_NODE"))));
                break;
            }
            case POST: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("POST_NODE"))));
                break;
            }
            case PUT: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("PUT_NODE"))));
                break;
            }
            case DELETE: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("DELETE_NODE"))));
            }
        }
        if (RestUtils.isAPEXRestfulServices()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("SECURE_ACCESS")), restResourceHandler.isSecuredAccess())));
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("SOURCE_TYPE")), restResourceHandler.getSourceType().getNLS())));
        switch (restResourceHandler.getMethodType()) {
            case GET: {
                String string = null;
                string = restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.MEDIA_RESOURCE ? RestArb.getString("FORMAT_BINARY") : restResourceHandler.getFormatType().getNLS();
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("DATA_FORMAT")), string)));
                if (restResourceHandler.getSourceType() == null || restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW) break;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restResourceHandler.getPaginationSize()))));
                break;
            }
            case POST: 
            case PUT: {
                List list = restResourceHandler.getMimeTypes();
                if (list == null || list.isEmpty()) break;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("MIME_TYPES"));
                for (String string : list) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(string)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                break;
            }
        }
        return defaultMutableTreeNode;
    }
}

