/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class POJODefinition {
    private static final int MAX_CACHED = 100;
    private static final Prop[] NO_PROPS = new Prop[0];
    protected static final ConcurrentHashMap<Class<?>, POJODefinition> DEFS = new ConcurrentHashMap(50, 0.75f, 4);
    protected final Class<?> _type;
    protected final Prop[] _properties;
    public final Constructor<?> defaultCtor;
    public final Constructor<?> stringCtor;
    public final Constructor<?> longCtor;

    public POJODefinition(Class<?> clazz, Prop[] propArray, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3) {
        this._type = clazz;
        this._properties = propArray;
        this.defaultCtor = constructor;
        this.stringCtor = constructor2;
        this.longCtor = constructor3;
    }

    public static POJODefinition find(Class<?> clazz) {
        try {
            return POJODefinition._find(clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.format("Failed to introspect ClassDefinition for type '%s': %s", clazz.getName(), exception.getMessage()), exception);
        }
    }

    public static POJODefinition _find(Class<?> clazz) {
        POJODefinition pOJODefinition = DEFS.get(clazz);
        if (pOJODefinition == null) {
            pOJODefinition = POJODefinition._construct(clazz);
            if (DEFS.size() >= 100) {
                DEFS.clear();
            }
            DEFS.putIfAbsent(clazz, pOJODefinition);
        }
        return pOJODefinition;
    }

    public Prop[] properties() {
        return this._properties;
    }

    private static POJODefinition _construct(Class<?> clazz) {
        TreeMap<String, Prop> treeMap = new TreeMap<String, Prop>();
        POJODefinition._introspect(clazz, treeMap);
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        for (Constructor<?> constructor4 : clazz.getDeclaredConstructors()) {
            Class<?>[] classArray = constructor4.getParameterTypes();
            if (classArray.length == 0) {
                constructor = constructor4;
                continue;
            }
            if (classArray.length != 1) continue;
            Class<?> clazz2 = classArray[0];
            if (clazz2 == String.class) {
                constructor2 = constructor4;
                continue;
            }
            if (clazz2 != Long.class && clazz2 != Long.TYPE) continue;
            constructor3 = constructor4;
        }
        Object[] objectArray = treeMap.isEmpty() ? NO_PROPS : treeMap.values().toArray(NO_PROPS);
        return new POJODefinition(clazz, (Prop[])objectArray, constructor, constructor2, constructor3);
    }

    private static void _introspect(Class<?> clazz, Map<String, Prop> map) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        POJODefinition._introspect(clazz.getSuperclass(), map);
        for (Field accessibleObject : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(accessibleObject.getModifiers()) || accessibleObject.isEnumConstant() || accessibleObject.isSynthetic()) continue;
            POJODefinition._propFrom(map, (String)accessibleObject.getName()).field = accessibleObject;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Object object;
            int n = ((Method)accessibleObject).getModifiers();
            if (Modifier.isStatic(n) || ((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
            if (classArray.length == 0) {
                if (!Modifier.isPublic(n) || (object = ((Method)accessibleObject).getReturnType()) == Void.class) continue;
                String string = ((Method)accessibleObject).getName();
                if (string.startsWith("get")) {
                    if (string.length() <= 3) continue;
                    string = POJODefinition.decap(string.substring(3));
                    POJODefinition._propFrom(map, (String)string).getter = accessibleObject;
                    continue;
                }
                if (!string.startsWith("is") || string.length() <= 2) continue;
                string = POJODefinition.decap(string.substring(2));
                POJODefinition._propFrom(map, (String)string).isGetter = accessibleObject;
                continue;
            }
            if (classArray.length != 1 || !((String)(object = ((Method)accessibleObject).getName())).startsWith("set") || ((String)object).length() == 3) continue;
            object = POJODefinition.decap(((String)object).substring(3));
            POJODefinition._propFrom(map, (String)object).setter = accessibleObject;
        }
    }

    private static Prop _propFrom(Map<String, Prop> map, String string) {
        Prop prop = map.get(string);
        if (prop == null) {
            prop = new Prop(string);
            map.put(string, prop);
        }
        return prop;
    }

    private static String decap(String string) {
        char c;
        char c2 = string.charAt(0);
        if (!(c2 == (c = Character.toLowerCase(c2)) || string.length() != 1 && Character.isUpperCase(string.charAt(1)))) {
            char[] cArray = string.toCharArray();
            cArray[0] = c;
            return new String(cArray);
        }
        return string;
    }

    public static final class Prop {
        public final String name;
        public Method setter;
        public Method getter;
        public Method isGetter;
        public Field field;

        public Prop(String string) {
            this.name = string;
        }

        public boolean hasSetter() {
            return this.setter != null || this.field != null;
        }
    }
}

