/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.utilint.LoggerUtils;

public abstract class DatabaseException
extends RuntimeException {
    private static final String VERSION_HEADER = "(JE " + JEVersion.CURRENT_VERSION + ") ";
    private static final long serialVersionUID = 1535562945L;
    private String extraInfo = null;
    private transient ThreadLocal<String> rethrownStackTraces = new ThreadLocal();

    public DatabaseException(Throwable t) {
        super(DatabaseException.getVersionHeader() + t.toString(), t);
    }

    public DatabaseException(String message) {
        super(DatabaseException.addVersionHeader(message));
    }

    public DatabaseException(String message, Throwable t) {
        super(DatabaseException.addVersionHeader(message), t);
    }

    public static String getVersionHeader() {
        return VERSION_HEADER;
    }

    private static String addVersionHeader(String msg) {
        return msg.startsWith(VERSION_HEADER) ? msg : VERSION_HEADER + msg;
    }

    public void addErrorMessage(String newExtraInfo) {
        if (this.isJavaError()) {
            return;
        }
        this.extraInfo = this.extraInfo == null ? " " + newExtraInfo : this.extraInfo + ' ' + newExtraInfo;
    }

    boolean isJavaError() {
        return false;
    }

    public void addRethrownStackTrace() {
        if (this.isJavaError()) {
            return;
        }
        if (this.rethrownStackTraces == null) {
            return;
        }
        Exception localEx = new Exception("Stacktrace where exception below was rethrown (" + this.getClass().getName() + ")");
        this.rethrownStackTraces.set(LoggerUtils.getStackTrace((Throwable)localEx));
    }

    @Override
    public String getMessage() {
        String rethrownStackTrace;
        String msg = this.extraInfo != null ? super.getMessage() + this.extraInfo : super.getMessage();
        String string = rethrownStackTrace = this.rethrownStackTraces != null ? this.rethrownStackTraces.get() : null;
        if (rethrownStackTrace == null) {
            return msg;
        }
        return rethrownStackTrace + "\n" + msg;
    }
}

