/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

public abstract class AbstractDataChannel
implements DataChannel {
    protected boolean configuredBlocking;
    protected final SocketChannel socketChannel;
    protected final String addressPair;

    protected AbstractDataChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        this.configuredBlocking = socketChannel.isBlocking();
        this.addressPair = this.getAddressPair();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.socket().getRemoteSocketAddress();
    }

    @Override
    public synchronized void configureBlocking(boolean block) throws IOException {
        this.socketChannel.configureBlocking(block);
        this.configuredBlocking = block;
    }

    @Override
    public synchronized boolean isBlocking() {
        return this.configuredBlocking;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    protected void ensureCloseForBlocking() {
        if (!this.isBlocking()) {
            throw new IllegalStateException("Calling close on non-blocking channel");
        }
    }

    protected void ensureCloseAsyncForNonBlocking() {
        if (this.isBlocking()) {
            throw new IllegalStateException("Calling closeAsync on blocking channel");
        }
    }

    private String getAddressPair() {
        SocketAddress remote;
        SocketAddress local;
        try {
            local = this.getSocketChannel().getLocalAddress();
        }
        catch (IOException e) {
            local = null;
        }
        try {
            remote = this.getSocketChannel().getRemoteAddress();
        }
        catch (IOException e) {
            remote = null;
        }
        return String.format("(%s->%s)", local, remote);
    }
}

