/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.net.SSLAuthenticator;
import com.sleepycat.je.rep.utilint.net.AbstractDataChannel;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLDataChannel
extends AbstractDataChannel {
    private static final ReadableByteChannel NULL_READ_CHANNEL = new ReadableByteChannel(){

        @Override
        public int read(ByteBuffer dst) {
            throw new IllegalStateException("Reading from a channel that should not be used. This indicates that a channel is switching between blocking and non-blocking mode while a concurrent read happens. We do not support such behavior");
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isOpen() {
            return true;
        }
    };
    private volatile ReadableByteChannel wrappedReadChannel;
    private final SSLEngine sslEngine;
    private final ByteBuffer netRecvBuffer;
    private final ByteBuffer netXmitBuffer;
    private final ByteBuffer appRecvBuffer;
    private final ByteBuffer[] emptyAppXmitBuffers;
    private final ChannelWriteTask channelWriteTask = new ChannelWriteTask();
    private final ChannelReadTask channelReadTask = new ChannelReadTask();
    private final CloseTask closeTask = new CloseTask();
    private final ThreadLocal<Boolean> insideCloseMethod = ThreadLocal.withInitial(() -> false);
    private final String targetHost;
    private final SSLAuthenticator authenticator;
    private final HostnameVerifier hostVerifier;
    private volatile boolean peerTrusted = false;
    private final InstanceLogger logger;
    private final AsyncIOIncompletion asyncIOIncompletion = new AsyncIOIncompletion();

    public SSLDataChannel(SocketChannel socketChannel, SSLEngine sslEngine, String targetHost, HostnameVerifier hostVerifier, SSLAuthenticator authenticator, InstanceLogger logger) {
        super(socketChannel);
        this.sslEngine = sslEngine;
        this.targetHost = targetHost;
        this.authenticator = authenticator;
        this.hostVerifier = hostVerifier;
        this.logger = logger;
        SSLSession sslSession = sslEngine.getSession();
        int netBufferSize = sslSession.getPacketBufferSize();
        int appBufferSize = sslSession.getApplicationBufferSize();
        this.emptyAppXmitBuffers = new ByteBuffer[]{ByteBuffer.allocate(0)};
        this.netXmitBuffer = ByteBuffer.allocate(3 * netBufferSize);
        this.appRecvBuffer = ByteBuffer.allocate(2 * appBufferSize);
        this.netRecvBuffer = ByteBuffer.allocate(2 * netBufferSize);
        try {
            this.wrappedReadChannel = this.isBlocking() ? Channels.newChannel(socketChannel.socket().getInputStream()) : socketChannel;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get stream from connected socket " + socketChannel, e);
        }
        logger.log(Level.FINE, () -> String.format("%s data channel created", this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureBlocking(boolean block) throws IOException {
        SSLDataChannel sSLDataChannel = this;
        synchronized (sSLDataChannel) {
            if (block == this.isBlocking()) {
                return;
            }
            this.wrappedReadChannel = NULL_READ_CHANNEL;
            this.socketChannel.configureBlocking(block);
            this.wrappedReadChannel = block ? Channels.newChannel(this.socketChannel.socket().getInputStream()) : this.socketChannel;
            this.configuredBlocking = block;
        }
        if (block) {
            this.flush();
        }
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean isTrustCapable() {
        return this.authenticator != null;
    }

    @Override
    public boolean isTrusted() {
        return this.peerTrusted;
    }

    @Override
    public boolean isOpen() {
        if (!this.socketChannel.isOpen()) {
            return false;
        }
        return this.closeTask.isStandby();
    }

    @Override
    public DataChannel.AsyncIO.ContinueAction getAsyncIOContinueAction(DataChannel.AsyncIO.Type type) {
        return this.asyncIOIncompletion.nextAction(type);
    }

    @Override
    public int read(ByteBuffer toFill) throws IOException, SSLException {
        return (int)this.read(new ByteBuffer[]{toFill}, 0, 1);
    }

    @Override
    public long read(ByteBuffer[] toFill) throws IOException, SSLException {
        return this.read(toFill, 0, toFill.length);
    }

    @Override
    public long read(ByteBuffer[] toFill, int offset, int length) throws IOException {
        TransitionStopCause cause;
        this.logger.log(Level.FINEST, () -> String.format("%s data channel reading", this));
        if (this.countRemaining(toFill, offset, length) <= 0) {
            return 0L;
        }
        this.crossCloseQuiescentBarrier();
        int readCount = 0;
        block4: while (true) {
            int n = this.transferAppData(toFill, offset, length);
            readCount += n;
            if (n != 0) {
                this.logger.log(Level.FINEST, () -> String.format("%s transferred %s bytes", this, n));
                return readCount;
            }
            if (this.closeTask.isChannelReadDone() && readCount == 0) {
                this.logger.log(Level.FINEST, () -> String.format("%s read closed", this));
                return -1L;
            }
            cause = this.unwrap();
            this.logger.log(Level.FINEST, () -> String.format("%s data channel read unwrap stop cause is %s", new Object[]{this, cause}));
            switch (cause) {
                case NB_IS_CHNL_WRITE_BUSY: 
                case NB_NEEDS_CHNL_READ_DATA: 
                case NB_NEEDS_CHNL_READ_HANDSHAKE: 
                case NEEDS_HANDSHAKE_TASKS: 
                case NEEDS_APP_READ: {
                    this.logger.log(Level.FINEST, () -> String.format("%s data channel read stopped, cause is %s", new Object[]{this, cause}));
                    return readCount;
                }
                case DONE: {
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException(String.format("Invalid stop cause from unwrap in read: %s", new Object[]{cause}));
    }

    private int countRemaining(ByteBuffer[] bufs, int offset, int length) {
        this.checkParams(bufs, offset, length);
        int ret = 0;
        for (int i = offset; i < offset + length; ++i) {
            ret += bufs[i].remaining();
        }
        return ret;
    }

    private void checkParams(ByteBuffer[] bufs, int offset, int length) {
        if (bufs == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (offset < 0 || length < 0 || offset > bufs.length - length) {
            throw new IndexOutOfBoundsException("index out of bound of the buffers");
        }
        for (int i = offset; i < offset + length; ++i) {
            if (bufs[i] != null) continue;
            throw new IllegalArgumentException("buffer[" + i + "] == null");
        }
    }

    private void crossCloseQuiescentBarrier() throws IOException {
        if (this.insideCloseMethod.get().booleanValue()) {
            return;
        }
        if (this.closeTask.isRunning()) {
            throw new AsynchronousCloseException();
        }
        if (this.closeTask.isDone()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferAppData(ByteBuffer[] toFill, int offset, int length) {
        ByteBuffer byteBuffer = this.appRecvBuffer;
        synchronized (byteBuffer) {
            if (this.appRecvBuffer.position() <= 0) {
                this.asyncIOIncompletion.needsAppRead(false);
                return 0;
            }
            this.appRecvBuffer.flip();
            int count = this.transfer(this.appRecvBuffer, toFill, offset, length);
            this.appRecvBuffer.compact();
            if (count > 0) {
                this.asyncIOIncompletion.needsAppRead(false);
            }
            return count;
        }
    }

    private int transfer(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) {
        int transferred = 0;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer dst = dsts[i];
            int space = dst.remaining();
            if (src.remaining() > space) {
                int oldLimit = src.limit();
                src.limit(src.position() + space);
                dst.put(src);
                src.position(src.limit());
                src.limit(oldLimit);
                transferred += space;
                continue;
            }
            transferred += src.remaining();
            dst.put(src);
            break;
        }
        return transferred;
    }

    @Override
    public int write(ByteBuffer toSend) throws IOException, SSLException {
        return (int)this.write(new ByteBuffer[]{toSend}, 0, 1);
    }

    @Override
    public long write(ByteBuffer[] toSend) throws IOException, SSLException {
        return this.write(toSend, 0, toSend.length);
    }

    @Override
    public long write(ByteBuffer[] toSend, int offset, int length) throws IOException {
        this.logger.log(Level.FINEST, () -> String.format("%s data channel writing", this));
        this.crossCloseQuiescentBarrier();
        WrapStatus wrapStatus = this.wrap(toSend, offset, length);
        this.logger.log(Level.FINEST, () -> String.format("%s data channel write wrap stop cause is %s, consumed %s bytes", new Object[]{this, wrapStatus.cause, wrapStatus.consumed}));
        if (wrapStatus.cause == TransitionStopCause.PAUSED) {
            throw new IllegalStateException("Invalid stop cause for wrap: PAUSED");
        }
        if (this.isBlocking()) {
            this.flush();
        }
        return wrapStatus.consumed;
    }

    @Override
    public boolean flush() throws IOException {
        this.logger.log(Level.FINEST, () -> String.format("%s data channel flushing", this));
        TransitionStopCause cause = this.channelWriteTask.run();
        return cause.equals((Object)TransitionStopCause.DONE);
    }

    private WrapStatus wrap() throws IOException {
        return this.wrap(this.emptyAppXmitBuffers, 0, 1);
    }

    private WrapStatus wrap(ByteBuffer[] bufs, int offset, int length) throws IOException {
        WrapStatus wrapStatus;
        if (this.sslEngine.isOutboundDone()) {
            throw new SSLException("SSL outbound already closed");
        }
        long total = this.countRemaining(bufs, offset, length);
        this.logger.log(Level.FINEST, () -> String.format("%s wrapping, total to wrap is %s bytes", this, total));
        long consumed = 0L;
        block4: while (true) {
            TransitionStopCause hsCause = this.handshake();
            this.logger.log(Level.FINEST, () -> String.format("%s handshake stop cause is %s", new Object[]{this, hsCause}));
            if (hsCause != TransitionStopCause.DONE) {
                return new WrapStatus(consumed, hsCause);
            }
            wrapStatus = this.doWrap(bufs, offset, length);
            long remaining = total - (consumed += wrapStatus.consumed);
            this.logger.log(Level.FINEST, () -> String.format("%s wrap stop cause is %s, consumed %s bytes, remaining is %s bytes", new Object[]{this, wrapStatus.cause, wrapStatus.consumed, remaining}));
            TransitionStopCause cause = this.sslEngine.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP) ? this.flushAfterDoWrap(wrapStatus.cause) : wrapStatus.cause;
            switch (cause) {
                case NB_IS_CHNL_WRITE_BUSY: 
                case DONE: {
                    return new WrapStatus(consumed, cause);
                }
                case PAUSED: {
                    if (total - consumed != 0L) continue block4;
                    return new WrapStatus(consumed, TransitionStopCause.DONE);
                }
            }
            break;
        }
        throw new IllegalStateException(String.format("Invalid state from doWrap: %s", new Object[]{wrapStatus.cause}));
    }

    private TransitionStopCause flushAfterDoWrap(TransitionStopCause cause) throws IOException {
        if (!(cause.equals((Object)TransitionStopCause.NB_IS_CHNL_WRITE_BUSY) || cause.equals((Object)TransitionStopCause.PAUSED) || cause.equals((Object)TransitionStopCause.DONE))) {
            throw new IllegalStateException("Invalid stop cause for doWrap: " + (Object)((Object)cause));
        }
        if ((cause.equals((Object)TransitionStopCause.PAUSED) || cause.equals((Object)TransitionStopCause.DONE)) && this.channelWriteTask.run().equals((Object)TransitionStopCause.NB_IS_CHNL_WRITE_BUSY)) {
            return TransitionStopCause.NB_IS_CHNL_WRITE_BUSY;
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransitionStopCause unwrap() throws IOException {
        UnwrapStatus unwrapStatus;
        this.logger.log(Level.FINEST, () -> String.format("%s unwrapping", this));
        block7: while (true) {
            TransitionStopCause hsCause = this.handshake();
            this.logger.log(Level.FINEST, () -> String.format("%s handshake stop cause is %s", new Object[]{this, hsCause}));
            if (hsCause != TransitionStopCause.DONE) {
                return hsCause;
            }
            unwrapStatus = this.doUnwrap();
            this.logger.log(Level.FINEST, () -> String.format("%s unwrap stop cause is %s, produced %s bytes", new Object[]{this, unwrapStatus.cause, unwrapStatus.produced}));
            ByteBuffer byteBuffer = this.appRecvBuffer;
            synchronized (byteBuffer) {
                if (this.appRecvBuffer.position() > 0) {
                    return TransitionStopCause.DONE;
                }
            }
            switch (unwrapStatus.cause) {
                case NB_NEEDS_CHNL_READ_DATA: 
                case NB_NEEDS_CHNL_READ_HANDSHAKE: 
                case NEEDS_APP_READ: 
                case DONE: {
                    return unwrapStatus.cause;
                }
                case PAUSED: {
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException(String.format("Invalid stop cause from doUnwrap in wrap: %s", new Object[]{unwrapStatus.cause}));
    }

    private TransitionStopCause handshake() throws IOException {
        TransitionStopCause cause;
        this.logger.log(Level.FINEST, () -> String.format("%s handshaking", this));
        do {
            SSLEngineResult.HandshakeStatus hsStatus = this.sslEngine.getHandshakeStatus();
            this.logger.log(Level.FINEST, () -> String.format("%s handshaking status is %s", new Object[]{this, hsStatus}));
            switch (hsStatus) {
                case NEED_WRAP: {
                    TransitionStopCause wrapCause = this.doWrap(this.emptyAppXmitBuffers, 0, 1).cause;
                    if (this.sslEngine.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP) && this.sslEngine.isInboundDone()) {
                        wrapCause = TransitionStopCause.DONE;
                    }
                    cause = this.flushAfterDoWrap(wrapCause);
                    break;
                }
                case NEED_UNWRAP: {
                    cause = this.doUnwrap().cause;
                    break;
                }
                case NEED_TASK: {
                    if (this.isBlocking()) {
                        this.executeTasks();
                        cause = TransitionStopCause.PAUSED;
                        break;
                    }
                    cause = TransitionStopCause.NEEDS_HANDSHAKE_TASKS;
                    break;
                }
                case NOT_HANDSHAKING: {
                    return TransitionStopCause.DONE;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid status when calling SSLEngine.getHandshakeStatus: %s", new Object[]{hsStatus}));
                }
            }
        } while (cause.equals((Object)TransitionStopCause.PAUSED));
        return cause;
    }

    private WrapStatus doWrap(ByteBuffer[] bufs, int offset, int length) throws IOException {
        ByteBuffer byteBuffer = this.netXmitBuffer;
        synchronized (byteBuffer) {
            SSLEngineResult result = this.sslEngine.wrap(bufs, offset, length, this.netXmitBuffer);
            int consumed = result.bytesConsumed();
            SSLEngineResult.Status status = result.getStatus();
            switch (status) {
                case BUFFER_OVERFLOW: {
                    TransitionStopCause fcause = this.channelWriteTask.run();
                    if (!fcause.equals((Object)TransitionStopCause.DONE)) {
                        return new WrapStatus(consumed, TransitionStopCause.NB_IS_CHNL_WRITE_BUSY);
                    }
                    return new WrapStatus(consumed, TransitionStopCause.PAUSED);
                }
                case CLOSED: {
                    this.closeTask.setOutStatus(OutStatus.WRAP_DONE);
                    return new WrapStatus(consumed, TransitionStopCause.DONE);
                }
                case OK: {
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                        this.validateCredentials();
                    }
                    return new WrapStatus(consumed, TransitionStopCause.PAUSED);
                }
            }
            throw new IllegalStateException(String.format("Invalid status for wrap: %s", new Object[]{status}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnwrapStatus doUnwrap() throws IOException {
        if (Thread.holdsLock(this.appRecvBuffer)) {
            throw new IllegalStateException("Wrong lock order in doUnwrap: appRecvBuffer held when acquiring netRecvBuffer");
        }
        ByteBuffer byteBuffer = this.netRecvBuffer;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = this.appRecvBuffer;
            synchronized (byteBuffer2) {
                SSLEngineResult result;
                try {
                    this.netRecvBuffer.flip();
                    result = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                }
                finally {
                    this.netRecvBuffer.compact();
                }
                SSLEngineResult.Status status = result.getStatus();
                switch (status) {
                    case BUFFER_UNDERFLOW: {
                        return new UnwrapStatus(result.bytesProduced(), this.readChannelForBufUnderflow());
                    }
                    case BUFFER_OVERFLOW: {
                        this.asyncIOIncompletion.needsAppRead(true);
                        return new UnwrapStatus(result.bytesProduced(), TransitionStopCause.NEEDS_APP_READ);
                    }
                    case CLOSED: {
                        this.closeTask.closeInbound();
                        return new UnwrapStatus(result.bytesProduced(), TransitionStopCause.DONE);
                    }
                    case OK: {
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            this.validateCredentials();
                        }
                        return new UnwrapStatus(result.bytesProduced(), TransitionStopCause.PAUSED);
                    }
                }
                throw new IllegalStateException(String.format("Invalid status for unwrap: %s", new Object[]{status}));
            }
        }
    }

    private TransitionStopCause readChannelForBufUnderflow() throws IOException {
        if (!Thread.holdsLock(this.netRecvBuffer)) {
            throw new IllegalStateException("readChannelForBufUnderflow must hold netRecvBuffer lock");
        }
        SSLEngineResult.HandshakeStatus hsStatus = this.sslEngine.getHandshakeStatus();
        int n = this.channelReadTask.run();
        if (n > 0) {
            this.asyncIOIncompletion.needsChannelReadData(false);
            this.asyncIOIncompletion.needsChannelReadHandshake(false);
            return TransitionStopCause.PAUSED;
        }
        if (hsStatus.equals((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
            this.asyncIOIncompletion.needsChannelReadData(true);
            return TransitionStopCause.NB_NEEDS_CHNL_READ_DATA;
        }
        this.asyncIOIncompletion.needsChannelReadHandshake(true);
        return TransitionStopCause.NB_NEEDS_CHNL_READ_HANDSHAKE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateCredentials() throws SSLException {
        SSLSession session = this.sslEngine.getSession();
        this.logger.log(Level.FINE, () -> String.format("%s SSL protocol is %s, cipher suite is %s, local certs are %s, hostVerifier is %s, authenticator is %s, validating credentials", this, session.getProtocol(), session.getCipherSuite(), Arrays.toString(session.getLocalCertificates()), this.hostVerifier, this.authenticator));
        if (this.sslEngine.getUseClientMode()) {
            if (this.hostVerifier == null) return;
            this.peerTrusted = this.hostVerifier.verify(this.targetHost, this.sslEngine.getSession());
            if (this.peerTrusted) {
                this.logger.log(Level.FINE, () -> String.format("%s SSL host verifier reports that connection target is valid", this));
                return;
            }
            this.logger.log(Level.INFO, () -> String.format("%s SSL host verifier reports that connection target is NOT valid", this));
            throw new SSLException("Server identity could not be verified");
        }
        if (this.authenticator == null) return;
        this.peerTrusted = this.authenticator.isTrusted(this.sslEngine.getSession());
        if (this.peerTrusted) {
            this.logger.log(Level.FINE, () -> String.format("%s SSL authenticator reports that channel is trusted", this));
            return;
        }
        this.logger.log(Level.INFO, () -> String.format("%s SSL authenticator reports that channel is NOT trusted", this));
    }

    @Override
    public void executeTasks(ExecutorService executor, Runnable callback) {
        executor.submit(() -> {
            this.executeTasks();
            try {
                callback.run();
            }
            catch (Throwable t) {
                this.logger.log(Level.INFO, () -> String.format("%s error with task execution callback: %s", this, LoggerUtils.getStackTrace((Throwable)t)));
            }
        });
    }

    private void executeTasks() {
        Runnable task;
        long ts = System.nanoTime();
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
        this.logger.log(Level.FINE, () -> String.format("%s executed tasks in %s ms", this, (double)(System.nanoTime() - ts) / 1000000.0));
    }

    @Override
    public void close() throws IOException {
        this.logger.log(Level.FINEST, () -> String.format("%s data channel sync closing", this));
        try {
            this.ensureCloseForBlocking();
            this.closeTask.run();
        }
        catch (Throwable t) {
            this.closeForcefullyInternal(t);
        }
    }

    private void closeForcefullyInternal(Throwable t) throws IOException {
        try {
            try {
                this.sslEngine.closeOutbound();
                this.sslEngine.closeInbound();
            }
            finally {
                this.closeTask.finish();
            }
        }
        catch (SSLException sSLException) {
        }
        catch (IOException ioe) {
            if (t == null) {
                throw ioe;
            }
            t.addSuppressed(ioe);
        }
        if (t == null) {
            return;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    @Override
    public boolean closeAsync() throws IOException {
        this.logger.log(Level.FINEST, () -> String.format("%s data channel async closing", this));
        try {
            this.ensureCloseAsyncForNonBlocking();
            return this.closeTask.run();
        }
        catch (Throwable t) {
            this.closeForcefullyInternal(t);
            return true;
        }
    }

    @Override
    public void closeForcefully() throws IOException {
        this.logger.log(Level.FINEST, () -> String.format("%s data channel closing forcefully", this));
        this.closeForcefullyInternal(null);
    }

    public String toString() {
        return String.format("%s%s %s", this.addressPair, this.isBlocking() ? "BLK" : "NBL", this.sslEngine.getUseClientMode() ? "client" : "server");
    }

    private class CloseTask {
        private final ReentrantLock closeLock = new ReentrantLock();
        private volatile CloseTaskStatus taskStatus = CloseTaskStatus.STANDBY;
        private volatile InStatus inStatus = InStatus.STANDBY;
        private volatile OutStatus outStatus = OutStatus.STANDBY;

        private CloseTask() {
        }

        private boolean isStandby() {
            return this.taskStatus.equals((Object)CloseTaskStatus.STANDBY);
        }

        private boolean isRunning() {
            return this.taskStatus.equals((Object)CloseTaskStatus.RUNNING);
        }

        private boolean isDone() {
            return this.taskStatus.equals((Object)CloseTaskStatus.DONE);
        }

        private synchronized void setTaskStatus(CloseTaskStatus s) {
            if (this.taskStatus.compareTo(s) < 0) {
                this.taskStatus = s;
            }
        }

        private synchronized void setInStatus(InStatus s) {
            if (this.inStatus.compareTo(s) < 0) {
                this.inStatus = s;
            }
        }

        private synchronized void setOutStatus(OutStatus s) {
            if (this.outStatus.compareTo(s) < 0) {
                this.outStatus = s;
            }
        }

        private void onChannelReadDone() {
            this.setInStatus(InStatus.CHNL_READ_DONE);
        }

        private boolean isChannelReadDone() {
            return this.inStatus.compareTo(InStatus.CHNL_READ_DONE) >= 0;
        }

        private synchronized void closeInbound() {
            this.setInStatus(InStatus.UNWRAP_DONE);
            try {
                SSLDataChannel.this.sslEngine.closeInbound();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }

        private boolean run() throws IOException {
            SSLDataChannel.this.insideCloseMethod.set(true);
            this.closeLock.lock();
            try {
                this.prepare();
                boolean bl = this.transit();
                return bl;
            }
            catch (Throwable t) {
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s got exception when running close task: %s", SSLDataChannel.this, LoggerUtils.getStackTrace((Throwable)t)));
                throw t;
            }
            finally {
                this.closeLock.unlock();
                SSLDataChannel.this.insideCloseMethod.set(false);
            }
        }

        private void prepare() throws IOException {
            this.setTaskStatus(CloseTaskStatus.RUNNING);
            SSLDataChannel.this.channelWriteTask.interruptAndAwaitQuiescent();
            SSLDataChannel.this.channelReadTask.interruptAndAwaitQuiescent();
            SSLDataChannel.this.sslEngine.closeOutbound();
            this.setOutStatus(OutStatus.NEED_LAST_WRAP);
            SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s prepared for channel closing", SSLDataChannel.this));
        }

        private boolean transit() throws IOException {
            SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s in close transition, current state: (%s, %s)", new Object[]{SSLDataChannel.this, this.inStatus, this.outStatus}));
            block4: while (!this.isDone()) {
                OutStatus prevOS = this.outStatus;
                InStatus prevIS = this.inStatus;
                TransitionStopCause cause = this.transitOnce();
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s close transitted one step, from (%s, %s) to (%s, %s), stop cause is %s", new Object[]{SSLDataChannel.this, prevIS, prevOS, this.inStatus, this.outStatus, cause}));
                switch (cause) {
                    case PAUSED: {
                        continue block4;
                    }
                    case NB_IS_CHNL_WRITE_BUSY: 
                    case NB_NEEDS_CHNL_READ_DATA: 
                    case NB_NEEDS_CHNL_READ_HANDSHAKE: 
                    case NEEDS_HANDSHAKE_TASKS: {
                        return false;
                    }
                }
                throw new IllegalStateException(String.format("Invalid state for close transition: %s", new Object[]{cause}));
            }
            SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s in close transition done", SSLDataChannel.this));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TransitionStopCause transitOnce() throws IOException {
            OutStatus ostatus = this.outStatus;
            switch (ostatus) {
                case STANDBY: {
                    throw new IllegalStateException("Close method should transit outbound state out from STANDBY");
                }
                case NEED_LAST_WRAP: {
                    return this.doLastWraps();
                }
                case WRAP_DONE: {
                    SSLDataChannel.this.channelWriteTask.run();
                    ByteBuffer byteBuffer = SSLDataChannel.this.netXmitBuffer;
                    synchronized (byteBuffer) {
                        if (SSLDataChannel.this.netXmitBuffer.position() != 0) {
                            return TransitionStopCause.NB_IS_CHNL_WRITE_BUSY;
                        }
                    }
                    this.setOutStatus(OutStatus.CHNL_WRITE_DONE);
                    return TransitionStopCause.PAUSED;
                }
                case CHNL_WRITE_DONE: {
                    this.closeInbound();
                    this.finish();
                    return TransitionStopCause.PAUSED;
                }
            }
            throw new IllegalStateException("Invalid outbound state " + (Object)((Object)ostatus));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TransitionStopCause doLastWraps() throws IOException {
            WrapStatus wrapStatus;
            SSLDataChannel.this.channelWriteTask.run();
            block8: while (true) {
                wrapStatus = SSLDataChannel.this.wrap();
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s data channel close wrap stop cause is %s, consumed %s bytes", new Object[]{SSLDataChannel.this, wrapStatus.cause, wrapStatus.consumed}));
                switch (2.$SwitchMap$com$sleepycat$je$rep$utilint$net$SSLDataChannel$TransitionStopCause[wrapStatus.cause.ordinal()]) {
                    case 5: {
                        ByteBuffer byteBuffer = SSLDataChannel.this.appRecvBuffer;
                        synchronized (byteBuffer) {
                            SSLDataChannel.this.appRecvBuffer.clear();
                        }
                    }
                    continue block8;
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return wrapStatus.cause;
                    }
                    case 6: {
                        if (!SSLDataChannel.this.sslEngine.isOutboundDone()) {
                            throw new IllegalStateException("SSLEngine outbound not closed after wrap() returns DONE during doLastWraps");
                        }
                        this.setOutStatus(OutStatus.WRAP_DONE);
                        return TransitionStopCause.PAUSED;
                    }
                }
                break;
            }
            throw new IllegalStateException("Invalid stop cause for wrap in doLastWraps: " + (Object)((Object)wrapStatus.cause));
        }

        private void finish() throws IOException {
            this.setOutStatus(OutStatus.CHNL_WRITE_DONE);
            this.setInStatus(InStatus.UNWRAP_DONE);
            this.setTaskStatus(CloseTaskStatus.DONE);
            SSLDataChannel.this.socketChannel.close();
            SSLDataChannel.this.logger.log(Level.FINE, () -> String.format("%s close transition finishing", SSLDataChannel.this));
        }
    }

    private static enum InStatus {
        STANDBY,
        CHNL_READ_DONE,
        UNWRAP_DONE;

    }

    private static enum OutStatus {
        STANDBY,
        NEED_LAST_WRAP,
        WRAP_DONE,
        CHNL_WRITE_DONE;

    }

    private static enum CloseTaskStatus {
        STANDBY,
        RUNNING,
        DONE;

    }

    private class ChannelReadTask
    extends ChannelTask {
        private ChannelReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int run() throws IOException {
            if (!Thread.holdsLock(SSLDataChannel.this.netRecvBuffer)) {
                throw new IllegalStateException("Channel read task must be synchronized on netRecvBuffer");
            }
            this.transitToInProgress();
            try {
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s socket channel reading netRecvBuffer.pos=%s, lim=%s", SSLDataChannel.this, SSLDataChannel.this.netRecvBuffer.position(), SSLDataChannel.this.netRecvBuffer.limit()));
                ReadableByteChannel rchnl = SSLDataChannel.this.wrappedReadChannel;
                if (rchnl == NULL_READ_CHANNEL) {
                    SSLDataChannel sSLDataChannel = SSLDataChannel.this;
                    synchronized (sSLDataChannel) {
                        rchnl = SSLDataChannel.this.wrappedReadChannel;
                    }
                }
                int n = rchnl.read(SSLDataChannel.this.netRecvBuffer);
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s socket channel read %s bytes, netRecvBuffer.pos=%s, lim=%s", SSLDataChannel.this, n, SSLDataChannel.this.netRecvBuffer.position(), SSLDataChannel.this.netRecvBuffer.limit()));
                if (n < 0) {
                    SSLDataChannel.this.closeTask.onChannelReadDone();
                }
                int n2 = n;
                return n2;
            }
            finally {
                this.transitToIdle();
            }
        }
    }

    private class ChannelWriteTask
    extends ChannelTask {
        private ChannelWriteTask() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private TransitionStopCause run() throws IOException {
            TransitionStopCause transitionStopCause;
            block9: {
                this.transitToInProgress();
                ByteBuffer byteBuffer = SSLDataChannel.this.netXmitBuffer;
                // MONITORENTER : byteBuffer
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s socket channel writing, %s bytes to write", SSLDataChannel.this, SSLDataChannel.this.netXmitBuffer.position()));
                if (SSLDataChannel.this.netXmitBuffer.position() != 0) break block9;
                SSLDataChannel.this.asyncIOIncompletion.isChannelWriteBusy(false);
                TransitionStopCause transitionStopCause2 = TransitionStopCause.DONE;
                // MONITOREXIT : byteBuffer
                {
                    catch (Throwable throwable) {
                        this.transitToIdle();
                        throw throwable;
                    }
                }
                this.transitToIdle();
                return transitionStopCause2;
            }
            try {
                SSLDataChannel.this.netXmitBuffer.flip();
                transitionStopCause = this.writeChannel();
                SSLDataChannel.this.netXmitBuffer.compact();
            }
            catch (Throwable throwable) {
                SSLDataChannel.this.netXmitBuffer.compact();
                throw throwable;
            }
            this.transitToIdle();
            return transitionStopCause;
        }

        private TransitionStopCause writeChannel() throws IOException {
            int count;
            if (!Thread.holdsLock(SSLDataChannel.this.netXmitBuffer)) {
                throw new IllegalStateException("Write channel without locking on the netXmitBuffer");
            }
            do {
                count = SSLDataChannel.this.socketChannel.write(SSLDataChannel.this.netXmitBuffer);
                SSLDataChannel.this.logger.log(Level.FINEST, () -> String.format("%s socket channel wrote %s bytes, netXmitBuffer remaining %s bytes", SSLDataChannel.this, count, SSLDataChannel.this.netXmitBuffer.remaining()));
                if (SSLDataChannel.this.netXmitBuffer.remaining() != 0) continue;
                SSLDataChannel.this.asyncIOIncompletion.isChannelWriteBusy(false);
                return TransitionStopCause.DONE;
            } while (SSLDataChannel.this.isBlocking() || count != 0);
            SSLDataChannel.this.asyncIOIncompletion.isChannelWriteBusy(true);
            return TransitionStopCause.NB_IS_CHNL_WRITE_BUSY;
        }
    }

    private abstract class ChannelTask {
        private final Object taskLock = new Object();
        private Thread runningThread = null;
        private boolean interrupted = false;

        private ChannelTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void transitToInProgress() throws IOException {
            Object object = this.taskLock;
            synchronized (object) {
                SSLDataChannel.this.crossCloseQuiescentBarrier();
                while (this.runningThread != null) {
                    try {
                        this.taskLock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException("Interrupted when waiting for an IO operation to finish");
                    }
                }
                this.runningThread = Thread.currentThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void transitToIdle() throws IOException {
            Object object = this.taskLock;
            synchronized (object) {
                Thread thread = this.runningThread;
                this.runningThread = null;
                this.taskLock.notifyAll();
                if (this.interrupted && Thread.interrupted()) {
                    this.interrupted = false;
                    throw new InterruptedIOException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptAndAwaitQuiescent() throws IOException {
            Object object = this.taskLock;
            synchronized (object) {
                if (this.runningThread != null) {
                    this.runningThread.interrupt();
                    this.interrupted = true;
                    SSLDataChannel.this.logger.log(Level.FINE, () -> String.format("%s interrupted %s", SSLDataChannel.this, this.getClass().getSimpleName()));
                }
                while (this.runningThread != null) {
                    try {
                        this.taskLock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException("Interrupted when waiting for an IO operation to finish during close");
                    }
                }
            }
        }
    }

    public class AsyncIOIncompletion {
        private volatile boolean isChannelWriteBusy = false;
        private volatile boolean needsChannelReadData = false;
        private volatile boolean needsChannelReadHandshake = false;
        private volatile boolean needsAppRead = false;

        private void isChannelWriteBusy(boolean val) {
            if (!Thread.holdsLock(SSLDataChannel.this.netXmitBuffer)) {
                throw new IllegalStateException("Modify isChannelWriteBusy must hold netXmitBuffer lock");
            }
            this.isChannelWriteBusy = val;
        }

        private void needsChannelReadData(boolean val) {
            if (!Thread.holdsLock(SSLDataChannel.this.netRecvBuffer)) {
                throw new IllegalStateException("Modify needsChannelReadData must hold netRecvBuffer lock");
            }
            this.needsChannelReadData = val;
        }

        private void needsChannelReadHandshake(boolean val) {
            if (!Thread.holdsLock(SSLDataChannel.this.netRecvBuffer)) {
                throw new IllegalStateException("Modify needsChannelReadHandshake must hold netRecvBuffer lock");
            }
            this.needsChannelReadHandshake = val;
        }

        private void needsAppRead(boolean val) {
            if (!Thread.holdsLock(SSLDataChannel.this.appRecvBuffer)) {
                throw new IllegalStateException("Modify needsAppRead must hold appRecvBuffer lock");
            }
            this.needsAppRead = val;
        }

        private DataChannel.AsyncIO.ContinueAction nextAction(DataChannel.AsyncIO.Type type) {
            if (type.equals((Object)DataChannel.AsyncIO.Type.FLUSH)) {
                if (this.isChannelWriteBusy) {
                    return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_CHNL_WRITE_THEN_FLUSH;
                }
                return DataChannel.AsyncIO.ContinueAction.RETRY_NOW;
            }
            if (SSLDataChannel.this.sslEngine.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)) {
                return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_TASKS_EXECUTION;
            }
            if (this.needsAppRead) {
                return DataChannel.AsyncIO.ContinueAction.APP_READ;
            }
            if (this.isChannelWriteBusy) {
                return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_CHNL_WRITE_THEN_FLUSH;
            }
            if (this.needsChannelReadHandshake) {
                return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_CHNL_READ;
            }
            if (type.equals((Object)DataChannel.AsyncIO.Type.WRITE)) {
                return DataChannel.AsyncIO.ContinueAction.RETRY_NOW;
            }
            if (this.needsChannelReadData) {
                return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_CHNL_READ;
            }
            return DataChannel.AsyncIO.ContinueAction.RETRY_NOW;
        }
    }

    private class UnwrapStatus {
        private final long produced;
        private final TransitionStopCause cause;

        private UnwrapStatus(long produced, TransitionStopCause cause) {
            this.produced = produced;
            this.cause = cause;
        }
    }

    private class WrapStatus {
        private final long consumed;
        private final TransitionStopCause cause;

        private WrapStatus(long consumed, TransitionStopCause cause) {
            this.consumed = consumed;
            this.cause = cause;
        }
    }

    static enum TransitionStopCause {
        NB_IS_CHNL_WRITE_BUSY,
        NB_NEEDS_CHNL_READ_DATA,
        NB_NEEDS_CHNL_READ_HANDSHAKE,
        NEEDS_APP_READ,
        NEEDS_HANDSHAKE_TASKS,
        PAUSED,
        DONE;

    }
}

