/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.net.AbstractDataChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;

public class SimpleDataChannel
extends AbstractDataChannel {
    public SimpleDataChannel(SocketChannel socketChannel) {
        super(socketChannel);
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isTrusted() {
        return false;
    }

    @Override
    public boolean isTrustCapable() {
        return false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.socketChannel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socketChannel.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.socketChannel.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socketChannel.write(srcs, offset, length);
    }

    @Override
    public boolean flush() {
        return true;
    }

    @Override
    public void close() throws IOException {
        try {
            this.ensureCloseForBlocking();
        }
        finally {
            this.socketChannel.close();
        }
    }

    @Override
    public boolean closeAsync() throws IOException {
        try {
            this.ensureCloseAsyncForNonBlocking();
        }
        finally {
            this.socketChannel.close();
        }
        return true;
    }

    @Override
    public void closeForcefully() throws IOException {
        this.socketChannel.close();
    }

    @Override
    public DataChannel.AsyncIO.ContinueAction getAsyncIOContinueAction(DataChannel.AsyncIO.Type type) {
        switch (type) {
            case READ: {
                return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_CHNL_READ;
            }
            case WRITE: {
                return DataChannel.AsyncIO.ContinueAction.WAIT_FOR_CHNL_WRITE_THEN_FLUSH;
            }
            case FLUSH: 
            case CLOSE: {
                return DataChannel.AsyncIO.ContinueAction.RETRY_NOW;
            }
        }
        throw new IllegalStateException(String.format("Unknown state for async IO operation: %s", new Object[]{type}));
    }

    @Override
    public void executeTasks(ExecutorService executor, Runnable callback) {
        executor.submit(callback::run);
    }

    public String toString() {
        return String.format("%s%s", this.addressPair, this.isBlocking() ? "BLK" : "NBL");
    }
}

