/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import com.sleepycat.utilint.FormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;

public class Latency
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private int maxTrackedLatencyMillis;
    private int min;
    private int max;
    private float avg;
    private int totalOps;
    private long totalOpsLong;
    private int percent95;
    private int percent99;
    private int opsOverflow;
    private int totalRequests;
    private long totalRequestsLong;

    public Latency(int maxTrackedLatencyMillis) {
        this.maxTrackedLatencyMillis = maxTrackedLatencyMillis;
    }

    public Latency(int maxTrackedLatencyMillis, int minMillis, int maxMillis, float avg, long totalOps, long totalRequests, int percent95, int percent99, int requestsOverflow) {
        this.maxTrackedLatencyMillis = maxTrackedLatencyMillis;
        this.min = minMillis;
        this.max = maxMillis;
        this.avg = avg;
        this.totalOpsLong = totalOps;
        this.totalRequestsLong = totalRequests;
        this.percent95 = percent95;
        this.percent99 = percent99;
        this.opsOverflow = requestsOverflow;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.totalOpsLong == 0L) {
            this.totalOpsLong = this.totalOps;
        }
        if (this.totalRequests == 0) {
            this.totalRequests = this.totalOps;
        }
        if (this.totalRequestsLong == 0L) {
            this.totalRequestsLong = this.totalRequests;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.totalOps = (int)this.totalOpsLong;
        this.totalRequests = (int)this.totalRequestsLong;
        out.defaultWriteObject();
    }

    public Latency clone() {
        try {
            return (Latency)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        if (this.totalOpsLong == 0L) {
            return "No operations";
        }
        DecimalFormat fmt = FormatUtil.decimalScale2();
        return "maxTrackedLatencyMillis=" + fmt.format(this.maxTrackedLatencyMillis) + " totalOps=" + fmt.format(this.totalOpsLong) + " totalReq=" + fmt.format(this.totalRequestsLong) + " reqOverflow=" + fmt.format(this.opsOverflow) + " min=" + fmt.format(this.min) + " max=" + fmt.format(this.max) + " avg=" + fmt.format(this.avg) + " 95%=" + fmt.format(this.percent95) + " 99%=" + fmt.format(this.percent99);
    }

    public long getTotalOps() {
        return this.totalOpsLong;
    }

    public int getTotalOpsInt() {
        return this.totalOps;
    }

    public long getTotalRequests() {
        return this.totalRequestsLong;
    }

    public int getTotalRequestsInt() {
        return this.totalRequests;
    }

    public int getRequestsOverflow() {
        return this.opsOverflow;
    }

    public int getMaxTrackedLatencyMillis() {
        return this.maxTrackedLatencyMillis;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public float getAvg() {
        return this.avg;
    }

    public int get95thPercent() {
        return this.percent95;
    }

    public int get99thPercent() {
        return this.percent99;
    }

    public void rollup(Latency other) {
        if (other == null || other.totalOpsLong == 0L || other.totalRequestsLong == 0L) {
            throw new IllegalStateException("Can't rollup a Latency that doesn't have any data");
        }
        if (this.maxTrackedLatencyMillis != other.maxTrackedLatencyMillis) {
            throw new IllegalStateException("Can't rollup a Latency whose maxTrackedLatencyMillis is different");
        }
        if (this.min > other.min) {
            this.min = other.min;
        }
        if (this.max < other.max) {
            this.max = other.max;
        }
        this.avg = ((float)this.totalRequestsLong * this.avg + (float)other.totalRequestsLong * other.avg) / (float)(this.totalRequestsLong + other.totalRequestsLong);
        this.percent95 = 0;
        this.percent99 = 0;
        this.totalOpsLong += other.totalOpsLong;
        this.totalRequestsLong += other.totalRequestsLong;
        this.opsOverflow += other.opsOverflow;
    }
}

