/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import com.sleepycat.utilint.Latency;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;

public class LatencyStat
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final int maxTrackedLatencyMillis;
    private volatile Values trackedValues;
    private int saveMin;
    private int saveMax;
    private float saveAvg;
    private long saveNumOps;
    private long saveNumRequests;
    private int save95;
    private int save99;
    private int saveRequestsOverflow;

    public LatencyStat(long maxTrackedLatencyMillis) {
        this.maxTrackedLatencyMillis = (int)maxTrackedLatencyMillis;
        this.clear();
    }

    public void clear() {
        this.clearInternal();
    }

    private synchronized Values clearInternal() {
        Values values = this.trackedValues;
        this.trackedValues = new Values(this.maxTrackedLatencyMillis);
        return values;
    }

    public Latency calculate() {
        return this.calculate(false);
    }

    public Latency calculateAndClear() {
        return this.calculate(true);
    }

    private synchronized Latency calculate(boolean clear) {
        long percent99Count;
        long percent95Count;
        Values values = clear ? this.clearInternal() : this.trackedValues;
        long totalOps = values.numOps.get();
        long totalRequests = values.numRequests.get();
        if (totalOps == 0L || totalRequests == 0L) {
            return new Latency(this.maxTrackedLatencyMillis);
        }
        long totalNanos = values.totalNanos.get();
        int nOverflow = values.requestsOverflow.get();
        int maxIncludingOverflow = values.maxIncludingOverflow;
        int minIncludingOverflow = values.minIncludingOverflow;
        float avgMs = (float)((double)totalNanos * 1.0E-6 / (double)totalRequests);
        int percent95 = -1;
        int percent99 = -1;
        int avgMsInt = Math.round(avgMs);
        int max = Math.max(avgMsInt, maxIncludingOverflow);
        int min = Math.min(avgMsInt, minIncludingOverflow);
        long nTrackedRequests = totalRequests - (long)nOverflow;
        if (nTrackedRequests == 1L) {
            percent95Count = 1L;
            percent99Count = 1L;
        } else {
            percent95Count = (long)((double)nTrackedRequests * 0.95);
            percent99Count = (long)((double)nTrackedRequests * 0.99);
        }
        int histogramLength = values.histogram.length();
        long numRequestsSeen = 0L;
        for (int latency = 0; latency < histogramLength; ++latency) {
            int count = values.histogram.get(latency);
            if (count == 0) continue;
            if (min > latency) {
                min = latency;
            }
            if (max < latency) {
                max = latency;
            }
            if (numRequestsSeen < percent95Count) {
                percent95 = latency;
            }
            if (numRequestsSeen < percent99Count) {
                percent99 = latency;
            }
            numRequestsSeen += (long)count;
        }
        this.saveMax = max;
        this.saveMin = min;
        this.saveAvg = avgMs;
        this.saveNumOps = totalOps;
        this.saveNumRequests = totalRequests;
        this.save95 = percent95;
        this.save99 = percent99;
        this.saveRequestsOverflow = nOverflow;
        return new Latency(this.maxTrackedLatencyMillis, this.saveMin, this.saveMax, this.saveAvg, this.saveNumOps, this.saveNumRequests, this.save95, this.save99, this.saveRequestsOverflow);
    }

    public void set(long nanoLatency) {
        this.set(1, nanoLatency);
    }

    public void set(int numRecordedOps, long nanoLatency) {
        if (nanoLatency < 0L) {
            return;
        }
        Values values = this.trackedValues;
        int millisRounded = (int)((nanoLatency + 500000L) / 1000000L);
        if (millisRounded >= this.maxTrackedLatencyMillis) {
            values.requestsOverflow.incrementAndGet();
        } else {
            values.histogram.incrementAndGet(millisRounded);
        }
        while (values.maxIncludingOverflow < millisRounded) {
            values.maxIncludingOverflow = millisRounded;
        }
        while (values.minIncludingOverflow > millisRounded) {
            values.minIncludingOverflow = millisRounded;
        }
        values.totalNanos.addAndGet(nanoLatency);
        values.numOps.addAndGet(numRecordedOps);
        values.numRequests.incrementAndGet();
    }

    public boolean isEmpty() {
        return this.trackedValues.numOps.get() == 0L || this.trackedValues.numRequests.get() == 0L;
    }

    public String toString() {
        Latency results = new Latency(this.maxTrackedLatencyMillis, this.saveMin, this.saveMax, this.saveAvg, this.saveNumOps, this.saveNumRequests, this.save95, this.save99, this.saveRequestsOverflow);
        return results.toString();
    }

    private static class Values {
        final AtomicLong numOps;
        final AtomicLong numRequests;
        final AtomicLong totalNanos;
        final AtomicIntegerArray histogram;
        volatile int minIncludingOverflow;
        volatile int maxIncludingOverflow;
        final AtomicInteger requestsOverflow;

        Values(int maxTrackedLatencyMillis) {
            this.histogram = new AtomicIntegerArray(maxTrackedLatencyMillis);
            this.numOps = new AtomicLong();
            this.numRequests = new AtomicLong();
            this.requestsOverflow = new AtomicInteger();
            this.totalNanos = new AtomicLong();
            this.minIncludingOverflow = Integer.MAX_VALUE;
            this.maxIncludingOverflow = 0;
        }
    }
}

