/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import com.sleepycat.je.utilint.PropUtil;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.KVSecurityConstants;
import oracle.kv.RequestLimitConfig;
import oracle.kv.impl.api.lob.ChunkConfig;
import oracle.kv.impl.security.util.KVStoreLogin;

public class KVStoreConfig
implements Serializable,
Cloneable,
KVSecurityConstants {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    public static final int DEFAULT_OPEN_TIMEOUT = 3000;
    public static final int DEFAULT_READ_TIMEOUT = 30000;
    public static final int DEFAULT_REGISTRY_OPEN_TIMEOUT = 3000;
    public static final int DEFAULT_REGISTRY_READ_TIMEOUT = 10000;
    public static final int DEFAULT_NETWORK_ROUNDTRIP_TIMEOUT = 25;
    private static final Consistency DEFAULT_CONSISTENCY = Consistency.NONE_REQUIRED;
    private static final Durability DEFAULT_DURABILITY = Durability.COMMIT_NO_SYNC;
    static final String DEFAULT_LOB_SUFFIX = ".lob";
    static final long DEFAULT_LOB_VERIFICATION_BYTES = 1024L;
    public static final int DEFAULT_LOB_TIMEOUT = 10000;
    public static int DEFAULT_SG_CACHED_ATTRS_TIMEOUT = 300000;
    public static final int DEFAULT_MAX_CHECK_RETRIES = 10;
    public static final int DEFAULT_MAX_CHECK_INTERVAL_MILLIS = 5000;
    public static final int DEFAULT_CHECK_INIT_DELAY_MILLIS = 10;
    public static final String USE_ASYNC = "oracle.kv.async";
    private static final boolean useAsyncDefault = false;
    private String storeName;
    private String[] helperHosts;
    private Properties securityProps;
    private final Properties masterSecurityProps;
    private int openTimeout;
    private int readTimeout;
    private InetSocketAddress localAddr;
    private int registryOpenTimeout;
    private int registryReadTimeout;
    private int requestTimeout;
    private int networkRoundtripTimeout;
    private Consistency consistency;
    private Durability durability;
    private long lobVerificationBytes;
    private String lobSuffix;
    private int lobTimeout;
    private RequestLimitConfig requestLimitConfig;
    private ChunkConfig lobConfig = new ChunkConfig();
    private String[] readZones = null;
    private int maxCheckRetries;
    private int checkIntervalMillis;
    private int sgAttrsCacheTimeout;
    private boolean useAsync = System.getProperty("oracle.kv.async") == null ? false : Boolean.getBoolean("oracle.kv.async");

    public KVStoreConfig(String storeName, String ... helperHostPort) throws IllegalArgumentException {
        this.setStoreName(storeName);
        this.setHelperHosts(helperHostPort);
        this.openTimeout = 3000;
        this.readTimeout = 30000;
        this.registryOpenTimeout = 3000;
        this.registryReadTimeout = 10000;
        this.requestTimeout = 5000;
        this.networkRoundtripTimeout = 25;
        this.consistency = DEFAULT_CONSISTENCY;
        this.durability = DEFAULT_DURABILITY;
        this.lobVerificationBytes = 1024L;
        this.lobSuffix = DEFAULT_LOB_SUFFIX;
        this.lobTimeout = 10000;
        this.requestLimitConfig = RequestLimitConfig.getDefault();
        this.maxCheckRetries = 10;
        this.checkIntervalMillis = 5000;
        this.masterSecurityProps = KVStoreConfig.readSecurityProps();
        this.securityProps = KVStoreConfig.mergeSecurityProps(null, this.masterSecurityProps);
        this.sgAttrsCacheTimeout = DEFAULT_SG_CACHED_ATTRS_TIMEOUT;
    }

    public KVStoreConfig clone() {
        try {
            KVStoreConfig clone = (KVStoreConfig)super.clone();
            clone.lobConfig = clone.lobConfig.clone();
            return clone;
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    public KVStoreConfig setStoreName(String storeName) throws IllegalArgumentException {
        this.setStoreNameVoid(storeName);
        return this;
    }

    public void setStoreNameVoid(String storeName) throws IllegalArgumentException {
        if (storeName == null) {
            throw new IllegalArgumentException("Store name may not be null");
        }
        this.storeName = storeName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public KVStoreConfig setHelperHosts(String ... helperHostPort) throws IllegalArgumentException {
        this.setHelperHostsVoid(helperHostPort);
        return this;
    }

    public void setHelperHostsVoid(String ... helperHostPort) throws IllegalArgumentException {
        if (helperHostPort.length == 0) {
            throw new IllegalArgumentException("No helperHostPort specified");
        }
        for (String s : helperHostPort) {
            if (s != null) continue;
            throw new IllegalArgumentException("helperHostPort is null");
        }
        this.helperHosts = helperHostPort;
    }

    public String[] getHelperHosts() {
        return this.helperHosts;
    }

    public KVStoreConfig setSocketOpenTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setSocketOpenTimeoutVoid(timeout, unit);
        return this;
    }

    @Deprecated
    public KVStoreConfig setOpenTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setSocketOpenTimeoutVoid(timeout, unit);
        return this;
    }

    public void setSocketOpenTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be negative or zero");
        }
        this.openTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getSocketOpenTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.openTimeout, unit);
    }

    @Deprecated
    public long getOpenTimeout(TimeUnit unit) {
        return this.getSocketOpenTimeout(unit);
    }

    public KVStoreConfig setSocketReadTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setReadTimeoutVoid(timeout, unit);
        return this;
    }

    public void setReadTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be negative or zero");
        }
        this.readTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getSocketReadTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.readTimeout, unit);
    }

    public KVStoreConfig setLocalAddress(InetSocketAddress localAddr) {
        this.setLocalAddressVoid(localAddr);
        return this;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddr;
    }

    private void setLocalAddressVoid(InetSocketAddress localAddr) {
        this.localAddr = localAddr;
    }

    public KVStoreConfig setRequestTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setRequestTimeoutVoid(timeout, unit);
        return this;
    }

    public void setRequestTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be zero or negative");
        }
        this.requestTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getRequestTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.requestTimeout, unit);
    }

    public KVStoreConfig setNetworkRoundtripTimeout(long timeout, TimeUnit unit) {
        this.setNetworkRoundtripTimeoutVoid(timeout, unit);
        return this;
    }

    public void setNetworkRoundtripTimeoutVoid(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        this.networkRoundtripTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getNetworkRoundtripTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.networkRoundtripTimeout, unit);
    }

    public KVStoreConfig setConsistency(Consistency consistency) throws IllegalArgumentException {
        this.setConsistencyVoid(consistency);
        return this;
    }

    public void setConsistencyVoid(Consistency consistency) throws IllegalArgumentException {
        if (consistency == null) {
            throw new IllegalArgumentException("Consistency may not be null");
        }
        this.consistency = consistency;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public KVStoreConfig setDurability(Durability durability) throws IllegalArgumentException {
        this.setDurabilityVoid(durability);
        return this;
    }

    public void setDurabilityVoid(Durability durability) throws IllegalArgumentException {
        if (durability == null) {
            throw new IllegalArgumentException("Durability may not be null");
        }
        this.durability = durability;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public KVStoreConfig setRequestLimit(RequestLimitConfig requestLimitConfig) {
        if (requestLimitConfig == null) {
            throw new IllegalArgumentException("requestLimitConfig may not be null");
        }
        this.requestLimitConfig = requestLimitConfig;
        return this;
    }

    public RequestLimitConfig getRequestLimit() {
        return this.requestLimitConfig;
    }

    public KVStoreConfig setRegistryOpenTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setRegistryOpenTimeoutVoid(timeout, unit);
        return this;
    }

    public void setRegistryOpenTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be negative or zero");
        }
        this.registryOpenTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getRegistryOpenTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.registryOpenTimeout, unit);
    }

    public KVStoreConfig setRegistryReadTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setRegistryReadTimeoutVoid(timeout, unit);
        return this;
    }

    public void setRegistryReadTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be negative or zero");
        }
        this.registryReadTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getRegistryReadTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.registryReadTimeout, unit);
    }

    public long getLOBTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.lobTimeout, unit);
    }

    public KVStoreConfig setLOBTimeout(long timeout, TimeUnit unit) {
        this.setLOBTimeoutVoid(timeout, unit);
        return this;
    }

    public void setLOBTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be negative or zero");
        }
        this.lobTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public String getLOBSuffix() {
        return this.lobSuffix;
    }

    public KVStoreConfig setLOBSuffix(String lobSuffix) {
        this.setLOBSuffixVoid(lobSuffix);
        return this;
    }

    public void setLOBSuffixVoid(String lobSuffix) {
        if (lobSuffix == null || lobSuffix.length() == 0) {
            throw new IllegalArgumentException("The lobSuffix argument must be non-null and have a length > 0 ");
        }
        this.lobSuffix = lobSuffix;
    }

    public long getLOBVerificationBytes() {
        return this.lobVerificationBytes;
    }

    public KVStoreConfig setLOBVerificationBytes(long lobVerificationBytes) {
        this.setLOBVerificationBytesVoid(lobVerificationBytes);
        return this;
    }

    public void setLOBVerificationBytesVoid(long lobVerificationBytes) {
        if (lobVerificationBytes < 0L) {
            throw new IllegalArgumentException("lobVerificationBytes: " + lobVerificationBytes);
        }
        this.lobVerificationBytes = lobVerificationBytes;
    }

    public int getLOBChunksPerPartition() {
        return this.lobConfig.getChunksPerPartition();
    }

    public KVStoreConfig setLOBChunksPerPartition(int lobChunksPerPartition) {
        this.setLOBChunksPerPartitionVoid(lobChunksPerPartition);
        return this;
    }

    public void setLOBChunksPerPartitionVoid(int lobChunksPerPartition) {
        if (lobChunksPerPartition <= 0) {
            throw new IllegalArgumentException("lobChunksPerPartition: " + lobChunksPerPartition);
        }
        this.lobConfig.setChunksPerPartition(lobChunksPerPartition);
    }

    public int getLOBChunkSize() {
        return this.lobConfig.getChunkSize();
    }

    public KVStoreConfig setLOBChunkSize(int chunkSize) {
        this.setLOBChunkSizeVoid(chunkSize);
        return this;
    }

    public void setLOBChunkSizeVoid(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize);
        }
        this.lobConfig.setChunkSize(chunkSize);
    }

    public String[] getReadZones() {
        return this.readZones == null ? null : Arrays.copyOf(this.readZones, this.readZones.length);
    }

    public KVStoreConfig setReadZones(String ... zones) {
        this.setReadZonesVoid(zones);
        return this;
    }

    public void setReadZonesVoid(String[] zones) {
        if (zones == null) {
            this.readZones = null;
        } else {
            if (zones.length == 0) {
                throw new IllegalArgumentException("The zones argument must not be empty");
            }
            String[] copy = Arrays.copyOf(zones, zones.length);
            for (int i = 0; i < copy.length; ++i) {
                String zone = copy[i];
                if (zone == null) {
                    throw new IllegalArgumentException("The zones argument must not contain null elements");
                }
                for (int j = i + 1; j < copy.length; ++j) {
                    if (!zone.equals(copy[j])) continue;
                    throw new IllegalArgumentException("The zones argument must not contain duplicate elements; found multiple copies of '" + zone + "'");
                }
            }
            this.readZones = copy;
        }
    }

    public KVStoreConfig setCheckInterval(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setCheckIntervalVoid(timeout, unit);
        return this;
    }

    public void setCheckIntervalVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout may not be zero or negative");
        }
        this.checkIntervalMillis = PropUtil.durationToMillis(timeout, unit);
    }

    public long getCheckInterval(TimeUnit unit) {
        return PropUtil.millisToDuration(this.checkIntervalMillis, unit);
    }

    public int getMaxCheckRetries() {
        return this.maxCheckRetries;
    }

    public KVStoreConfig setMaxCheckRetries(int maxCheckRetries) {
        this.setMaxCheckRetriesVoid(maxCheckRetries);
        return this;
    }

    public void setMaxCheckRetriesVoid(int maxCheckRetries) {
        if (maxCheckRetries <= 0) {
            throw new IllegalArgumentException("maxCheckRetries: " + maxCheckRetries);
        }
        this.maxCheckRetries = maxCheckRetries;
    }

    public boolean getUseAsync() {
        return this.useAsync;
    }

    public KVStoreConfig setUseAsync(boolean useAsync) {
        this.setUseAsyncVoid(useAsync);
        return this;
    }

    public void setUseAsyncVoid(boolean useAsync) {
        this.useAsync = useAsync;
    }

    public String toString() {
        return "<KVStoreConfig storeName=" + this.storeName + " helperHosts=" + Arrays.toString(this.helperHosts) + " requestTimeout=" + this.requestTimeout + " consistency=" + this.consistency + " durability=" + this.durability + " lobSuffix=" + this.lobSuffix + " lobVerificationBytes=" + this.lobVerificationBytes + " lobTimeout=" + this.lobTimeout + (this.readZones != null ? " readZones=" + Arrays.toString(this.readZones) : "") + ">";
    }

    public KVStoreConfig setSecurityProperties(Properties securityProps) {
        this.setSecurityPropertiesVoid(securityProps);
        return this;
    }

    public void setSecurityPropertiesVoid(Properties securityProps) {
        this.securityProps = KVStoreConfig.mergeSecurityProps(securityProps, this.masterSecurityProps);
    }

    public Properties getSecurityProperties() {
        return (Properties)this.securityProps.clone();
    }

    private static Properties mergeSecurityProps(Properties newSecurityProps, Properties masterSecurityProps) {
        if (newSecurityProps == null) {
            if (masterSecurityProps == null) {
                return new Properties();
            }
            return masterSecurityProps;
        }
        Properties result = (Properties)newSecurityProps.clone();
        if (masterSecurityProps != null) {
            for (String propName : masterSecurityProps.stringPropertyNames()) {
                String propVal = masterSecurityProps.getProperty(propName);
                result.setProperty(propName, propVal);
            }
        }
        return result;
    }

    private static Properties readSecurityProps() throws IllegalArgumentException {
        String securityFile = System.getProperty("oracle.kv.security");
        if (securityFile == null) {
            return null;
        }
        try {
            return KVStoreLogin.createSecurityProperties(securityFile);
        }
        catch (IllegalStateException ise) {
            throw new IllegalArgumentException("An error was encountered while processing the security property file " + securityFile, ise);
        }
    }

    public KVStoreConfig setSGAttrsCacheTimeout(int sgAttrsCacheTimeout) {
        this.sgAttrsCacheTimeout = sgAttrsCacheTimeout;
        return this;
    }

    public int getSGAttrsCacheTimeout() {
        return this.sgAttrsCacheTimeout;
    }
}

