/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import oracle.kv.impl.fault.CommandFaultException;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.util.ErrorMessage;

public interface CommandResult {
    public static final String[] NO_CLEANUP_JOBS = new String[0];
    public static final String[] STORE_CLEANUP = new String[]{"store_clean.kvs"};
    public static final String[] TOPO_REPAIR = new String[]{"plan repair-topology"};
    public static final String[] PLAN_CANCEL = new String[]{"plan_cancel_retry.kvs"};
    public static final String[] TOPO_PLAN_REPAIR = new String[]{"plan repair-topology", "plan_cancel_retry.kvs"};

    public String getReturnValue();

    public String getDescription();

    public int getErrorCode();

    public String[] getCleanupJobs();

    public static class CommandWarns
    implements CommandResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String description;
        private final String returnValue;

        public CommandWarns(String description, String returnValue) {
            this.description = description;
            this.returnValue = returnValue;
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getErrorCode() {
            return ErrorMessage.NOSQL_5000.getValue();
        }

        @Override
        public String[] getCleanupJobs() {
            return null;
        }
    }

    public static class CommandSucceeds
    implements CommandResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String SUCCESS_MSG = "Operation ends successfully";
        private final String returnValue;

        public CommandSucceeds(String returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        @Override
        public String getDescription() {
            return SUCCESS_MSG;
        }

        @Override
        public int getErrorCode() {
            return ErrorMessage.NOSQL_5000.getValue();
        }

        @Override
        public String[] getCleanupJobs() {
            return null;
        }
    }

    public static class CommandFails
    implements CommandResult,
    FastExternalizable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String description;
        private final int errorCode;
        private final String[] cleanupJobs;
        private final String returnValue;

        public CommandFails(String description, ErrorMessage errorMsg, String[] cleanupJobs, String returnValue) {
            this.description = description;
            this.errorCode = errorMsg.getValue();
            this.cleanupJobs = cleanupJobs;
            this.returnValue = returnValue;
        }

        public CommandFails(String description, ErrorMessage errorMsg, String[] cleanupJobs) {
            this(description, errorMsg, cleanupJobs, null);
        }

        public CommandFails(CommandFaultException cfe) {
            this(cfe.getDescription(), cfe.getErrorMessage(), cfe.getCleanupJobs(), null);
        }

        public CommandFails(DataInput in, short serialVersion) throws IOException {
            this.description = SerializationUtil.readString(in, serialVersion);
            this.errorCode = in.readInt();
            int cleanupJobsCount = SerializationUtil.readSequenceLength(in);
            if (cleanupJobsCount == -1) {
                this.cleanupJobs = null;
            } else {
                this.cleanupJobs = new String[cleanupJobsCount];
                for (int i = 0; i < cleanupJobsCount; ++i) {
                    this.cleanupJobs[i] = SerializationUtil.readString(in, serialVersion);
                }
            }
            this.returnValue = SerializationUtil.readString(in, serialVersion);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerializationUtil.writeString(out, serialVersion, this.description);
            out.writeInt(this.errorCode);
            SerializationUtil.writeArrayLength(out, this.cleanupJobs);
            if (this.cleanupJobs != null) {
                for (String e : this.cleanupJobs) {
                    SerializationUtil.writeString(out, serialVersion, e);
                }
            }
            SerializationUtil.writeString(out, serialVersion, this.returnValue);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getErrorCode() {
            return this.errorCode;
        }

        @Override
        public String[] getCleanupJobs() {
            return this.cleanupJobs;
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommandFails)) {
                return false;
            }
            CommandFails other = (CommandFails)o;
            return ObjectUtil.safeEquals(this.description, other.getDescription()) && this.errorCode == other.getErrorCode() && Arrays.equals(this.cleanupJobs, other.getCleanupJobs());
        }

        public int hashCode() {
            int value = 37;
            value += this.description == null ? 17 : this.description.hashCode();
            value = value * 19 + this.errorCode;
            return value;
        }
    }
}

