/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.ConsistencyException;
import oracle.kv.FaultException;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.RequestLimitConfig;
import oracle.kv.impl.api.AsyncRequestHandlerAPI;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcherImpl;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.BlockingResultHandler;
import oracle.kv.impl.async.DelegatingResultHandler;
import oracle.kv.impl.async.EndpointConfigBuilder;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.async.UncaughtResultHandler;
import oracle.kv.impl.async.exception.DialogException;
import oracle.kv.impl.async.exception.DialogUnknownException;
import oracle.kv.impl.async.exception.GetUserException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommonLoggerUtils;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.registry.AsyncRegistryUtils;

public class AsyncRequestDispatcherImpl
extends RequestDispatcherImpl {
    private final long networkRoundtripTimeout;
    private final ThreadLocal<Boolean> deliveringResult = ThreadLocal.withInitial(() -> false);
    private final ScheduledExecutorService executorService = AsyncRegistryUtils.getEndpointGroup().getSchedExecService();
    private final KVThreadFactory backupThreadFactory = new KVThreadFactory(" backup async response delivery", this.logger);

    public AsyncRequestDispatcherImpl(KVStoreConfig config, ClientId clientId, LoginManager loginMgr, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) throws KVStoreException {
        super(config, clientId, loginMgr, exceptionHandler, logger);
        this.networkRoundtripTimeout = config.getNetworkRoundtripTimeout(TimeUnit.MILLISECONDS);
    }

    AsyncRequestDispatcherImpl(String kvsName, ClientId clientId, Topology topology, LoginManager regUtilsLoginMgr, RequestLimitConfig requestLimitConfig, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger, String[] readZones) {
        super(kvsName, clientId, topology, regUtilsLoginMgr, requestLimitConfig, exceptionHandler, logger, readZones);
        this.networkRoundtripTimeout = 25L;
    }

    @Override
    boolean isAsync() {
        return true;
    }

    @Override
    public Response execute(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs, LoginManager loginMgr) throws FaultException {
        BlockingExecuteResultHandler handler = new BlockingExecuteResultHandler(request);
        long timeout = request.getTimeout();
        this.execute(request, targetId, excludeRNs, loginMgr, handler);
        return (Response)handler.await(timeout, this.getAsyncTimeout(timeout));
    }

    long getAsyncTimeout(long requestTimeout) {
        assert (this.networkRoundtripTimeout >= 0L);
        long timeout = requestTimeout + this.networkRoundtripTimeout;
        if (requestTimeout > 0L && timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        return timeout;
    }

    @Override
    public void execute(Request request, Set<RepNodeId> excludeRNs, LoginManager loginMgr, ResultHandler<Response> handler) {
        this.execute(request, null, excludeRNs, loginMgr, handler);
    }

    @Override
    public void execute(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs, LoginManager loginMgr, ResultHandler<Response> handler) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Executing async request={0} targetId={1} handler={2}\n{3}", new Object[]{request, targetId, handler, CommonLoggerUtils.getStackTrace(new Throwable())});
        }
        new AsyncExecuteRequest(request, targetId, excludeRNs, loginMgr, handler).run();
    }

    Exception handleDialogException(Request request, RepNodeState target, DialogException dialogException) {
        if (dialogException instanceof DialogUnknownException) {
            this.throwAsFaultException("Internal error", dialogException);
        }
        if (dialogException.hasSideEffect()) {
            this.faultIfWrite(request, "Communication problem", dialogException);
        }
        target.noteReqHandlerException(dialogException);
        return dialogException;
    }

    @Override
    void throwAsFaultException(String faultMessage, Exception exception) throws FaultException {
        if (exception instanceof GetUserException) {
            Throwable t = ((GetUserException)((Object)exception)).getUserException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t instanceof Exception ? (Exception)t : new IllegalStateException("Unexpected exception: " + t, t);
        }
        super.throwAsFaultException(faultMessage, exception);
    }

    @Override
    public Response executeNOP(RepNodeState rns, int timeoutMs, LoginManager loginMgr) throws Exception {
        BlockingResultHandler<Response> handler = new BlockingResultHandler<Response>(this.getExceptionHandler()){

            @Override
            protected String getDescription() {
                return "executeNOP";
            }
        };
        this.executeNOP(rns, timeoutMs, loginMgr, (ResultHandler<Response>)handler);
        return (Response)handler.awaitChecked(Exception.class, timeoutMs);
    }

    public void executeNOP(RepNodeState rns, int timeoutMs, LoginManager loginMgr, ResultHandler<Response> handler) {
        rns.getReqHandlerRef(this.getRegUtils(), timeoutMs, new NOPResultHandler(rns, timeoutMs, loginMgr, handler));
    }

    @Override
    protected int getMaxActiveRequests() {
        return EndpointConfigBuilder.getOptionDefault(AsyncOption.DLG_LOCAL_MAXDLGS);
    }

    private class NOPResultHandler
    extends DelegatingResultHandler<AsyncRequestHandlerAPI, Response> {
        private final RepNodeState rns;
        private final int timeoutMs;
        private final LoginManager loginMgr;

        NOPResultHandler(RepNodeState rns, int timeoutMs, LoginManager loginMgr, ResultHandler<Response> handler) {
            super(handler);
            this.rns = rns;
            this.timeoutMs = timeoutMs;
            this.loginMgr = loginMgr;
        }

        @Override
        protected void onResultInternal(AsyncRequestHandlerAPI ref, Throwable exception) {
            if (ref == null) {
                this.resultHandler.onResult(null, exception);
                return;
            }
            new ResponseHandler(ref).executeNOP();
        }

        private class ResponseHandler
        extends UncaughtResultHandler<Response> {
            private final AsyncRequestHandlerAPI ref;
            private final long startTimeNs;
            private volatile Request nop;

            ResponseHandler(AsyncRequestHandlerAPI ref) {
                super(AsyncRequestDispatcherImpl.this.getExceptionHandler());
                this.ref = ref;
                NOPResultHandler.this.rns.requestStart();
                AsyncRequestDispatcherImpl.this.activeRequestCount.incrementAndGet();
                this.startTimeNs = AsyncRequestDispatcherImpl.this.statsTracker.markStart();
            }

            void executeNOP() {
                try {
                    int topoSeqNumber = AsyncRequestDispatcherImpl.this.getTopologyManager().getTopology().getSequenceNumber();
                    this.nop = Request.createNOP(topoSeqNumber, AsyncRequestDispatcherImpl.this.getDispatcherId(), NOPResultHandler.this.timeoutMs);
                    this.nop.setSerialVersion(NOPResultHandler.this.rns.getRequestHandlerSerialVersion());
                    if (NOPResultHandler.this.loginMgr != null) {
                        this.nop.setAuthContext(new AuthContext(NOPResultHandler.this.loginMgr.getHandle(NOPResultHandler.this.rns.getRepNodeId()).getLoginToken()));
                    }
                    this.ref.execute(this.nop, AsyncRequestDispatcherImpl.this.getAsyncTimeout(this.nop.getTimeout()), this);
                }
                catch (Throwable e) {
                    this.onResult(null, e);
                }
            }

            @Override
            protected void onResultInternal(Response response, Throwable exception) {
                DialogException de;
                Throwable underlying;
                if (response != null) {
                    try {
                        AsyncRequestDispatcherImpl.this.processResponse(this.startTimeNs, this.nop, response);
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                }
                if (exception instanceof DialogException && (underlying = (de = (DialogException)exception).getUnderlyingException()) instanceof Exception) {
                    NOPResultHandler.this.rns.noteReqHandlerException((Exception)underlying);
                }
                NOPResultHandler.this.rns.requestEnd();
                AsyncRequestDispatcherImpl.this.activeRequestCount.decrementAndGet();
                AsyncRequestDispatcherImpl.this.statsTracker.markFinish(InternalOperation.OpCode.NOP, this.startTimeNs);
                NOPResultHandler.this.resultHandler.onResult(response, exception);
            }
        }
    }

    private class AsyncExecuteRequest
    implements Runnable {
        private final Request request;
        private final RepNodeId targetId;
        private volatile Set<RepNodeId> excludeRNs;
        private final LoginManager loginMgr;
        private final ResultHandler<Response> handler;
        private final RepGroupState rgState;
        private final int initialTimeoutMs;
        private final long limitNs;
        volatile int retryCount;
        private volatile Exception exception;
        volatile RepNodeState target;
        private volatile long retrySleepNs;
        private volatile LoginHandle loginHandle;
        private volatile long startNs;

        AsyncExecuteRequest(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs, LoginManager loginMgr, ResultHandler<Response> handler) {
            this.request = request;
            this.targetId = targetId;
            this.excludeRNs = excludeRNs;
            this.loginMgr = loginMgr;
            this.handler = handler;
            if (handler instanceof BlockingResultHandler) {
                ((BlockingExecuteResultHandler)handler).setAsyncExecuteRequest(this);
            }
            RepGroupId repGroupId = AsyncRequestDispatcherImpl.this.startExecuteRequest(request);
            this.rgState = AsyncRequestDispatcherImpl.this.repGroupStateTable.getGroupState(repGroupId);
            this.initialTimeoutMs = request.getTimeout();
            this.limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.initialTimeoutMs);
            this.retryCount = 0;
            this.exception = null;
            this.target = null;
            this.retrySleepNs = 10000000L;
            this.loginHandle = null;
        }

        @Override
        public void run() {
            while (this.limitNs - System.nanoTime() > 0L) {
                try {
                    this.target = AsyncRequestDispatcherImpl.this.selectTarget(this.request, this.targetId, this.rgState, this.excludeRNs);
                }
                catch (RNUnavailableException e) {
                    this.onResult(null, e);
                    return;
                }
                catch (RequestDispatcherImpl.NoSuitableRNException e) {
                    if (!(this.exception instanceof ConsistencyException)) {
                        this.exception = e;
                    }
                    this.retrySleepNs = AsyncRequestDispatcherImpl.this.computeWaitBeforeRetry(this.limitNs, this.retrySleepNs);
                    if (this.retrySleepNs <= 0L) continue;
                    AsyncRegistryUtils.getEndpointGroup().getSchedExecService().schedule(this, this.retrySleepNs, TimeUnit.NANOSECONDS);
                    return;
                }
                this.startNs = 0L;
                try {
                    AsyncRequestDispatcherImpl.this.activeRequestCount.incrementAndGet();
                    int targetRequestCount = this.target.requestStart();
                    this.startNs = AsyncRequestDispatcherImpl.this.statsTracker.markStart();
                    AsyncRequestDispatcherImpl.this.checkStartDispatchRequest(this.target, targetRequestCount);
                    this.target.getReqHandlerRef(AsyncRequestDispatcherImpl.this.regUtils, TimeUnit.NANOSECONDS.toMillis(this.limitNs - this.startNs), (ResultHandler<AsyncRequestHandlerAPI>)new UncaughtResultHandler<AsyncRequestHandlerAPI>(AsyncRequestDispatcherImpl.this.getExceptionHandler()){

                        @Override
                        protected void onResultInternal(AsyncRequestHandlerAPI api, Throwable e) {
                            AsyncExecuteRequest.this.handleRequestHandler(api, e);
                        }
                    });
                    return;
                }
                catch (Exception dispatchException) {
                    if (!this.handleResponse(null, dispatchException)) continue;
                    return;
                }
            }
            this.onResult(null, AsyncRequestDispatcherImpl.this.getTimeoutException(this.request, this.exception, this.initialTimeoutMs, this.retryCount, this.target));
        }

        void onResult(Response response, Throwable e) {
            if (!((Boolean)AsyncRequestDispatcherImpl.this.deliveringResult.get()).booleanValue()) {
                AsyncRequestDispatcherImpl.this.deliveringResult.set(true);
                try {
                    this.handler.onResult(response, e);
                    return;
                }
                finally {
                    AsyncRequestDispatcherImpl.this.deliveringResult.set(false);
                }
            }
            try {
                AsyncRequestDispatcherImpl.this.executorService.execute(() -> this.onResult(response, e));
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                AsyncRequestDispatcherImpl.this.backupThreadFactory.newThread(() -> this.onResult(response, e)).start();
                return;
            }
        }

        void handleRequestHandler(AsyncRequestHandlerAPI requestHandler, Throwable dispatchException) {
            if (requestHandler == null) {
                if (!(this.exception instanceof ConsistencyException)) {
                    this.exception = new IllegalStateException("Could not establish handle to " + this.target.getRepNodeId());
                }
            } else {
                try {
                    this.loginHandle = AsyncRequestDispatcherImpl.this.prepareRequest(this.request, this.limitNs, this.retryCount, this.target, this.loginMgr);
                    requestHandler.execute(this.request, AsyncRequestDispatcherImpl.this.getAsyncTimeout(this.request.getTimeout()), new HandleResponse());
                    return;
                }
                catch (Exception e) {
                    dispatchException = e;
                }
            }
            if (!this.handleResponse(null, dispatchException)) {
                this.run();
            }
        }

        boolean handleResponse(Response response, Throwable e) {
            boolean done = false;
            if (e != null) {
                Throwable throwException = this.dispatchFailed(e);
                if (throwException != null) {
                    e = throwException;
                    done = true;
                } else {
                    e = this.exception;
                }
            } else if (response != null) {
                done = true;
            }
            this.excludeRNs = AsyncRequestDispatcherImpl.this.dispatchCompleted(this.startNs, this.request, response, this.target, e, this.excludeRNs);
            if (done) {
                this.onResult(response, e);
            }
            return done;
        }

        private Throwable dispatchFailed(Throwable t) {
            if (!(t instanceof Exception)) {
                return t;
            }
            try {
                Exception dispatchException;
                Exception exception = dispatchException = t instanceof DialogException ? AsyncRequestDispatcherImpl.this.handleDialogException(this.request, this.target, (DialogException)t) : AsyncRequestDispatcherImpl.this.handleDispatchException(this.request, this.initialTimeoutMs, this.target, (Exception)t, this.loginHandle);
                if (!(this.exception instanceof ConsistencyException)) {
                    this.exception = dispatchException;
                }
                return null;
            }
            catch (Throwable t2) {
                return t2;
            }
        }

        private class HandleResponse
        extends UncaughtResultHandler<Response> {
            HandleResponse() {
                super(AsyncRequestDispatcherImpl.this.getExceptionHandler());
            }

            @Override
            protected void onResultInternal(Response response, Throwable e) {
                if (!AsyncExecuteRequest.this.handleResponse(response, e)) {
                    AsyncExecuteRequest.this.run();
                }
            }
        }
    }

    private class BlockingExecuteResultHandler
    extends BlockingResultHandler<Response> {
        private final Request request;
        private AsyncExecuteRequest asyncExecuteRequest;

        BlockingExecuteResultHandler(Request request) {
            super(AsyncRequestDispatcherImpl.this.getExceptionHandler());
            this.asyncExecuteRequest = null;
            this.request = request;
        }

        synchronized void setAsyncExecuteRequest(AsyncExecuteRequest asyncExecuteRequest) {
            this.asyncExecuteRequest = asyncExecuteRequest;
        }

        @Override
        protected String getDescription() {
            return this.request.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FaultException getTimeoutException(long timeout) {
            RepNodeState target = null;
            int retryCount = 1;
            BlockingExecuteResultHandler blockingExecuteResultHandler = this;
            synchronized (blockingExecuteResultHandler) {
                if (this.asyncExecuteRequest != null) {
                    target = this.asyncExecuteRequest.target;
                    retryCount = this.asyncExecuteRequest.retryCount;
                }
            }
            return AsyncRequestDispatcherImpl.this.getTimeoutException(this.request, null, (int)timeout, retryCount, target);
        }
    }
}

