/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;

public class KVStoreInternalFactory {
    public static KVStore getStore(KVStoreConfig config, RequestDispatcher dispatcher, LoginManager loginMgr, Logger logger) throws IllegalArgumentException {
        RegistryUtils.setRegistrySocketTimeouts((int)config.getRegistryOpenTimeout(TimeUnit.MILLISECONDS), (int)config.getRegistryReadTimeout(TimeUnit.MILLISECONDS), config.getStoreName());
        String csfName = ClientSocketFactory.factoryName(config.getStoreName(), RepNodeId.getPrefix(), RegistryUtils.InterfaceType.MAIN.interfaceName());
        ClientSocketFactory.configure(csfName, config);
        return new KVStoreImpl(logger, dispatcher, config, loginMgr);
    }

    public static KVStore getStore(RepNodeService repNodeService, Logger logger) {
        String storeName = repNodeService.getParams().getGlobalParams().getKVStoreName();
        KVStoreConfig config = new KVStoreConfig(storeName, "unknownhost:0");
        String hostname = repNodeService.getParams().getStorageNodeParams().getHostname();
        config.setLocalAddress(new InetSocketAddress(hostname, 0));
        return KVStoreInternalFactory.getStore(config, repNodeService.getRepNode().getRequestDispatcher(), repNodeService.getLoginManager(), logger);
    }
}

