/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.utilint.Latency;
import com.sleepycat.utilint.LatencyStat;
import com.sleepycat.utilint.StatsTracker;
import java.net.SocketTimeoutException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.ConsistencyException;
import oracle.kv.DurabilityException;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.MetadataNotFoundException;
import oracle.kv.RequestLimitConfig;
import oracle.kv.RequestLimitException;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.api.AsyncRequestDispatcherImpl;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.rgstate.RepNodeStateUpdateThread;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.fault.TTLFaultException;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.test.ExceptionTestHook;
import oracle.kv.impl.test.ExceptionTestHookExecute;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.WaitableCounter;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.table.Table;

public class RequestDispatcherImpl
implements RequestDispatcher {
    final ResourceId dispatcherId;
    final boolean isRemote;
    final RequestLimitConfig requestLimitConfig;
    final TopologyManager topoManager;
    final RepGroupStateTable repGroupStateTable;
    private final RepNodeStateUpdateThread stateUpdateThread;
    private final LoginManager internalLoginMgr;
    private volatile LoginManager regUtilsLoginMgr = null;
    volatile RegistryUtils regUtils = null;
    final WaitableCounter activeRequestCount = new WaitableCounter();
    final AtomicLong totalRetryCount = new AtomicLong(0L);
    final StatsTracker<InternalOperation.OpCode> statsTracker;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Throwable shutdownException = null;
    private final int requestQuiesceMs;
    final Logger logger;
    private final Set<String> readZones;
    private volatile int[] readZoneIds = null;
    private static final int MAX_LOCATOR_RNS = 10;
    private static final int STATE_UPDATE_THREAD_PERIOD_MS = 1000;
    static final int RETRY_SLEEP_MAX_NS = 128000000;
    private static final int MAX_TOPO_CHANGES_ON_CLIENT = 1000;
    private static final int REQUEST_QUIESCE_MS_DEFAULT = 10000;
    private static final int REQUEST_QUIESCE_POLL_MS = 1000;
    private TestHook<Request> requestExecuteHook;
    volatile ExceptionTestHook<Request, Exception> preExecuteHook;

    public RequestDispatcherImpl(String kvsName, RepNodeParams repNodeParams, LoginManager internalLoginMgr, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        assert (kvsName != null);
        this.logger = logger;
        this.internalLoginMgr = internalLoginMgr;
        this.regUtilsLoginMgr = internalLoginMgr;
        RequestLimitConfig defaultRequestLimitConfig = ParameterUtils.getRequestLimitConfig((ParameterMap)repNodeParams.getMap());
        this.requestLimitConfig = this.getRepNodeRequestLimitConfig(defaultRequestLimitConfig);
        this.topoManager = new TopologyManager(kvsName, repNodeParams.getMaxTopoChanges(), logger);
        RepNodeId repNodeId = repNodeParams.getRepNodeId();
        this.repGroupStateTable = new RepGroupStateTable(repNodeId, this.isAsync(), logger, exceptionHandler);
        this.initTopoManager();
        this.dispatcherId = repNodeId;
        this.isRemote = true;
        this.stateUpdateThread = new RepNodeStateUpdateThread(this, repNodeId, 1000, exceptionHandler, logger);
        int maxTrackedLatencyMillis = ParameterUtils.getMaxTrackedLatencyMillis((ParameterMap)repNodeParams.getMap());
        this.statsTracker = new StatsTracker<InternalOperation.OpCode>(InternalOperation.OpCode.values(), logger, Integer.MAX_VALUE, Long.MAX_VALUE, 0, maxTrackedLatencyMillis);
        this.requestQuiesceMs = repNodeParams.getRequestQuiesceMs();
        this.readZones = null;
        this.stateUpdateThread.start();
    }

    public static RequestDispatcherImpl createForClient(KVStoreConfig config, ClientId clientId, LoginManager loginMgr, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) throws KVStoreException {
        return config.getUseAsync() ? new AsyncRequestDispatcherImpl(config, clientId, loginMgr, exceptionHandler, logger) : new RequestDispatcherImpl(config, clientId, loginMgr, exceptionHandler, logger);
    }

    protected RequestDispatcherImpl(KVStoreConfig config, ClientId clientId, LoginManager loginMgr, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) throws KVStoreException {
        this(config.getStoreName(), clientId, TopologyLocator.get(config.getHelperHosts(), 10, loginMgr, config.getStoreName()), loginMgr, config.getRequestLimit(), exceptionHandler, logger, config.getReadZones(), (int)config.getRequestTimeout(TimeUnit.MILLISECONDS));
        this.stateUpdateThread.start();
    }

    static RequestDispatcherImpl createForClient(boolean useAsync, String kvsName, ClientId clientId, Topology topology, LoginManager regUtilsLoginMgr, RequestLimitConfig requestLimitConfig, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger, String[] readZones) {
        return useAsync ? new AsyncRequestDispatcherImpl(kvsName, clientId, topology, regUtilsLoginMgr, requestLimitConfig, exceptionHandler, logger, readZones) : new RequestDispatcherImpl(kvsName, clientId, topology, regUtilsLoginMgr, requestLimitConfig, exceptionHandler, logger, readZones);
    }

    RequestDispatcherImpl(String kvsName, ClientId clientId, Topology topology, LoginManager regUtilsLoginMgr, RequestLimitConfig requestLimitConfig, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger, String[] readZones) {
        this(kvsName, clientId, topology, regUtilsLoginMgr, requestLimitConfig, exceptionHandler, logger, readZones, 10000);
    }

    private RequestDispatcherImpl(String kvsName, ClientId clientId, Topology topology, LoginManager regUtilsLoginMgr, RequestLimitConfig requestLimitConfig, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger, String[] readZones, int requestQuiesceMs) {
        assert (kvsName != null);
        if (!topology.getKVStoreName().equals(kvsName)) {
            throw new IllegalArgumentException("Specified store name, " + kvsName + ", does not match store name at specified host/port, " + topology.getKVStoreName());
        }
        this.logger = logger;
        this.internalLoginMgr = null;
        this.regUtilsLoginMgr = regUtilsLoginMgr;
        this.statsTracker = new StatsTracker<InternalOperation.OpCode>(InternalOperation.OpCode.values(), logger, Integer.MAX_VALUE, Long.MAX_VALUE, 0, 1000);
        this.requestLimitConfig = requestLimitConfig;
        this.requestQuiesceMs = requestQuiesceMs;
        if (readZones == null) {
            this.readZones = null;
        } else {
            HashSet<String> allZones = new HashSet<String>();
            for (Datacenter zone : topology.getDatacenterMap().getAll()) {
                allZones.add(zone.getName());
            }
            HashSet unknownZones = new HashSet();
            Collections.addAll(unknownZones, readZones);
            unknownZones.removeAll(allZones);
            if (!unknownZones.isEmpty()) {
                throw new IllegalArgumentException("Read zones not found: " + unknownZones);
            }
            this.readZones = new HashSet<String>();
            Collections.addAll(this.readZones, readZones);
            logger.log(Level.FINE, "Set read zones: {0}", this.readZones);
        }
        this.topoManager = new TopologyManager(kvsName, 1000, logger);
        this.repGroupStateTable = new RepGroupStateTable(clientId, this.isAsync(), logger, exceptionHandler);
        this.initTopoManager();
        this.dispatcherId = clientId;
        this.isRemote = false;
        this.stateUpdateThread = new RepNodeStateUpdateThread(this, clientId, 1000, exceptionHandler, logger);
        this.topoManager.update(topology);
    }

    private RequestLimitConfig getRepNodeRequestLimitConfig(RequestLimitConfig defaultConfig) {
        int maxActiveRequests = Math.min(defaultConfig.getNodeLimit(), this.getMaxActiveRequests());
        return new RequestLimitConfig(maxActiveRequests, defaultConfig.getRequestThresholdPercent(), defaultConfig.getNodeLimitPercent());
    }

    int getMaxActiveRequests() {
        String maxConnectionsProperty = System.getProperty("sun.rmi.transport.tcp.maxConnectionThreads");
        if (maxConnectionsProperty != null) {
            try {
                return Integer.parseInt(maxConnectionsProperty);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("RMI max connection threads: " + maxConnectionsProperty);
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void shutdown(Throwable exception) {
        boolean quiesced;
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.shutdownException = exception;
        if (this.stateUpdateThread.isAlive()) {
            this.stateUpdateThread.shutdown();
        }
        if (!(quiesced = this.activeRequestCount.awaitZero(1000, this.requestQuiesceMs))) {
            this.logger.info(this.activeRequestCount.get() + " dispatched requests were in progress on close.");
        }
        this.logger.log(exception != null ? Level.WARNING : Level.INFO, "Dispatcher shutdown", exception);
    }

    void checkShutdown() {
        if (this.shutdown.get()) {
            String message = "Request dispatcher has been shutdown.";
            throw new IllegalStateException("Request dispatcher has been shutdown.", this.shutdownException);
        }
    }

    boolean isAsync() {
        return false;
    }

    public RepNodeStateUpdateThread getStateUpdateThread() {
        return this.stateUpdateThread;
    }

    private void initTopoManager() {
        this.topoManager.addPostUpdateListener(this.repGroupStateTable);
        this.topoManager.addPostUpdateListener(new RegUtilsMaintListener());
        if (this.readZones != null) {
            this.topoManager.addPostUpdateListener(new UpdateReadZoneIds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs, LoginManager loginMgr) throws FaultException {
        RepGroupId repGroupId = this.startExecuteRequest(request);
        RepGroupState rgState = this.repGroupStateTable.getGroupState(repGroupId);
        int initialTimeoutMs = request.getTimeout();
        long limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(initialTimeoutMs);
        int retryCount = 0;
        Exception exception = null;
        RepNodeState target = null;
        long retrySleepNs = 10000000L;
        LoginHandle loginHandle = null;
        do {
            try {
                target = this.selectTarget(request, targetId, rgState, excludeRNs);
            }
            catch (RNUnavailableException e) {
                throw e;
            }
            catch (NoSuitableRNException nsre) {
                if (!(exception instanceof ConsistencyException)) {
                    exception = nsre;
                }
                if ((retrySleepNs = this.computeWaitBeforeRetry(limitNs, retrySleepNs)) <= 0L) continue;
                try {
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(retrySleepNs));
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new OperationFaultException("Unexpected interrupt", ie);
                }
            }
            long startNs = 0L;
            Response response = null;
            try {
                this.activeRequestCount.incrementAndGet();
                int targetRequestCount = target.requestStart();
                startNs = this.statsTracker.markStart();
                this.checkStartDispatchRequest(target, targetRequestCount);
                RequestHandlerAPI requestHandler = target.getReqHandlerRef(this.regUtils, TimeUnit.NANOSECONDS.toMillis(limitNs - startNs));
                if (requestHandler == null) {
                    if (exception instanceof ConsistencyException) continue;
                    exception = new IllegalStateException("Could not establish handle to " + target.getRepNodeId());
                    continue;
                }
                loginHandle = this.prepareRequest(request, limitNs, retryCount++, target, loginMgr);
                response = requestHandler.execute(request);
                exception = null;
                Response response2 = response;
                excludeRNs = this.dispatchCompleted(startNs, request, response, target, exception, excludeRNs);
                return response2;
            }
            catch (Exception dispatchException) {
                Exception newException = this.handleDispatchException(request, initialTimeoutMs, target, dispatchException, loginHandle);
                if (exception instanceof ConsistencyException) continue;
                exception = newException;
            }
            finally {
                excludeRNs = this.dispatchCompleted(startNs, request, response, target, exception, excludeRNs);
            }
        } while (limitNs - System.nanoTime() > 0L);
        throw this.getTimeoutException(request, exception, initialTimeoutMs, retryCount, target);
    }

    RepGroupId startExecuteRequest(Request request) {
        RepGroupId repGroupId;
        this.checkShutdown();
        this.checkTTL(request);
        RepGroupId repGroupId2 = repGroupId = request.getRepGroupId().isNull() ? this.topoManager.getLocalTopology().getRepGroupId(request.getPartitionId()) : request.getRepGroupId();
        if (repGroupId == null) {
            throw new RNUnavailableException("RepNode not yet initialized");
        }
        request.updateForwardingRNs(this.dispatcherId, repGroupId.getGroupId());
        return repGroupId;
    }

    RepNodeState selectTarget(Request request, RepNodeId targetId, RepGroupState rgState, Set<RepNodeId> excludeRNs) throws NoSuitableRNException {
        try {
            return targetId != null ? this.repGroupStateTable.getNodeState(targetId) : this.selectDispatchRN(rgState, request, excludeRNs);
        }
        catch (NoSuitableRNException nsre) {
            if (!request.isInitiatingDispatcher(this.dispatcherId) || this.topoManager.inTransit(request.getPartitionId())) {
                throw new RNUnavailableException(nsre.getMessage());
            }
            if (excludeRNs != null) {
                excludeRNs.clear();
            }
            throw nsre;
        }
    }

    void checkStartDispatchRequest(RepNodeState target, int targetRequestCount) {
        if (this.activeRequestCount.get() > this.requestLimitConfig.getRequestThreshold() && targetRequestCount > this.requestLimitConfig.getNodeLimit()) {
            throw RequestLimitException.create(this.requestLimitConfig, target.getRepNodeId(), this.activeRequestCount.get(), targetRequestCount, this.isRemote);
        }
        if (this.regUtils == null) {
            throw new RNUnavailableException("RepNode not yet initialized");
        }
    }

    LoginHandle prepareRequest(Request request, long limitNs, int retryCount, RepNodeState target, LoginManager loginMgr) throws Exception {
        request.setTimeout((int)TimeUnit.NANOSECONDS.toMillis(limitNs - System.nanoTime()));
        if (retryCount > 0) {
            this.totalRetryCount.incrementAndGet();
        }
        LoginHandle loginHandle = null;
        if (loginMgr != null) {
            loginHandle = loginMgr.getHandle(target.getRepNodeId());
            request.setAuthContext(new AuthContext(loginHandle.getLoginToken()));
        } else if (this.isRemote && request.getAuthContext() != null) {
            this.updateAuthContext(request, target);
        }
        request.setSerialVersion(target.getRequestHandlerSerialVersion());
        assert (ExceptionTestHookExecute.doHookIfSet(this.preExecuteHook, request));
        return loginHandle;
    }

    Set<RepNodeId> dispatchCompleted(long startNs, Request request, Response response, RepNodeState target, Throwable exception, Set<RepNodeId> excludeRNs) {
        if (response != null) {
            this.processResponse(startNs, request, response);
            if (this.logger.isLoggable(Level.FINE)) {
                RepNodeId rnId = response.getRespondingRN();
                RepNodeState rns = this.repGroupStateTable.getNodeState(rnId);
                this.logger.fine("Response from " + rns.printString());
            }
        }
        target.requestEnd();
        int nRecords = response != null ? response.getResult().getNumRecords() : 1;
        this.statsTracker.markFinish(request.getOperation().getOpCode(), startNs, nRecords);
        this.activeRequestCount.decrementAndGet();
        if (exception != null) {
            this.logger.fine(exception.getMessage());
            target.incErrorCount();
        }
        if (response == null || exception != null) {
            excludeRNs = this.excludeRN(excludeRNs, target);
        }
        return excludeRNs;
    }

    FaultException getTimeoutException(Request request, Exception exception, int initialTimeoutMs, int retryCount, RepNodeState target) {
        if (exception instanceof ConsistencyException) {
            ConsistencyException ce = (ConsistencyException)exception;
            ce.setConsistency(request.getConsistency());
            return ce;
        }
        String retryText = retryCount == 1 ? " try." : " retries.";
        return new RequestTimeoutException(initialTimeoutMs, "Request dispatcher: " + this.dispatcherId + ", dispatch timed out after " + retryCount + retryText + " Target: " + (target == null ? "not available" : target.getRepNodeId()), exception, this.isRemote);
    }

    @Override
    public void execute(Request request, Set<RepNodeId> excludeRNs, LoginManager loginMgr, ResultHandler<Response> handler) {
        throw new UnsupportedOperationException("Asynchronous operations are not supported");
    }

    public void execute(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs, LoginManager loginMgr, ResultHandler<Response> handler) throws FaultException {
        throw new UnsupportedOperationException("Asynchronous operations are not supported");
    }

    public int getStateUpdateIntervalMs() {
        return 1000;
    }

    void updateAuthContext(Request request, RepNodeState target) {
        AuthContext currCtx = request.getAuthContext();
        if (currCtx != null && currCtx.getClientHost() == null) {
            request.setAuthContext(new AuthContext(currCtx.getLoginToken(), this.internalLoginMgr.getHandle(target.getRepNodeId()).getLoginToken(), ExecutionContext.getCurrentUserHost()));
        }
    }

    long computeWaitBeforeRetry(long limitNs, long prevWaitNs) {
        long thisWaitNs = Math.min(prevWaitNs << 1, 128000000L);
        long now = System.nanoTime();
        long maxWaitNs = limitNs - now;
        if (maxWaitNs <= 0L) {
            return 0L;
        }
        if (thisWaitNs > maxWaitNs) {
            thisWaitNs = maxWaitNs;
        }
        this.logger.fine("Retrying after wait: " + TimeUnit.NANOSECONDS.toMillis(thisWaitNs) + "ms");
        return thisWaitNs;
    }

    @Override
    public Response executeNOP(RepNodeState rns, int timeoutMs, LoginManager loginMgr) throws Exception {
        RequestHandlerAPI ref = rns.getReqHandlerRef(this.getRegUtils(), timeoutMs);
        if (ref == null) {
            return null;
        }
        rns.requestStart();
        this.activeRequestCount.incrementAndGet();
        long startTimeNs = this.statsTracker.markStart();
        try {
            int topoSeqNumber = this.getTopologyManager().getTopology().getSequenceNumber();
            Request nop = Request.createNOP(topoSeqNumber, this.getDispatcherId(), timeoutMs);
            nop.setSerialVersion(rns.getRequestHandlerSerialVersion());
            if (loginMgr != null) {
                nop.setAuthContext(new AuthContext(loginMgr.getHandle(rns.getRepNodeId()).getLoginToken()));
            }
            Response response = ref.execute(nop);
            this.processResponse(startTimeNs, nop, response);
            Response response2 = response;
            return response2;
        }
        catch (ConnectException | ConnectIOException | NoSuchObjectException | ServerError | UnknownHostException e) {
            rns.noteReqHandlerException(e);
            throw e;
        }
        finally {
            rns.requestEnd();
            this.activeRequestCount.decrementAndGet();
            this.statsTracker.markFinish(InternalOperation.OpCode.NOP, startTimeNs);
        }
    }

    Exception handleDispatchException(Request request, int initialTimeoutMs, RepNodeState target, Exception dispatchException, LoginHandle loginHandle) {
        try {
            throw dispatchException;
        }
        catch (RemoteException re) {
            this.handleRemoteException(request, target, re);
        }
        catch (InterruptedException ie) {
            throw new OperationFaultException("Unexpected interrupt", ie);
        }
        catch (RNUnavailableException ie) {
        }
        catch (SessionAccessException ie) {
        }
        catch (DurabilityException de) {
            if (!de.getNoSideEffects()) {
                throw de;
            }
        }
        catch (ConsistencyException ce) {
            if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                throw ce;
            }
        }
        catch (WrappedClientException wce) {
            if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                throw wce;
            }
            this.handleWrappedClientException((RuntimeException)wce.getCause(), request, loginHandle);
        }
        catch (RequestTimeoutException rte) {
            if (request.isInitiatingDispatcher(this.dispatcherId)) {
                rte.setTimeoutMs(initialTimeoutMs);
            }
            throw rte;
        }
        catch (FaultException fe) {
            if (fe.getFaultClassName().equals(TTLFaultException.class.getName())) {
                if (request.isInitiatingDispatcher(this.dispatcherId)) {
                    return dispatchException;
                }
                if (this.topoManager.inTransit(request.getPartitionId())) {
                    return new RNUnavailableException(fe.getMessage());
                }
            }
            throw fe;
        }
        catch (MetadataNotFoundException fe) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
        return dispatchException;
    }

    private void handleWrappedClientException(RuntimeException re, Request request, LoginHandle loginHandle) {
        if (re instanceof AuthenticationRequiredException) {
            this.handleAuthenticationRequiredException(request, loginHandle, (AuthenticationRequiredException)re);
            return;
        }
        throw re;
    }

    private void handleRemoteException(Request request, RepNodeState rnState, RemoteException exception) {
        this.logger.fine(exception.getMessage());
        try {
            throw exception;
        }
        catch (UnknownHostException uhe) {
            rnState.noteReqHandlerException(uhe);
            return;
        }
        catch (ConnectException ce) {
            rnState.noteReqHandlerException(ce);
            return;
        }
        catch (ConnectIOException cie) {
            rnState.noteReqHandlerException(cie);
            return;
        }
        catch (MarshalException me) {
            this.faultIfWrite(request, "Problem during marshalling", me);
            return;
        }
        catch (UnmarshalException ue) {
            this.faultIfWrite(request, "Problem during unmarshalling", ue);
            return;
        }
        catch (ServerException se) {
            this.faultIfWrite(request, "Exception in server", se);
            return;
        }
        catch (ServerError se) {
            rnState.noteReqHandlerException(se);
            this.faultIfWrite(request, "Error in server", se);
            return;
        }
        catch (NoSuchObjectException noe) {
            rnState.noteReqHandlerException(noe);
            return;
        }
        catch (RemoteException e) {
            this.faultIfWrite(request, "unexpected exception", e);
            return;
        }
    }

    private void handleAuthenticationRequiredException(Request request, LoginHandle loginHandle, AuthenticationRequiredException are) {
        if (request.getAuthContext() == null || loginHandle == null) {
            throw are;
        }
        LoginToken currToken = request.getAuthContext().getLoginToken();
        try {
            if (loginHandle.renewToken(currToken) == currToken) {
                throw are;
            }
        }
        catch (SessionAccessException sae) {
            this.logger.fine(sae.getMessage());
        }
    }

    void checkTTL(Request request) {
        try {
            request.decTTL();
        }
        catch (TTLFaultException ttlfe) {
            if (this.topoManager.inTransit(request.getPartitionId())) {
                throw new RNUnavailableException(ttlfe.getMessage());
            }
            throw ttlfe;
        }
    }

    void faultIfWrite(Request request, String faultMessage, Exception exception) throws FaultException {
        if (request.isWrite()) {
            this.throwAsFaultException(faultMessage, exception);
        }
    }

    void throwAsFaultException(String faultMessage, Exception exception) throws FaultException {
        String message = null;
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            try {
                throw cause;
            }
            catch (SocketTimeoutException STE) {
                message = STE.getMessage();
                break;
            }
            catch (Throwable T) {
                continue;
            }
        }
        if (message == null) {
            throw new FaultException(faultMessage, exception, this.isRemote);
        }
        throw new RequestTimeoutException(0, message, exception, this.isRemote);
    }

    Set<RepNodeId> excludeRN(Set<RepNodeId> excludeSet, RepNodeState rnState) {
        if (rnState == null) {
            return excludeSet;
        }
        if (excludeSet == null) {
            excludeSet = new HashSet<RepNodeId>();
        }
        excludeSet.add(rnState.getRepNodeId());
        return excludeSet;
    }

    public Response execute(Request request, RepNodeId targetId, LoginManager loginMgr) throws FaultException {
        return this.execute(request, targetId, null, loginMgr);
    }

    @Override
    public Response execute(Request request, Set<RepNodeId> excludeRNs, LoginManager loginMgr) throws FaultException {
        return this.execute(request, null, excludeRNs, loginMgr);
    }

    @Override
    public Response execute(Request request, LoginManager loginMgr) throws FaultException {
        return this.execute(request, null, null, loginMgr);
    }

    void processResponse(long startNs, Request request, Response response) {
        TopologyInfo topoInfo = response.getTopoInfo();
        if (topoInfo != null) {
            if (topoInfo.getChanges() != null) {
                this.topoManager.update(topoInfo);
            } else if (topoInfo.getSourceSeqNum() > this.topoManager.getTopology().getSequenceNumber()) {
                this.stateUpdateThread.pullFullTopology(response.getRespondingRN(), topoInfo.getSourceSeqNum());
            }
        }
        this.repGroupStateTable.update(request, response, (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs));
    }

    RepNodeState selectDispatchRN(RepGroupState rgState, Request request, Set<RepNodeId> excludeRNs) throws NoSuitableRNException {
        RepNodeState rnState;
        try {
            assert (TestHookExecute.doHookIfSet(this.requestExecuteHook, request));
        }
        catch (RuntimeException e) {
            throw new NoSuitableRNException("from test");
        }
        boolean needsMaster = request.needsMaster();
        if (needsMaster) {
            RepNodeState master = rgState.getMaster();
            if (master != null && (excludeRNs == null || !excludeRNs.contains(master.getRepNodeId())) && request.isPermittedZone(master.getZoneId())) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Dispatching to master: " + master.getRepNodeId());
                }
                return master;
            }
        } else if (request.needsReplica()) {
            excludeRNs = this.excludeRN(excludeRNs, rgState.getMaster());
        }
        if ((rnState = rgState.getLoadBalancedRN(request, excludeRNs)) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Dispatching target RN: " + rnState.getRepNodeId());
            }
            return rnState;
        }
        RepGroupId groupId = rgState.getResourceId();
        RepNodeState randomRN = rgState.getRandomRN(request, excludeRNs);
        if (randomRN == null) {
            String message = (needsMaster ? "No active (or reachable) master in rep group: " + groupId : "No suitable node currently available to service the request in rep group: " + groupId) + ". Unsuitable nodes: " + (excludeRNs == null ? "none" : excludeRNs) + (this.readZones != null ? ". Read zones: " + this.readZones : "");
            this.logger.fine(message);
            throw new NoSuitableRNException(message);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Dispatching to random RN: " + randomRN.getRepNodeId());
        }
        return randomRN;
    }

    public void logRequestStats() {
        for (RepNodeState rnState : this.repGroupStateTable.getRepNodeStates()) {
            this.logger.info(rnState.printString());
        }
    }

    @Override
    public Topology getTopology() {
        return this.topoManager.getTopology();
    }

    @Override
    public TopologyManager getTopologyManager() {
        return this.topoManager;
    }

    @Override
    public RepGroupStateTable getRepGroupStateTable() {
        return this.repGroupStateTable;
    }

    @Override
    public ResourceId getDispatcherId() {
        return this.dispatcherId;
    }

    @Override
    public PartitionId getPartitionId(byte[] keyBytes) {
        return this.topoManager.getTopology().getPartitionId(keyBytes);
    }

    @Override
    public RegistryUtils getRegUtils() {
        return this.regUtils;
    }

    @Override
    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.stateUpdateThread.getUncaughtExceptionHandler();
    }

    @Override
    public void setRegUtilsLoginManager(LoginManager loginMgr) {
        this.regUtilsLoginMgr = loginMgr;
        this.updateRegUtils();
    }

    private synchronized void updateRegUtils() {
        Topology topo = this.topoManager.getTopology();
        this.regUtils = new RegistryUtils(topo, this.regUtilsLoginMgr);
    }

    @Override
    public Table getTable(KVStoreImpl store, String namespace, String tableName) throws FaultException {
        return this.getTable(store, namespace, tableName, 0);
    }

    @Override
    public Table getTable(KVStoreImpl store, String namespace, String tableName, int cost) throws FaultException {
        if (tableName == null || tableName.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid name " + tableName);
        }
        Exception cause = null;
        TableImpl table = null;
        for (RepNodeId rnid : this.getRepNodeIds()) {
            try {
                try {
                    cause = null;
                    table = this.getTableFromRepNode(namespace, tableName, cost, rnid);
                    if (table == null) continue;
                    return table;
                }
                catch (AuthenticationRequiredException are) {
                    LoginManager requestLoginMgr = KVStoreImpl.getLoginManager(store);
                    if (!store.tryReauthenticate(requestLoginMgr)) {
                        throw are;
                    }
                    table = this.getTableFromRepNode(namespace, tableName, cost, rnid);
                    if (table == null) continue;
                    return table;
                }
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (cause != null) {
            if (cause instanceof KVSecurityException) {
                throw (KVSecurityException)cause;
            }
            String nsName = NameUtils.makeQualifiedName(namespace, tableName);
            String message = "Exception getting table " + nsName + ": " + cause.getMessage();
            throw new FaultException(message, cause, true);
        }
        return null;
    }

    @Override
    public Table getTableById(KVStoreImpl store, long tableId) {
        Exception cause = null;
        TableImpl table = null;
        for (RepNodeId rnid : this.getRepNodeIds()) {
            try {
                try {
                    cause = null;
                    table = this.getTableFromRepNode(tableId, rnid);
                    if (table == null) continue;
                    return table;
                }
                catch (AuthenticationRequiredException are) {
                    LoginManager requestLoginMgr = KVStoreImpl.getLoginManager(store);
                    if (!store.tryReauthenticate(requestLoginMgr)) {
                        throw are;
                    }
                    table = this.getTableFromRepNode(tableId, rnid);
                    if (table == null) continue;
                    return table;
                }
                catch (UnsupportedOperationException uoe) {
                }
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (cause != null) {
            if (cause instanceof KVSecurityException) {
                throw (KVSecurityException)cause;
            }
            String message = "Unable to find table with id " + TableImpl.createIdString(tableId) + ": " + cause.getMessage();
            throw new FaultException(message, cause, true);
        }
        return null;
    }

    @Override
    public TableMetadata getTableMetadata() throws FaultException {
        Exception cause = null;
        TableMetadata md = null;
        for (RepNodeId rnid : this.getRepNodeIds()) {
            try {
                cause = null;
                md = this.getTableMetadataFromRepNode(rnid);
                if (md == null) continue;
                return md;
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (cause != null) {
            String message = "Unable to get table metadata:" + cause.getMessage();
            throw new FaultException(message, cause, true);
        }
        return null;
    }

    private Set<RepNodeId> getRepNodeIds() {
        return this.getTopologyManager().getTopology().getRepNodeIds();
    }

    private TableImpl getTableFromRepNode(String namespace, String tableName, int cost, RepNodeId rnid) throws Exception {
        if (this.regUtils == null) {
            return null;
        }
        RepNodeAdminAPI repNodeAdmin = this.regUtils.getRepNodeAdmin(rnid);
        if (repNodeAdmin == null) {
            return null;
        }
        if (cost == 0) {
            return (TableImpl)repNodeAdmin.getMetadata(Metadata.MetadataType.TABLE, new TableMetadata.TableMetadataKey(namespace, tableName).getMetadataKey(), 0);
        }
        return (TableImpl)repNodeAdmin.getTable(namespace, tableName, cost);
    }

    private TableImpl getTableFromRepNode(long tableId, RepNodeId rnid) throws Exception {
        if (this.regUtils == null) {
            return null;
        }
        RepNodeAdminAPI repNodeAdmin = this.regUtils.getRepNodeAdmin(rnid);
        if (repNodeAdmin != null) {
            return (TableImpl)repNodeAdmin.getTableById(tableId);
        }
        return null;
    }

    private TableMetadata getTableMetadataFromRepNode(RepNodeId rnid) throws Exception {
        if (this.regUtils == null) {
            return null;
        }
        RepNodeAdminAPI repNodeAdmin = this.regUtils.getRepNodeAdmin(rnid);
        if (repNodeAdmin != null) {
            return (TableMetadata)repNodeAdmin.getMetadata(Metadata.MetadataType.TABLE);
        }
        return null;
    }

    @Override
    public Map<InternalOperation.OpCode, Latency> getLatencyStats(boolean clear) {
        HashMap<InternalOperation.OpCode, Latency> map = new HashMap<InternalOperation.OpCode, Latency>();
        for (Map.Entry<InternalOperation.OpCode, LatencyStat> entry : this.statsTracker.getIntervalLatency().entrySet()) {
            Latency latency = clear ? entry.getValue().calculateAndClear() : entry.getValue().calculate();
            map.put(entry.getKey(), latency);
        }
        return map;
    }

    @Override
    public long getTotalRetryCount(boolean clear) {
        return clear ? this.totalRetryCount.getAndSet(0L) : this.totalRetryCount.get();
    }

    public void setTestHook(TestHook<Request> hook) {
        this.requestExecuteHook = hook;
    }

    public void setPreExecuteHook(ExceptionTestHook<Request, Exception> hook) {
        this.preExecuteHook = hook;
    }

    @Override
    public int[] getReadZoneIds() {
        return this.readZoneIds;
    }

    static /* synthetic */ int[] access$402(RequestDispatcherImpl x0, int[] x1) {
        x0.readZoneIds = x1;
        return x1;
    }

    private class UpdateReadZoneIds
    implements TopologyManager.PostUpdateListener {
        private UpdateReadZoneIds() {
        }

        @Override
        public boolean postUpdate(Topology topo) {
            assert (RequestDispatcherImpl.this.readZones != null);
            ArrayList<Integer> ids = new ArrayList<Integer>(RequestDispatcherImpl.this.readZones.size());
            HashSet unknownZones = new HashSet(RequestDispatcherImpl.this.readZones);
            for (Datacenter zone : topo.getDatacenterMap().getAll()) {
                if (!RequestDispatcherImpl.this.readZones.contains(zone.getName())) continue;
                ids.add(((DatacenterId)zone.getResourceId()).getDatacenterId());
                unknownZones.remove(zone.getName());
            }
            if (!unknownZones.isEmpty() && RequestDispatcherImpl.this.logger.isLoggable(Level.WARNING)) {
                RequestDispatcherImpl.this.logger.warning("Some read zones not found: " + unknownZones);
            }
            int[] array = new int[ids.size()];
            int i = 0;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                array[i++] = id;
            }
            RequestDispatcherImpl.access$402(RequestDispatcherImpl.this, array);
            if (RequestDispatcherImpl.this.logger.isLoggable(Level.FINE)) {
                RequestDispatcherImpl.this.logger.log(Level.FINE, "Updated read zone IDs: {0}", ids);
            }
            return false;
        }
    }

    private class RegUtilsMaintListener
    implements TopologyManager.PostUpdateListener {
        private RegUtilsMaintListener() {
        }

        @Override
        public boolean postUpdate(Topology topology) {
            RequestDispatcherImpl.this.updateRegUtils();
            return false;
        }
    }

    class NoSuitableRNException
    extends Exception {
        NoSuitableRNException(String message) {
            super(message);
        }
    }
}

