/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.util.SerializationUtil;

public class ResultIndexRows
extends ResultKeyValueVersion {
    private final byte[] indexKeyBytes;

    public ResultIndexRows(byte[] indexKeyBytes, byte[] primaryKeyBytes, byte[] valueBytes, Version version, long expirationTime) {
        super(primaryKeyBytes, valueBytes, version, expirationTime);
        this.indexKeyBytes = indexKeyBytes;
    }

    public ResultIndexRows(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.indexKeyBytes = SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.indexKeyBytes);
    }

    public byte[] getIndexKeyBytes() {
        return this.indexKeyBytes;
    }
}

