/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.query;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.ExecutionSubscription;
import oracle.kv.FastExternalizableException;
import oracle.kv.StatementResult;
import oracle.kv.impl.api.query.BoundStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.async.AsyncIterationHandleImpl;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.Statement;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.TableIterator;
import org.reactivestreams.Subscription;

public class QueryStatementResultImpl
implements StatementResult {
    private final PreparedStatementImpl statement;
    private final AsyncExecutionHandleImpl executionHandle;
    private final QueryResultIterator iterator;
    private boolean closed;

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, PreparedStatementImpl stmt, boolean async) {
        this(tableAPI, options, stmt, null, async, null, null);
    }

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, BoundStatementImpl stmt, boolean async) {
        this(tableAPI, options, stmt.getPreparedStmt(), stmt.getPreparedStmt().getExternalVarsArray(stmt.getVariables()), async, null, null);
    }

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, BoundStatementImpl stmt, boolean async, Set<Integer> partitions, Set<RepGroupId> shards) {
        this(tableAPI, options, stmt.getPreparedStmt(), stmt.getPreparedStmt().getExternalVarsArray(stmt.getVariables()), async, partitions, shards);
    }

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, PreparedStatementImpl stmt, boolean async, Set<Integer> partitions, Set<RepGroupId> shards) {
        this(tableAPI, options, stmt, null, async, partitions, shards);
    }

    private QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, PreparedStatementImpl ps, FieldValue[] externalVars, boolean async, Set<Integer> partitions, Set<RepGroupId> shards) {
        if (ps.hasExternalVars() && externalVars == null) {
            throw new IllegalArgumentException("The query contains external variables, none of which has been bound. Create a BoundStatement to bind the variables");
        }
        this.statement = ps;
        PlanIter iter = ps.getQueryPlan();
        RecordDef resultDef = ps.getResultDef();
        Logger logger = tableAPI.getStore().getLogger();
        this.executionHandle = async ? new AsyncExecutionHandleImpl(logger) : null;
        RuntimeControlBlock rcb = new RuntimeControlBlock(tableAPI.getStore(), tableAPI.getStore().getLogger(), tableAPI.getTableMetadataHelper(), partitions, shards, options, iter, ps.getNumIterators(), ps.getNumRegisters(), externalVars);
        this.iterator = new QueryResultIterator(rcb, iter, resultDef);
        this.closed = false;
    }

    @Override
    public void close() {
        this.iterator.close();
        this.closed = true;
    }

    @Override
    public RecordDef getResultDef() {
        if (this.closed) {
            throw new IllegalStateException("Statement result already closed.");
        }
        return this.iterator.getResultDef();
    }

    @Override
    public TableIterator<RecordValue> iterator() {
        if (this.executionHandle != null) {
            throw new IllegalStateException("Application-driven iteration is not allowed for queries executed in asynchronous mode");
        }
        if (this.closed) {
            throw new IllegalStateException("Statement result already closed.");
        }
        return this.iterator;
    }

    public AsyncIterationHandleImpl<RecordValue> getExecutionHandle() {
        return this.executionHandle;
    }

    @Override
    public int getPlanId() {
        return 0;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public String getInfoAsJson() {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isDone() {
        return !this.iterator.hasNext();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public String getResult() {
        return null;
    }

    @Override
    public StatementResult.Kind getKind() {
        return StatementResult.Kind.QUERY;
    }

    public int getReadKB() {
        return this.iterator.getReadKB();
    }

    public int getWriteKB() {
        return this.iterator.getWriteKB();
    }

    public byte[] getContinuationKey() {
        return this.iterator.getContinuationKey();
    }

    public boolean reachedLimit() {
        return this.iterator.reachedLimit();
    }

    public boolean hasSortPhase1Result() {
        return this.iterator.hasSortPhase1Result();
    }

    public int writeSortPhase1Results(DataOutput out, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        return this.iterator.writeSortPhase1Results(out, valWriter);
    }

    private class AsyncExecutionHandleImpl
    extends AsyncIterationHandleImpl<RecordValue> {
        AsyncExecutionHandleImpl(Logger logger) {
            super(logger);
        }

        @Override
        protected Subscription createSubscription() {
            return new ExecutionSubscriptionImpl();
        }

        private class ExecutionSubscriptionImpl
        extends AsyncIterationHandleImpl.IterationSubscriptionImpl
        implements ExecutionSubscription {
            private ExecutionSubscriptionImpl() {
                super(AsyncExecutionHandleImpl.this);
            }

            @Override
            public StatementResult.Kind getKind() {
                return QueryStatementResultImpl.this.getKind();
            }

            @Override
            public Statement getStatement() {
                return QueryStatementResultImpl.this.statement;
            }

            @Override
            public int getPlanId() {
                return QueryStatementResultImpl.this.getPlanId();
            }

            @Override
            public String getInfo() {
                return QueryStatementResultImpl.this.getInfo();
            }

            @Override
            public String getInfoAsJson() {
                return QueryStatementResultImpl.this.getInfoAsJson();
            }
        }
    }

    private class QueryResultIterator
    implements AsyncTableIterator<RecordValue> {
        private final RuntimeControlBlock rcb;
        private final PlanIter rootIter;
        private final RecordDef resultDef;
        private boolean hasNext;
        private boolean hasNextLocal;

        QueryResultIterator(RuntimeControlBlock rcb, PlanIter iter, RecordDef resultDef) {
            this.rcb = rcb;
            this.rootIter = iter;
            this.resultDef = resultDef;
            if (QueryStatementResultImpl.this.executionHandle != null) {
                iter.setIterationHandleNotifier(QueryStatementResultImpl.this.executionHandle);
                QueryStatementResultImpl.this.executionHandle.setIterator(this);
            }
            try {
                this.rootIter.open(rcb);
                this.updateHasNext(QueryStatementResultImpl.this.executionHandle != null);
            }
            catch (QueryStateException qse) {
                Logger logger = rcb.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qse.toString());
                }
                throw new IllegalStateException(qse.toString());
            }
            catch (QueryException qe) {
                throw qe.getIllegalArgument();
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (FastExternalizableException fee) {
                throw fee;
            }
            catch (RuntimeException re) {
                String msg = "Query execution failed: " + re;
                Logger logger = rcb.getStore().getLogger();
                if (logger != null) {
                    logger.warning(msg);
                }
                throw re;
            }
        }

        public boolean hasSortPhase1Result() {
            return this.rootIter instanceof ReceiveIter && ((ReceiveIter)this.rootIter).hasSortPhase1Result(this.rcb);
        }

        public int writeSortPhase1Results(DataOutput out, CloudSerializer.FieldValueWriter valWriter) throws IOException {
            return ((ReceiveIter)this.rootIter).writeSortPhase1Results(this.rcb, out, valWriter);
        }

        private void updateHasNext(boolean localOnly) {
            if (localOnly) {
                this.hasNextLocal = this.rootIter.nextLocal(this.rcb);
                this.hasNext = this.hasNextLocal || !this.rootIter.isDone(this.rcb);
            } else {
                this.hasNext = this.rootIter.next(this.rcb);
            }
        }

        RecordDef getResultDef() {
            return this.resultDef;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public RecordValue next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            return this.nextInternal(false);
        }

        @Override
        public RecordValue nextLocal() {
            if (!this.hasNextLocal) {
                this.updateHasNext(true);
            }
            if (!this.hasNextLocal) {
                return null;
            }
            return this.nextInternal(true);
        }

        private RecordValue nextInternal(boolean localOnly) {
            RecordValue record;
            try {
                FieldValueImpl resVal = this.rcb.getRegVal(this.rootIter.getResultReg());
                if (resVal.isTuple()) {
                    assert (this.resultDef == null || this.resultDef.equals(resVal.getDefinition()));
                    record = ((TupleValue)resVal).toRecord();
                } else {
                    assert (resVal.isRecord());
                    record = (RecordValue)((Object)resVal);
                }
                this.updateHasNext(localOnly);
            }
            catch (QueryStateException qse) {
                Logger logger = this.rcb.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qse.toString());
                }
                throw new IllegalStateException(qse.toString());
            }
            catch (QueryException qe) {
                throw qe.getIllegalArgument();
            }
            return record;
        }

        @Override
        public Throwable getCloseException() {
            return this.rootIter.getCloseException(this.rcb);
        }

        @Override
        public void close() {
            if (!this.isClosed()) {
                this.rootIter.close(this.rcb);
                this.hasNext = false;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            if (this.rcb.getTableIterator() != null) {
                return this.rcb.getTableIterator().getShardMetrics();
            }
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            if (this.rcb.getTableIterator() != null) {
                return this.rcb.getTableIterator().getShardMetrics();
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isClosed() {
            return this.rootIter.isDone(this.rcb);
        }

        public int getReadKB() {
            return this.rcb.getReadKB();
        }

        public int getWriteKB() {
            return this.rcb.getWriteKB();
        }

        public byte[] getContinuationKey() {
            return this.rcb.getContinuationKey();
        }

        public boolean reachedLimit() {
            return this.rcb.getReachedLimit();
        }
    }
}

