/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ObjectUtil;

public class RepGroupState {
    private final RepGroupId repGroupId;
    private final ResourceId trackerId;
    private final boolean async;
    private final Logger logger;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private volatile RepNodeId groupMasterId;
    private long lastChange;
    private final Map<RepNodeId, RepNodeState> rns;
    private final Map<Metadata.MetadataType, Integer> seqNums = Collections.synchronizedMap(new EnumMap(Metadata.MetadataType.class));
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    static volatile int randomRN;

    public RepGroupState(RepGroupId repGroupId, ResourceId trackerId, boolean async, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.repGroupId = repGroupId;
        this.trackerId = trackerId;
        this.async = async;
        this.logger = ObjectUtil.checkNull("logger", logger);
        this.exceptionHandler = ObjectUtil.checkNull("exceptionHandler", exceptionHandler);
        this.rns = new ConcurrentHashMap<RepNodeId, RepNodeState>(3);
    }

    public RepGroupId getResourceId() {
        return this.repGroupId;
    }

    public Collection<RepNodeState> getRepNodeStates() {
        return this.rns.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeState get(RepNodeId rnId) {
        RepNodeState repNodeState;
        assert (rnId.getGroupId() == this.repGroupId.getGroupId());
        try {
            this.lock.readLock().lock();
            repNodeState = this.rns.get(rnId);
            if (repNodeState != null) {
                RepNodeState repNodeState2 = repNodeState;
                return repNodeState2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.lock.writeLock().lock();
            repNodeState = this.rns.get(rnId);
            if (repNodeState == null) {
                repNodeState = new RepNodeState(rnId, this.trackerId, this.async, this.logger, this.exceptionHandler);
                this.rns.put(rnId, repNodeState);
            }
            RepNodeState repNodeState3 = repNodeState;
            return repNodeState3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public RepNodeState getMaster() {
        RepNodeId stableGroupMasterId = this.groupMasterId;
        return stableGroupMasterId == null ? null : this.get(stableGroupMasterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(RepGroup rg, Topology topology) {
        try {
            this.lock.writeLock().lock();
            Collection<RepNode> shardRNs = rg.getRepNodes();
            for (RepNode rn : shardRNs) {
                RepNodeId rnId = (RepNodeId)rn.getResourceId();
                RepNodeState rnState = this.rns.get(rnId);
                if (rnState == null) {
                    rnState = new RepNodeState(rnId, this.trackerId, this.async, this.logger, this.exceptionHandler);
                    this.rns.put(rnId, rnState);
                }
                StorageNode sn = topology.get(rn.getStorageNodeId());
                rnState.setZoneId(sn.getDatacenterId());
            }
            if (shardRNs.size() < this.rns.size()) {
                Iterator<RepNodeId> iter = this.rns.keySet().iterator();
                while (iter.hasNext()) {
                    RepNodeId rnId = iter.next();
                    if (rg.get(rnId) != null) continue;
                    iter.remove();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(RepNodeId rnId, RepNodeId masterId, ReplicatedEnvironment.State state, long time) {
        try {
            this.lock.writeLock().lock();
            if (time <= this.lastChange) {
                return;
            }
            if (!state.isActive()) {
                assert (masterId == null);
                RepNodeState rnState = this.get(rnId);
                rnState.updateRepState(state);
                return;
            }
            this.lastChange = time;
            assert (!ReplicatedEnvironment.State.MASTER.equals((Object)state) || rnId.equals(masterId));
            assert (!ReplicatedEnvironment.State.REPLICA.equals((Object)state) || masterId != null && !rnId.equals(masterId));
            this.groupMasterId = masterId = ReplicatedEnvironment.State.MASTER.equals((Object)state) ? rnId : masterId;
            for (RepNodeState rnState : this.rns.values()) {
                if (rnState.getRepNodeId().equals(rnId)) {
                    rnState.updateRepState(state);
                    continue;
                }
                if (rnState.getRepNodeId().equals(masterId)) {
                    rnState.updateRepState(ReplicatedEnvironment.State.MASTER);
                    continue;
                }
                if (!rnState.getRepState().isMaster()) continue;
                rnState.updateRepState(ReplicatedEnvironment.State.REPLICA);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeState getLoadBalancedRN(Request request, Set<RepNodeId> excludeRNs) {
        try {
            this.lock.readLock().lock();
            RepNodeState repNodeState = this.getLeastBusyRN(request, excludeRNs);
            return repNodeState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private RepNodeState getLeastBusyRN(Request request, Set<RepNodeId> excludeRNs) {
        long minRespTime = Integer.MAX_VALUE;
        RepNodeState minRN = null;
        int minActiveRequestCount = Integer.MAX_VALUE;
        for (RepNodeState rn : this.rns.values()) {
            Consistency consistency;
            if (excludeRNs != null && excludeRNs.contains(rn.getRepNodeId()) || rn.reqHandlerNeedsRepair() || !rn.getRepState().isActive() || !request.isPermittedZone(rn.getZoneId()) || !this.inConsistencyRange(rn, consistency = request.getConsistency())) continue;
            int avRespTimeMs = rn.getAvReadRespTimeMs();
            int activeRequestCount = rn.getActiveRequestCount();
            if (activeRequestCount > minActiveRequestCount || activeRequestCount == minActiveRequestCount && (long)avRespTimeMs > minRespTime) continue;
            minRN = rn;
            minRespTime = avRespTimeMs;
            minActiveRequestCount = activeRequestCount;
        }
        return minRN;
    }

    private boolean inConsistencyRange(RepNodeState rn, Consistency consistency) {
        if (consistency == null) {
            return true;
        }
        if (consistency == Consistency.NONE_REQUIRED) {
            return true;
        }
        if (consistency == Consistency.NONE_REQUIRED_NO_MASTER) {
            return !rn.getRepNodeId().equals(this.groupMasterId);
        }
        if (consistency == Consistency.ABSOLUTE) {
            return rn.getRepNodeId().equals(this.groupMasterId);
        }
        if (consistency instanceof Consistency.Version) {
            Consistency.Version vConsistency = (Consistency.Version)consistency;
            return rn.inConsistencyRange(System.currentTimeMillis(), vConsistency);
        }
        if (consistency instanceof Consistency.Time) {
            Consistency.Time tConsistency = (Consistency.Time)consistency;
            return rn.inConsistencyRange(System.currentTimeMillis(), tConsistency, this.getMaster());
        }
        throw new IllegalStateException("Unexpected consistency: " + consistency);
    }

    private RepNodeState getBestRespTimeRN(Set<RepNodeId> excludeRNs) {
        RepNodeState[] activeRNs = new RepNodeState[this.rns.size()];
        int sumAvRespTimesMs = 0;
        int totalActivity = 0;
        int index = 0;
        for (RepNodeState rn : this.rns.values()) {
            if (excludeRNs != null && excludeRNs.contains(rn.getRepNodeId()) || !rn.getRepState().isActive()) continue;
            activeRNs[index++] = rn;
            sumAvRespTimesMs += rn.getAvReadRespTimeMs();
            totalActivity += rn.getActiveRequestCount();
        }
        for (Object checkThreshold : (Object)new boolean[]{true, false}) {
            long minRespTime = Integer.MAX_VALUE;
            RepNodeState minRN = null;
            int minActiveRequestCount = Integer.MAX_VALUE;
            for (RepNodeState rn : activeRNs) {
                if (rn == null) break;
                int avRespTimeMs = rn.getAvReadRespTimeMs();
                int activeRequestCount = rn.getActiveRequestCount();
                if (minRespTime < (long)avRespTimeMs || minRespTime == (long)avRespTimeMs && activeRequestCount > minActiveRequestCount || checkThreshold != false && !this.belowActivityThreshold(avRespTimeMs, sumAvRespTimesMs, activeRequestCount, totalActivity)) continue;
                minRN = rn;
                minRespTime = avRespTimeMs;
                minActiveRequestCount = activeRequestCount;
            }
            if (minRN == null) continue;
            return minRN;
        }
        return null;
    }

    private boolean belowActivityThreshold(int avRespTimeMs, int sumAvRespTimesMs, int activeRequestCount, int totalActivity) {
        if (totalActivity == 0 || sumAvRespTimesMs == 0) {
            return true;
        }
        int targetActivityPercent = (sumAvRespTimesMs - avRespTimeMs) * 100 / sumAvRespTimesMs;
        return activeRequestCount * 100 / totalActivity < targetActivityPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeState getRandomRN(Request request, Set<RepNodeId> excludeRNs) {
        if (this.rns.isEmpty()) {
            return null;
        }
        try {
            this.lock.readLock().lock();
            int rnIndex = randomRN++ % this.rns.size();
            for (RepNodeState rn : this.rns.values()) {
                --rnIndex;
                if (excludeRNs != null && excludeRNs.contains(rn.getRepNodeId()) || request != null && !request.isPermittedZone(rn.getZoneId())) continue;
                if (rnIndex >= 0) continue;
                RepNodeState repNodeState = rn;
                return repNodeState;
            }
            Iterator<RepNodeState> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSeqNum(Metadata.MetadataType type) {
        assert (type != Metadata.MetadataType.TOPOLOGY);
        Map<Metadata.MetadataType, Integer> map = this.seqNums;
        synchronized (map) {
            Integer seqNum = this.seqNums.get((Object)type);
            return seqNum == null ? -1 : seqNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSeqNum(Metadata.MetadataType type, int newSeqNum) {
        assert (type != Metadata.MetadataType.TOPOLOGY);
        Map<Metadata.MetadataType, Integer> map = this.seqNums;
        synchronized (map) {
            int oldSeqNum = this.getSeqNum(type);
            if (oldSeqNum < newSeqNum) {
                this.seqNums.put(type, newSeqNum);
                return newSeqNum;
            }
            return oldSeqNum;
        }
    }

    public String toString() {
        return "RepGroupState[" + this.repGroupId + ", " + this.groupMasterId + "]";
    }
}

