/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.Consistency;
import oracle.kv.impl.api.AsyncRequestHandlerAPI;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.async.FailureResultHandler;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.async.UncaughtResultHandler;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.registry.AsyncRegistryUtils;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RepNodeState {
    private final RepNodeId rnId;
    private final ResourceId trackerId;
    private final Logger logger;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private volatile DatacenterId znId = null;
    private final ReqHandlerRef reqHandlerRef;
    private volatile ReplicatedEnvironment.State repState = null;
    private final VLSNState vlsnState;
    private int topoSeqNum = -1;
    public static final int SAMPLE_SIZE = 8;
    private final ResponseTimeAccumulator readAccumulator;
    private final AtomicLong accumRespTimeMs = new AtomicLong(0L);
    private final AtomicInteger activeRequestCount = new AtomicInteger(0);
    private volatile int maxActiveRequestCount = 0;
    private volatile long totalRequestCount;
    private volatile int errorCount;
    public static int RATE_INTERVAL_MS = 10000;

    RepNodeState(RepNodeId rnId, ResourceId trackerId, boolean async, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler) {
        this(rnId, trackerId, async, logger, exceptionHandler, RATE_INTERVAL_MS);
    }

    RepNodeState(RepNodeId rnId, ResourceId trackerId, boolean async, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler, int rateIntervalMs) {
        this.rnId = rnId;
        this.trackerId = trackerId;
        this.logger = ObjectUtil.checkNull("logger", logger);
        this.exceptionHandler = ObjectUtil.checkNull("exceptionHandler", exceptionHandler);
        this.readAccumulator = new ResponseTimeAccumulator();
        this.reqHandlerRef = async ? new AsyncReqHandlerRef() : new SyncReqHandlerRef();
        this.vlsnState = new VLSNState(rateIntervalMs);
        this.repState = ReplicatedEnvironment.State.REPLICA;
    }

    public RepNodeId getRepNodeId() {
        return this.rnId;
    }

    public DatacenterId getZoneId() {
        return this.znId;
    }

    public void setZoneId(DatacenterId znId) {
        this.znId = znId;
    }

    public RequestHandlerAPI getReqHandlerRef(RegistryUtils registryUtils, long timeoutMs) {
        return this.reqHandlerRef.getSync(registryUtils, timeoutMs);
    }

    public void getReqHandlerRef(RegistryUtils registryUtils, long timeoutMs, ResultHandler<AsyncRequestHandlerAPI> hand) {
        this.reqHandlerRef.getAsync(registryUtils, timeoutMs, hand);
    }

    public boolean reqHandlerNeedsResolution() {
        return this.reqHandlerRef.needsResolution();
    }

    public boolean reqHandlerNeedsRepair() {
        return this.reqHandlerRef.needsRepair();
    }

    public void resolveReqHandlerRef(RegistryUtils registryUtils, long timeoutMs, ResultHandler<Boolean> handler) {
        this.reqHandlerRef.resolve(registryUtils, timeoutMs, handler);
    }

    public void resetReqHandlerRef() {
        this.reqHandlerRef.reset();
    }

    public void noteReqHandlerException(Exception e) {
        this.reqHandlerRef.noteException(e);
    }

    public short getRequestHandlerSerialVersion() {
        return this.reqHandlerRef.getSerialVersion();
    }

    public ReplicatedEnvironment.State getRepState() {
        return this.repState;
    }

    void updateRepState(ReplicatedEnvironment.State state) {
        this.repState = state;
    }

    VLSN getVLSN() {
        return this.vlsnState.getVLSN();
    }

    boolean isObsoleteVLSNState() {
        return this.vlsnState.isObsolete();
    }

    void updateVLSN(VLSN newVLSN) {
        this.vlsnState.updateVLSN(newVLSN);
    }

    int getTopoSeqNum() {
        return this.topoSeqNum;
    }

    synchronized void updateTopoSeqNum(int newTopoSeqNum) {
        if (this.topoSeqNum < newTopoSeqNum) {
            this.topoSeqNum = newTopoSeqNum;
        }
    }

    synchronized void resetTopoSeqNum(int endSeqNum) {
        this.topoSeqNum = endSeqNum;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int incErrorCount() {
        return ++this.errorCount;
    }

    int getAvReadRespTimeMs() {
        return this.readAccumulator.getAverage();
    }

    public void accumRespTime(boolean forWrite, int responseTimeMs) {
        if (!forWrite) {
            this.readAccumulator.update(responseTimeMs);
        }
        this.accumRespTimeMs.getAndAdd(responseTimeMs);
    }

    int getActiveRequestCount() {
        return this.activeRequestCount.get();
    }

    public int getMaxActiveRequestCount() {
        return this.maxActiveRequestCount;
    }

    public long getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public long getAccumRespTimeMs() {
        return this.accumRespTimeMs.get();
    }

    public void resetStatsCounts() {
        this.totalRequestCount = 0L;
        this.maxActiveRequestCount = 0;
        this.accumRespTimeMs.set(0L);
        this.errorCount = 0;
    }

    public int requestStart() {
        ++this.totalRequestCount;
        int count = this.activeRequestCount.incrementAndGet();
        this.maxActiveRequestCount = Math.max(this.maxActiveRequestCount, count);
        return count;
    }

    public void requestEnd() {
        int newValue = this.activeRequestCount.decrementAndGet();
        if (newValue < 0) {
            throw new IllegalStateException("The active request count should not become negative");
        }
    }

    public String printString() {
        return String.format("node: %s state: %s errors: %,dav resp time %,d ms total requests: %,d", this.getRepNodeId().toString(), this.getRepState().toString(), this.getErrorCount(), this.getAvReadRespTimeMs(), this.getTotalRequestCount());
    }

    public String toString() {
        return "RepNodeState[" + this.getRepNodeId() + ", " + (Object)((Object)this.getRepState()) + "]";
    }

    boolean inConsistencyRange(long timeMs, Consistency.Version consistency) {
        assert (consistency != null);
        VLSN consistencyVLSN = new VLSN(consistency.getVersion().getVLSN());
        return this.vlsnState.vlsnAt(timeMs).compareTo(consistencyVLSN) >= 0;
    }

    boolean inConsistencyRange(long timeMs, Consistency.Time consistency, RepNodeState master) {
        assert (consistency != null);
        if (master == null) {
            return true;
        }
        long lagMs = consistency.getPermissibleLag(TimeUnit.MILLISECONDS);
        VLSN consistencyVLSN = master.vlsnState.vlsnAt(timeMs - lagMs);
        return this.vlsnState.vlsnAt(timeMs).compareTo(consistencyVLSN) >= 0;
    }

    private static class VLSNState {
        private volatile VLSN vlsn = VLSN.NULL_VLSN;
        private long lastUpdateMs;
        private VLSN intervalStart = VLSN.NULL_VLSN;
        private long intervalStartMs = 0L;
        private long vlsnsPerSec = 0L;
        private final int rateIntervalMs;

        private VLSNState(int rateIntervalMs) {
            this.rateIntervalMs = rateIntervalMs;
        }

        private VLSN getVLSN() {
            return this.vlsn;
        }

        private synchronized boolean isObsolete() {
            return this.lastUpdateMs + (long)this.rateIntervalMs < System.currentTimeMillis();
        }

        private synchronized void updateVLSN(VLSN newVLSN) {
            long intervalMs;
            if (newVLSN == null || newVLSN.isNull()) {
                return;
            }
            this.lastUpdateMs = System.currentTimeMillis();
            if (newVLSN.compareTo(this.vlsn) > 0) {
                this.vlsn = newVLSN;
            }
            if ((intervalMs = this.lastUpdateMs - this.intervalStartMs) <= (long)this.rateIntervalMs) {
                return;
            }
            if (this.intervalStartMs == 0L) {
                this.resetRate(this.lastUpdateMs);
                return;
            }
            long vlsnDelta = this.vlsn.getSequence() - this.intervalStart.getSequence();
            if (vlsnDelta < 0L) {
                this.resetRate(this.lastUpdateMs);
            } else {
                this.intervalStart = this.vlsn;
                this.intervalStartMs = this.lastUpdateMs;
                this.vlsnsPerSec = vlsnDelta * 1000L / intervalMs;
            }
        }

        private synchronized VLSN vlsnAt(long timeMs) {
            if (this.vlsn.isNull()) {
                return VLSN.NULL_VLSN;
            }
            long deltaMs = timeMs - this.lastUpdateMs;
            long vlsnAt = this.vlsn.getSequence() + deltaMs * this.vlsnsPerSec / 1000L;
            return vlsnAt < 0L ? new VLSN(0L) : new VLSN(vlsnAt);
        }

        private void resetRate(long now) {
            this.intervalStart = this.vlsn;
            this.intervalStartMs = now;
            this.vlsnsPerSec = 0L;
        }
    }

    private static class ExceptionSummary {
        private int errorCount = 0;
        private Exception exception = null;
        private long exceptionTimeMs = 0L;

        private ExceptionSummary() {
        }

        private void noteException(Exception e) {
            this.exception = e;
            ++this.errorCount;
            this.exceptionTimeMs = System.currentTimeMillis();
        }

        private Exception getException() {
            return this.exception;
        }

        private long getExceptionTimeMs() {
            return this.exceptionTimeMs;
        }

        private int getErrorCount() {
            return this.errorCount;
        }
    }

    private class AsyncReqHandlerRef
    extends ReqHandlerRef {
        private AsyncRequestHandlerAPI requestHandler;
        private ExceptionSummary exceptionSummary;
        private boolean resolving;
        private final List<ResolveHandler> handlers;

        private AsyncReqHandlerRef() {
            this.handlers = new ArrayList<ResolveHandler>();
        }

        @Override
        synchronized void reset() {
            this.requestHandler = null;
            this.serialVersion = SerialVersion.CURRENT;
            this.exceptionSummary = null;
        }

        @Override
        synchronized boolean needsResolution() {
            return this.requestHandler == null;
        }

        @Override
        synchronized boolean needsRepair() {
            return this.exceptionSummary != null;
        }

        @Override
        void resolve(RegistryUtils registryUtils, long timeoutMs, final ResultHandler<Boolean> handler) {
            class ResolveResultHandler
            extends FailureResultHandler<AsyncRequestHandlerAPI> {
                ResolveResultHandler() {
                    super(resultHandler);
                }

                @Override
                protected void onResultInternal(AsyncRequestHandlerAPI ref, Throwable e) {
                    handler.onResult(ref != null, e);
                }
            }
            this.resolveInternal(registryUtils, timeoutMs, new ResolveResultHandler(), true);
        }

        @Override
        void getAsync(RegistryUtils registryUtils, long timeoutMs, ResultHandler<AsyncRequestHandlerAPI> handler) {
            this.resolveInternal(registryUtils, timeoutMs, handler, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveInternal(RegistryUtils registryUtils, long timeoutMs, ResultHandler<AsyncRequestHandlerAPI> handler, boolean tryResolve) {
            AsyncRequestHandlerAPI rh;
            Exception exception = null;
            AsyncReqHandlerRef asyncReqHandlerRef = this;
            synchronized (asyncReqHandlerRef) {
                Exception lastEx;
                rh = this.requestHandler;
                if (rh == null && registryUtils != null && (tryResolve || !this.needsRepair())) {
                    ScheduledExecutorService execService = AsyncRegistryUtils.getEndpointGroup().getSchedExecService();
                    ResolveHandler h = new ResolveHandler(handler, execService, timeoutMs);
                    if (!this.resolving) {
                        this.resolving = true;
                        this.getRequestHandler(registryUtils, timeoutMs);
                    }
                    return;
                }
                if (this.exceptionSummary != null && (lastEx = this.exceptionSummary.getException()) instanceof AuthenticationFailureException) {
                    exception = lastEx;
                    this.exceptionSummary = null;
                }
            }
            handler.onResult(rh, exception);
        }

        private void getRequestHandler(RegistryUtils registryUtils, long timeoutMs) {
            AsyncRegistryUtils.getRequestHandler(registryUtils.getTopology(), RepNodeState.this.rnId, RepNodeState.this.trackerId, timeoutMs, RepNodeState.this.logger, (ResultHandler<AsyncRequestHandlerAPI>)new UncaughtResultHandler<AsyncRequestHandlerAPI>(RepNodeState.this.exceptionHandler){

                @Override
                protected void onResultInternal(AsyncRequestHandlerAPI r, Throwable e) {
                    AsyncReqHandlerRef.this.deliverResult(r, e);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverResult(AsyncRequestHandlerAPI rh, Throwable e) {
            AsyncReqHandlerRef asyncReqHandlerRef = this;
            synchronized (asyncReqHandlerRef) {
                assert (this.resolving);
                this.requestHandler = rh;
                if (rh != null) {
                    this.serialVersion = rh.getSerialVersion();
                    this.exceptionSummary = null;
                } else if (e == null) {
                    this.noteException(new IllegalArgumentException(RepNodeState.this.rnId + " not in topology"));
                } else if (e instanceof Exception) {
                    this.noteException((Exception)e);
                } else {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new AssertionError((Object)e);
                }
            }
            while (true) {
                ResolveHandler handler;
                AsyncReqHandlerRef asyncReqHandlerRef2 = this;
                synchronized (asyncReqHandlerRef2) {
                    if (this.handlers.isEmpty()) {
                        this.resolving = false;
                        break;
                    }
                    handler = this.handlers.remove(0);
                }
                handler.onResult(rh, e);
            }
        }

        @Override
        synchronized void noteException(Exception e) {
            this.requestHandler = null;
            if (this.exceptionSummary == null) {
                this.exceptionSummary = new ExceptionSummary();
            }
            this.exceptionSummary.noteException(e);
        }

        private class ResolveHandler
        implements Runnable {
            private ResultHandler<AsyncRequestHandlerAPI> handler;
            private Future<?> future;
            private boolean done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ResolveHandler(ResultHandler<AsyncRequestHandlerAPI> handler, ScheduledExecutorService executor, long timeoutMs) {
                if (RepNodeState.this.logger.isLoggable(Level.FINEST)) {
                    RepNodeState.this.logger.finest("AsyncReqHandlerRef.ResolveHandler create handler=" + handler + " timeoutMs=" + timeoutMs);
                }
                assert (handler != null);
                ScheduledFuture<?> f = executor.schedule(this, timeoutMs, TimeUnit.MILLISECONDS);
                boolean cancel = false;
                AsyncReqHandlerRef asyncReqHandlerRef2 = AsyncReqHandlerRef.this;
                synchronized (asyncReqHandlerRef2) {
                    if (this.done) {
                        cancel = true;
                    } else {
                        this.handler = handler;
                        this.future = f;
                        AsyncReqHandlerRef.this.handlers.add(this);
                    }
                }
                if (cancel) {
                    f.cancel(false);
                    if (RepNodeState.this.logger.isLoggable(Level.FINEST)) {
                        RepNodeState.this.logger.finest("AsyncReqHandlerRef.ResolveHandler cancel handler=" + handler);
                    }
                }
            }

            @Override
            public void run() {
                this.onResult(null, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void onResult(AsyncRequestHandlerAPI rh, Throwable e) {
                Future<?> f;
                ResultHandler<AsyncRequestHandlerAPI> h;
                AsyncReqHandlerRef asyncReqHandlerRef = AsyncReqHandlerRef.this;
                synchronized (asyncReqHandlerRef) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    h = this.handler;
                    f = this.future;
                    this.handler = null;
                    this.future = null;
                    AsyncReqHandlerRef.this.handlers.remove(this);
                }
                if (RepNodeState.this.logger.isLoggable(Level.FINEST)) {
                    RepNodeState.this.logger.finest("AsyncReqHandlerRef.ResolveHandler onResult handler=" + this.handler + " rh=" + rh + " e=" + e);
                }
                if (h != null) {
                    h.onResult(rh, e);
                }
                if (f != null) {
                    f.cancel(false);
                }
            }
        }
    }

    private class SyncReqHandlerRef
    extends ReqHandlerRef {
        private final Semaphore semaphore;
        private volatile RequestHandlerAPI requestHandler;
        private volatile ExceptionSummary exceptionSummary;

        private SyncReqHandlerRef() {
            this.semaphore = new Semaphore(1, true);
            this.requestHandler = null;
            this.exceptionSummary = null;
        }

        @Override
        void reset() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new OperationFaultException("Unexpected interrupt", e);
            }
            try {
                this.requestHandler = null;
                this.serialVersion = SerialVersion.CURRENT;
                this.exceptionSummary = null;
            }
            finally {
                this.semaphore.release();
            }
        }

        @Override
        boolean needsResolution() {
            return this.requestHandler == null;
        }

        @Override
        boolean needsRepair() {
            return this.exceptionSummary != null;
        }

        @Override
        void resolve(RegistryUtils registryUtils, long timeoutMs, ResultHandler<Boolean> handler) {
            try {
                handler.onResult(this.resolve(registryUtils, timeoutMs) != null, null);
            }
            catch (Exception e) {
                handler.onResult(null, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RequestHandlerAPI resolve(RegistryUtils registryUtils, long timeoutMs) {
            RequestHandlerAPI refNonVolatile = this.requestHandler;
            if (refNonVolatile != null) {
                return refNonVolatile;
            }
            boolean waited = false;
            try {
                if (!this.semaphore.tryAcquire()) {
                    if (!this.semaphore.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS)) {
                        return null;
                    }
                    waited = true;
                }
            }
            catch (InterruptedException e) {
                throw new OperationFaultException("Unexpected interrupt", e);
            }
            if (waited) {
                boolean needsRepair = true;
                try {
                    needsRepair = this.needsRepair();
                    if (needsRepair) {
                        RequestHandlerAPI requestHandlerAPI = null;
                        return requestHandlerAPI;
                    }
                }
                finally {
                    if (needsRepair) {
                        this.semaphore.release();
                    }
                }
            }
            try {
                if (this.requestHandler != null) {
                    RequestHandlerAPI needsRepair = this.requestHandler;
                    return needsRepair;
                }
                if (registryUtils == null) {
                    RequestHandlerAPI needsRepair = null;
                    return needsRepair;
                }
                this.requestHandler = registryUtils.getRequestHandler(RepNodeState.this.rnId);
                if (this.requestHandler == null) {
                    this.noteExceptionInternal(new IllegalArgumentException(RepNodeState.this.rnId + " not in topology"));
                    RequestHandlerAPI needsRepair = null;
                    return needsRepair;
                }
                this.serialVersion = this.requestHandler.getSerialVersion();
                this.exceptionSummary = null;
                RequestHandlerAPI needsRepair = this.requestHandler;
                return needsRepair;
            }
            finally {
                this.semaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        RequestHandlerAPI getSync(RegistryUtils registryUtils, long timeoutMs) {
            RequestHandlerAPI refNonVolatile = this.requestHandler;
            if (refNonVolatile != null) {
                return refNonVolatile;
            }
            if (this.exceptionSummary == null) {
                return this.resolve(registryUtils, timeoutMs);
            }
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new OperationFaultException("Unexpected interrupt", e);
            }
            try {
                if (this.exceptionSummary == null) {
                    RequestHandlerAPI e = null;
                    return e;
                }
                Exception lastException = this.exceptionSummary.getException();
                if (lastException instanceof AuthenticationFailureException) {
                    this.exceptionSummary = null;
                    throw (AuthenticationFailureException)lastException;
                }
            }
            finally {
                this.semaphore.release();
            }
            return null;
        }

        @Override
        void noteException(Exception e) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException ie) {
                throw new OperationFaultException("Unexpected interrupt", ie);
            }
            try {
                this.noteExceptionInternal(e);
            }
            finally {
                this.semaphore.release();
            }
        }

        private void noteExceptionInternal(Exception e) {
            assert (this.semaphore.availablePermits() == 0);
            this.requestHandler = null;
            if (this.exceptionSummary == null) {
                this.exceptionSummary = new ExceptionSummary();
            }
            this.exceptionSummary.noteException(e);
        }
    }

    private abstract class ReqHandlerRef {
        volatile short serialVersion = SerialVersion.CURRENT;

        ReqHandlerRef() {
        }

        abstract void reset();

        short getSerialVersion() {
            return this.serialVersion;
        }

        abstract boolean needsResolution();

        abstract boolean needsRepair();

        abstract void resolve(RegistryUtils var1, long var2, ResultHandler<Boolean> var4);

        RequestHandlerAPI getSync(RegistryUtils registryUtils, long timeoutMs) {
            throw new UnsupportedOperationException("The sync operation is not supported");
        }

        void getAsync(RegistryUtils registryUtils, long timeoutMs, ResultHandler<AsyncRequestHandlerAPI> handler) {
            throw new UnsupportedOperationException("The async operation is not supported");
        }

        abstract void noteException(Exception var1);
    }

    private static class ResponseTimeAccumulator {
        final short[] samples = new short[8];
        int sumMs = 0;
        int index = 0;

        private ResponseTimeAccumulator() {
        }

        private synchronized void update(int sampleMs) {
            if (sampleMs > Short.MAX_VALUE) {
                sampleMs = Short.MAX_VALUE;
            }
            this.index = ++this.index >= 8 ? 0 : this.index;
            this.sumMs += sampleMs - this.samples[this.index];
            this.samples[this.index] = (short)sampleMs;
        }

        private int getAverage() {
            return this.sumMs / 8;
        }
    }

    private static class AttributeValue<V> {
        final V value;
        final long sequence;

        private AttributeValue(V value, long sequence) {
            this.value = value;
            this.sequence = sequence;
        }

        private V getValue() {
            return this.value;
        }

        private long getSequence() {
            return this.sequence;
        }
    }
}

