/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.rgstate.UpdateThreadPoolExecutor;
import oracle.kv.impl.async.UncaughtResultHandler;
import oracle.kv.impl.rep.admin.IllegalRepNodeServiceStateException;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultException;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.RateLimitingLogger;
import oracle.kv.impl.util.registry.RegistryUtils;

public abstract class UpdateThread
extends Thread {
    private static final int LIMIT_RNS = 100;
    private static final int ONE_MINUTE_MS = 60000;
    protected final RequestDispatcher requestDispatcher;
    protected final UpdateThreadPoolExecutor threadPool;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    protected final int periodMs;
    private final int resolutionTimeoutMs = 10000;
    private volatile int resolveCount;
    private volatile int resolveFailCount;
    private volatile int resolveExceptionCount;
    protected final Logger logger;
    private final RateLimitingLogger<RepNodeId> rateLimitingLogger;

    protected UpdateThread(RequestDispatcher requestDispatcher, int periodMs, Thread.UncaughtExceptionHandler handler, Logger logger) {
        this.requestDispatcher = requestDispatcher;
        this.periodMs = periodMs;
        this.logger = logger;
        this.rateLimitingLogger = new RateLimitingLogger(60000, 100, logger);
        String name = " " + requestDispatcher.getDispatcherId() + " " + this.getClass().getSimpleName();
        this.setName(name);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(handler);
        int keepAliveTimeMs = periodMs * 5;
        this.threadPool = new UpdateThreadPoolExecutor(logger, keepAliveTimeMs, new UpdateThreadFactory(logger, name, handler));
    }

    UpdateThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public int getResolveCount() {
        return this.resolveCount;
    }

    public int getResolveFailCount() {
        return this.resolveFailCount;
    }

    public int getResolveExceptionCount() {
        return this.resolveExceptionCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.logger.log(Level.INFO, "{0} started", this);
        try {
            while (!this.shutdown.get()) {
                this.doUpdate();
                if (this.shutdown.get()) {
                    return;
                }
                try {
                    Thread.sleep(this.periodMs);
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.WARNING, "{0} interrupted", this);
                    throw new IllegalStateException(e);
                    return;
                }
            }
        }
        catch (Throwable t) {
            this.requestDispatcher.shutdown(t);
            return;
        }
        finally {
            this.shutdown();
        }
    }

    protected abstract void doUpdate();

    protected Collection<RepNodeState> getRNs() {
        ResourceId dispatcherId = this.requestDispatcher.getDispatcherId();
        RepGroupStateTable rgst = this.requestDispatcher.getRepGroupStateTable();
        if (dispatcherId.getType() == ResourceId.ResourceType.CLIENT) {
            return rgst.getRepNodeStates();
        }
        if (dispatcherId.getType() == ResourceId.ResourceType.REP_NODE) {
            Collection<RepNodeState> rns = rgst.getRNStatesNeedingRepair();
            RepNodeId rnId = (RepNodeId)dispatcherId;
            rns.addAll(this.getRNs(new RepGroupId(rnId.getGroupId())));
            return rns;
        }
        throw new IllegalStateException("Unexpected dispatcher: " + dispatcherId);
    }

    protected RepGroupState getRepGroupState(RepGroupId groupId) {
        RepGroupStateTable rgst = this.requestDispatcher.getRepGroupStateTable();
        return rgst.getGroupState(groupId);
    }

    protected Collection<RepNodeState> getRNs(RepGroupId groupId) {
        return this.getRepGroupState(groupId).getRepNodeStates();
    }

    protected boolean needsResolution(RepNodeState rnState) {
        if (!rnState.reqHandlerNeedsResolution()) {
            return false;
        }
        this.threadPool.execute(new ResolveHandler(rnState));
        return true;
    }

    public void shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.logger.log(Level.INFO, "{0} shutdown", this);
        this.threadPool.shutdownNow();
    }

    protected void logBrief(RepNodeId rnId, Level level, String msgPrefix, Exception exception) {
        FaultException fe;
        String fcName;
        if (exception instanceof FaultException && (fcName = (fe = (FaultException)exception).getFaultClassName()) != null && fe.getMessage() != null) {
            this.rateLimitingLogger.log(rnId, level, msgPrefix + " Fault class:" + fcName + " Problem:" + fe.getMessage());
            return;
        }
        if (exception instanceof ConnectException || exception instanceof ConnectIOException) {
            this.rateLimitingLogger.log(rnId, level, msgPrefix + " Problem:" + exception.toString());
            return;
        }
        this.logger.log(level, "{0} Problem:{1}", new Object[]{msgPrefix, exception.toString()});
    }

    protected void logOnFailure(RepNodeId rnId, Exception exception, String changesMsg) {
        if (exception == null) {
            this.logger.info("Error. " + changesMsg);
            return;
        }
        String irnsseName = IllegalRepNodeServiceStateException.class.getName();
        if (exception instanceof RepNodeAdminFaultException && ((RepNodeAdminFaultException)exception).getFaultClassName().equals(irnsseName)) {
            this.rateLimitingLogger.log(rnId, Level.INFO, changesMsg + "Exception message:" + exception.getMessage());
        } else {
            this.logBrief(rnId, Level.INFO, changesMsg, exception);
        }
    }

    private class UpdateThreadFactory
    extends KVThreadFactory {
        private final String name;
        private final Thread.UncaughtExceptionHandler handler;

        UpdateThreadFactory(Logger logger, String name, Thread.UncaughtExceptionHandler handler) {
            super(null, logger);
            this.name = name + "_Updater";
            this.handler = handler;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Thread.UncaughtExceptionHandler makeUncaughtExceptionHandler() {
            return this.handler;
        }
    }

    private class ResolveHandler
    implements UpdateThreadPoolExecutor.UpdateTask {
        final RepNodeState rns;

        ResolveHandler(RepNodeState rns) {
            this.rns = rns;
        }

        @Override
        public RepNodeId getResourceId() {
            return this.rns.getRepNodeId();
        }

        @Override
        public void run() {
            RegistryUtils regUtils = UpdateThread.this.requestDispatcher.getRegUtils();
            if (regUtils == null) {
                return;
            }
            UpdateThread.this.logger.log(Level.FINEST, "Probing RN state: {0}", this.rns);
            class ResolveResultHandler
            extends UncaughtResultHandler<Boolean> {
                ResolveResultHandler() {
                    super(UpdateThread.this.getUncaughtExceptionHandler());
                }

                @Override
                protected void onResultInternal(Boolean ref, Throwable e) {
                    if (e != null) {
                        UpdateThread.this.logger.log(Level.WARNING, "Exception in ResolveHandler thread when contacting:" + ResolveHandler.this.rns.getRepNodeId(), e);
                        UpdateThread.this.resolveExceptionCount++;
                    } else if (!ref.booleanValue()) {
                        UpdateThread.this.logger.log(Level.FINEST, "Resolve RN failed: {0}", ResolveHandler.this.rns);
                        UpdateThread.this.resolveFailCount++;
                    } else {
                        UpdateThread.this.logger.log(Level.FINEST, "Resolve RN succeeded: {0}", ResolveHandler.this.rns);
                        UpdateThread.this.resolveCount++;
                    }
                }
            }
            this.rns.resolveReqHandlerRef(regUtils, 10000L, new ResolveResultHandler());
        }
    }
}

