/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.TableChange;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.table.FieldDef;

class AddIndex
extends TableChange {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String tableName;
    private final String namespace;
    private final List<String> fields;
    private final List<FieldDef.Type> types;
    private final Map<String, String> annotations;
    private final Map<String, String> properties;
    private final boolean skipNulls;

    AddIndex(String namespace, String indexName, String tableName, List<String> fields, List<FieldDef.Type> types, boolean indexNulls, String description, int seqNum) {
        this(namespace, indexName, tableName, fields, types, indexNulls, null, null, description, seqNum);
    }

    AddIndex(String namespace, String indexName, String tableName, List<String> fields, Map<String, String> annotations, Map<String, String> properties, String description, int seqNum) {
        this(namespace, indexName, tableName, fields, null, true, annotations, properties, description, seqNum);
    }

    private AddIndex(String namespace, String indexName, String tableName, List<String> fields, List<FieldDef.Type> types, boolean indexNulls, Map<String, String> annotations, Map<String, String> properties, String description, int seqNum) {
        super(seqNum);
        this.name = indexName;
        this.description = description;
        this.tableName = tableName;
        this.namespace = namespace;
        this.fields = fields;
        this.types = types;
        this.skipNulls = !indexNulls;
        this.annotations = annotations;
        this.properties = properties;
    }

    @Override
    boolean apply(TableMetadata md) {
        if (this.annotations == null) {
            md.insertIndex(this.namespace, this.name, this.tableName, this.fields, this.types, !this.skipNulls, this.description);
        } else {
            md.insertTextIndex(this.namespace, this.name, this.tableName, this.fields, this.annotations, this.properties, this.description);
        }
        return true;
    }
}

