/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.FieldDef;

public class ArrayDefImpl
extends FieldDefImpl
implements ArrayDef {
    private static final long serialVersionUID = 1L;
    private final FieldDefImpl element;

    ArrayDefImpl(FieldDefImpl element, String description) {
        super(FieldDef.Type.ARRAY, description);
        if (element == null) {
            throw new IllegalArgumentException("Array has no field and cannot be built");
        }
        this.element = element;
    }

    ArrayDefImpl(FieldDefImpl element) {
        this(element, null);
    }

    private ArrayDefImpl(ArrayDefImpl impl) {
        super(impl);
        this.element = impl.element.clone();
    }

    @Override
    public ArrayDefImpl clone() {
        if (this == FieldDefImpl.arrayAnyDef || this == FieldDefImpl.arrayJsonDef) {
            return this;
        }
        return new ArrayDefImpl(this);
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ArrayDefImpl) {
            return this.element.equals(((ArrayDefImpl)other).getElement());
        }
        return false;
    }

    @Override
    public ArrayDef asArray() {
        return this;
    }

    @Override
    public ArrayValueImpl createArray() {
        return new ArrayValueImpl(this);
    }

    @Override
    public FieldDefImpl getElement() {
        return this.element;
    }

    @Override
    public boolean isPrecise() {
        return this.element.isPrecise();
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        if (this == superType) {
            return true;
        }
        if (superType.isArray()) {
            ArrayDefImpl supArray = (ArrayDefImpl)superType;
            return this.element.isSubtype(supArray.element);
        }
        if (superType.isJson()) {
            return this.element.isSubtype(jsonDef);
        }
        return superType.isAny();
    }

    @Override
    FieldDefImpl findField(String fieldName) {
        return this.element.findField(fieldName);
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        ObjectNode collNode = node.putObject("collection");
        if (this.element != null) {
            this.element.toJson(collNode);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException("Default value for type ARRAY is not an array");
        }
        if (node.size() != 0) {
            throw new IllegalArgumentException("Default value for array must be null or an empty array");
        }
        return this.createArray();
    }

    @Override
    public short getRequiredSerialVersion() {
        return this.element.getRequiredSerialVersion();
    }

    @Override
    int countTypes() {
        return this.element.countTypes() + 1;
    }
}

