/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.table.BinaryDef;
import oracle.kv.table.FieldDef;

public class BinaryDefImpl
extends FieldDefImpl
implements BinaryDef {
    private static final long serialVersionUID = 1L;

    BinaryDefImpl(String description) {
        super(FieldDef.Type.BINARY, description);
    }

    BinaryDefImpl() {
        super(FieldDef.Type.BINARY);
    }

    @Override
    public BinaryDefImpl clone() {
        return FieldDefImpl.binaryDef;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BinaryDefImpl;
    }

    @Override
    public BinaryDef asBinary() {
        return this;
    }

    @Override
    public BinaryValueImpl createBinary(byte[] value) {
        return new BinaryValueImpl(value);
    }

    @Override
    public BinaryValueImpl fromString(String base64) {
        TextNode n = new TextNode(base64);
        try {
            return this.createBinary(n.binaryValue());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Cannot create binary from string: " + base64, ioe);
        }
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isBinary() || superType.isAny() || superType.isAnyAtomic();
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isBinary() && !node.isTextual()) {
            throw new IllegalArgumentException("Default value for type BINARY is not binary or text");
        }
        try {
            byte[] bytes;
            if (node.isBinary()) {
                bytes = node.binaryValue();
            } else {
                assert (node.isTextual());
                String str = node.asText();
                bytes = TableJsonUtils.decodeBase64(str);
            }
            return this.createBinary(bytes);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException creating binary value: " + ioe, ioe);
        }
    }
}

