/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.BooleanDef;
import oracle.kv.table.FieldDef;

public class BooleanDefImpl
extends FieldDefImpl
implements BooleanDef {
    private static final long serialVersionUID = 1L;

    BooleanDefImpl(String description) {
        super(FieldDef.Type.BOOLEAN, description);
    }

    BooleanDefImpl() {
        super(FieldDef.Type.BOOLEAN);
    }

    @Override
    public BooleanDefImpl clone() {
        return FieldDefImpl.booleanDef;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BooleanDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public BooleanDef asBoolean() {
        return this;
    }

    @Override
    public BooleanValueImpl createBoolean(boolean value) {
        return BooleanValueImpl.create(value);
    }

    @Override
    BooleanValueImpl createBoolean(String value) {
        return BooleanValueImpl.create(value);
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isBoolean() || superType.isAny() || superType.isAnyAtomic() || superType.isAnyJsonAtomic() || superType.isJson();
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isBoolean()) {
            throw new IllegalArgumentException("Default value for type BOOLEAN is not boolean");
        }
        return this.createBoolean(node.asBoolean());
    }
}

