/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;

public class BooleanValueImpl
extends FieldValueImpl
implements BooleanValue {
    private static final long serialVersionUID = 1L;
    static final String trueKeyString = "t";
    static final String falseKeyString = "f";
    public static final BooleanValueImpl trueValue = new BooleanValueImpl(true);
    public static final BooleanValueImpl falseValue = new BooleanValueImpl(false);
    private boolean value;

    private BooleanValueImpl(boolean value) {
        this.value = value;
    }

    @Override
    public BooleanValueImpl clone() {
        return BooleanValueImpl.create(this.value);
    }

    @Override
    public long sizeof() {
        return 0L;
    }

    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof BooleanValueImpl) {
            return this.value == ((BooleanValueImpl)other).get();
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof BooleanValueImpl) {
            return Boolean.valueOf(this.value).compareTo(((BooleanValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an BooleanValue");
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.BOOLEAN;
    }

    @Override
    public BooleanDefImpl getDefinition() {
        return FieldDefImpl.booleanDef;
    }

    @Override
    public BooleanValue asBoolean() {
        return this;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean get() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public void setBoolean(boolean v) {
        this.value = v;
    }

    @Override
    public JsonNode toJsonNode() {
        return this.value ? BooleanNode.TRUE : BooleanNode.FALSE;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return BooleanValueImpl.toKeyString(this.value);
    }

    @Override
    FieldValueImpl getNextValue() {
        if (!this.value) {
            return trueValue;
        }
        return null;
    }

    @Override
    FieldValueImpl getMinimumValue() {
        return falseValue;
    }

    public static BooleanValueImpl create(boolean value) {
        return value ? trueValue : falseValue;
    }

    static BooleanValueImpl create(String value) {
        if (value.equals(trueKeyString)) {
            return trueValue;
        }
        if (value.equals(falseKeyString)) {
            return falseValue;
        }
        throw new IllegalArgumentException("Invalid string for boolean type: " + value);
    }

    static String toKeyString(boolean value) {
        return value ? trueKeyString : falseKeyString;
    }
}

