/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;

public abstract class ComplexValueImpl
extends FieldValueImpl {
    private static final long serialVersionUID = 1L;
    protected final FieldDef fieldDef;

    protected ComplexValueImpl(FieldDef fieldDef) {
        this.fieldDef = fieldDef;
    }

    public String toString() {
        return this.toJsonString(false);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 2 * SizeOf.OBJECT_REF_OVERHEAD;
    }

    public void validate() {
    }

    protected FieldValue validate(FieldValue value, FieldDefImpl elemDef) {
        if (value.isNull()) {
            throw new IllegalArgumentException("Cannot insert null values into collection: " + this.getClass());
        }
        FieldDefImpl valDef = (FieldDefImpl)value.getDefinition();
        if (!valDef.isSubtype(elemDef)) {
            throw new IllegalArgumentException("Type mismatch. Cannot insert value of type\n" + valDef.getDDLString() + "\ninto a collection of type\n" + this.getDefinition().getDDLString());
        }
        if (value.isFloat() && elemDef.isJson()) {
            value = FieldDefImpl.doubleDef.createDouble(value.asFloat().get());
        }
        if (elemDef.isJson() && value.isComplex() && !valDef.equals(FieldDefImpl.arrayJsonDef) && !valDef.equals(FieldDefImpl.mapJsonDef)) {
            throw new IllegalArgumentException("Type mismatch. Cannot insert value of type\n" + valDef.getDDLString() + "\ninto a collection of type\n" + this.getDefinition().getDDLString());
        }
        value = ((FieldValueImpl)value).castToSuperType(elemDef);
        if (elemDef.hasMin() || elemDef.hasMax()) {
            this.validateRangeValue(elemDef, value);
        }
        return value;
    }

    void validateRangeValue(FieldDefImpl def, FieldValue value) {
        switch (def.getType()) {
            case INTEGER: {
                assert (value.isInteger());
                ((IntegerDefImpl)def).validateValue(value.asInteger().get());
                break;
            }
            case LONG: {
                assert (value.isLong());
                ((LongDefImpl)def).validateValue(value.asLong().get());
                break;
            }
            case FLOAT: {
                assert (value.isFloat());
                ((FloatDefImpl)def).validateValue(value.asFloat().get());
                break;
            }
            case DOUBLE: {
                assert (value.isDouble());
                ((DoubleDefImpl)def).validateValue(value.asDouble().get());
                break;
            }
            case STRING: {
                assert (value.isString());
                ((StringDefImpl)def).validateValue(value.asString().get());
                break;
            }
        }
    }

    public static void createFromJson(ComplexValueImpl complexValue, Reader jsonInput, boolean exact, boolean addMissingFields) {
        JsonParser jp = null;
        try {
            jp = TableJsonUtils.createJsonParser(jsonInput);
            if (jp.nextToken() == null) {
                return;
            }
            complexValue.addJsonFields(jp, null, exact, addMissingFields);
            complexValue.validate();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void createFromJson(ComplexValueImpl complexValue, InputStream jsonInput, boolean exact) {
        ComplexValueImpl.createFromJson(complexValue, jsonInput, exact, true);
    }

    public static void createFromJson(ComplexValueImpl complexValue, InputStream jsonInput, boolean exact, boolean addMissingFields) {
        JsonParser jp = null;
        try {
            jp = TableJsonUtils.createJsonParser(jsonInput);
            if (jp.nextToken() == null) {
                return;
            }
            complexValue.addJsonFields(jp, null, exact, addMissingFields);
            complexValue.validate();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    abstract void addJsonFields(JsonParser var1, String var2, boolean var3, boolean var4);

    static void skipToJsonToken(JsonParser jp, JsonToken skipTo) {
        try {
            JsonToken token = jp.nextToken();
            while (token != skipTo) {
                if (token == JsonToken.START_OBJECT) {
                    ComplexValueImpl.skipToJsonToken(jp, JsonToken.END_OBJECT);
                } else if (token == JsonToken.START_ARRAY) {
                    ComplexValueImpl.skipToJsonToken(jp, JsonToken.END_ARRAY);
                }
                token = jp.nextToken();
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
    }

    static void jsonParseException(String msg, JsonLocation location) {
        throw new IllegalArgumentException(msg + " starting at location: line " + location.getLineNr() + ", column " + location.getColumnNr());
    }

    static void checkNumberType(String fieldName, JsonParser.NumberType expected, JsonParser jp) throws IOException {
        JsonParser.NumberType actual = null;
        if (jp.getCurrentToken().isNumeric()) {
            actual = jp.getNumberType();
            if (actual == expected || expected == JsonParser.NumberType.BIG_DECIMAL) {
                return;
            }
            switch (actual) {
                case INT: {
                    return;
                }
                case FLOAT: 
                case LONG: {
                    if (expected == JsonParser.NumberType.DOUBLE) {
                        return;
                    }
                    if (expected != JsonParser.NumberType.FLOAT) break;
                }
                case DOUBLE: {
                    float f;
                    if (expected != JsonParser.NumberType.FLOAT) break;
                    Double d = jp.getDoubleValue();
                    if (d.isNaN() || d == 0.0) {
                        return;
                    }
                    if (d < 0.0) {
                        d = -d.doubleValue();
                    }
                    if (!((f = d.floatValue()) >= Float.MIN_VALUE) || !(f <= Float.MAX_VALUE)) break;
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Illegal value for numeric field " + (fieldName != null ? fieldName : jp.getText()) + ". Expected " + (Object)((Object)expected) + ", is " + (jp.getCurrentToken().isNumeric() ? jp.getNumberType() : jp.getCurrentToken()));
    }
}

