/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.EnumDef;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;

public class EnumValueImpl
extends FieldValueImpl
implements EnumValue {
    private static final long serialVersionUID = 1L;
    private final EnumDefImpl field;
    private String value;

    EnumValueImpl(EnumDef field, String value) {
        this.field = (EnumDefImpl)field;
        this.value = value;
        this.validate();
    }

    @Override
    public EnumValueImpl clone() {
        return new EnumValueImpl(this.field, this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 2 * SizeOf.OBJECT_REF_OVERHEAD + SizeOf.stringSize(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof EnumValueImpl) {
            EnumDefImpl def = this.field;
            EnumValueImpl otherVal = (EnumValueImpl)other;
            EnumDefImpl otherDef = otherVal.getDefinition();
            return def.valuesEqual(otherDef) && this.value.equals(otherVal.get());
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof EnumValueImpl) {
            int thisIndex = this.indexOf(this.value);
            int otherIndex = this.indexOf(((EnumValueImpl)other).value);
            return Integer.valueOf(thisIndex).compareTo(otherIndex);
        }
        throw new ClassCastException("Object is not an IntegerValue");
    }

    public String toString() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.ENUM;
    }

    @Override
    public EnumDefImpl getDefinition() {
        return this.field;
    }

    @Override
    public EnumValue asEnum() {
        return this;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.field.indexOf(this.value);
    }

    @Override
    public String getEnumString() {
        return this.value;
    }

    @Override
    public void setEnum(String v) {
        this.value = v;
    }

    @Override
    public String castAsString() {
        return this.value;
    }

    @Override
    public EnumValueImpl getNextValue() {
        EnumDefImpl def = this.field;
        int index = this.getIndex();
        if (def.isValidIndex(index + 1)) {
            return def.createEnum(index + 1);
        }
        return null;
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return this.field.createEnum(0);
    }

    @Override
    public String formatForKey(FieldDef field1, int storageSize) {
        return EnumValueImpl.toKeyString(this.field, this.getIndex());
    }

    @Override
    public JsonNode toJsonNode() {
        return new TextNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        if (this.value == null) {
            sb.append("null");
            return;
        }
        sb.append('\"');
        CharTypes.appendQuoted(sb, this.value);
        sb.append('\"');
    }

    int indexOf(String enumValue) {
        return this.field.indexOf(enumValue);
    }

    private void validate() {
        if (this.field != null && this.value != null) {
            this.field.validateValue(this.value);
            return;
        }
        throw new IllegalArgumentException("Value not valid for enumeration: " + this.value);
    }

    static EnumValueImpl createFromKey(EnumDef field, String indexString) {
        EnumDefImpl def = (EnumDefImpl)field;
        int index = SortableString.intFromSortable(indexString);
        return def.createEnum(index);
    }

    static String toKeyString(EnumDefImpl enumDef, int index) {
        return SortableString.toSortable(index, enumDef.getEncodingLen());
    }
}

