/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sleepycat.bind.tuple.TupleInput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NumberUtils;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IndexKey;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.NumberValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.StringValue;
import oracle.kv.table.TimestampValue;

public abstract class FieldValueImpl
implements FieldValue,
ValueSerializer.FieldValueSerializer,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    @Override
    public FieldValueImpl clone() {
        try {
            return (FieldValueImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int compareTo(FieldValue o) {
        throw new IllegalArgumentException("FieldValueImpl objects must implement compareTo");
    }

    @Override
    public abstract FieldDefImpl getDefinition();

    @Override
    public BinaryValue asBinary() {
        throw new ClassCastException("Field is not a Binary: " + this.getClass());
    }

    @Override
    public NumberValue asNumber() {
        throw new ClassCastException("Field is not a Number: " + this.getClass());
    }

    @Override
    public BooleanValue asBoolean() {
        throw new ClassCastException("Field is not a Boolean: " + this.getClass());
    }

    @Override
    public DoubleValue asDouble() {
        throw new ClassCastException("Field is not a Double: " + this.getClass());
    }

    @Override
    public FloatValue asFloat() {
        throw new ClassCastException("Field is not a Float: " + this.getClass());
    }

    @Override
    public IntegerValue asInteger() {
        throw new ClassCastException("Field is not an Integer: " + this.getClass());
    }

    @Override
    public LongValue asLong() {
        throw new ClassCastException("Field is not a Long: " + this.getClass());
    }

    @Override
    public StringValue asString() {
        throw new ClassCastException("Field is not a String: " + this.getClass());
    }

    @Override
    public TimestampValue asTimestamp() {
        throw new ClassCastException("Field is not a Timestamp: " + this.getClass());
    }

    @Override
    public EnumValue asEnum() {
        throw new ClassCastException("Field is not an Enum: " + this.getClass());
    }

    @Override
    public FixedBinaryValue asFixedBinary() {
        throw new ClassCastException("Field is not a FixedBinary: " + this.getClass());
    }

    @Override
    public ArrayValue asArray() {
        throw new ClassCastException("Field is not an Array: " + this.getClass());
    }

    @Override
    public MapValue asMap() {
        throw new ClassCastException("Field is not a Map: " + this.getClass());
    }

    @Override
    public RecordValue asRecord() {
        throw new ClassCastException("Field is not a Record: " + this.getClass());
    }

    @Override
    public Row asRow() {
        throw new ClassCastException("Field is not a Row: " + this.getClass());
    }

    @Override
    public PrimaryKey asPrimaryKey() {
        throw new ClassCastException("Field is not a PrimaryKey: " + this.getClass());
    }

    @Override
    public IndexKey asIndexKey() {
        throw new ClassCastException("Field is not an IndexKey: " + this.getClass());
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isFixedBinary() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isTimestamp() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isRow() {
        return false;
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public boolean isIndexKey() {
        return false;
    }

    @Override
    public boolean isJsonNull() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public String toJsonString(boolean pretty) {
        if (pretty) {
            ObjectWriter writer = JsonUtils.createWriter(pretty);
            try {
                return writer.writeValueAsString(this.toJsonNode());
            }
            catch (IOException ioe) {
                return ioe.toString();
            }
        }
        StringBuilder sb = new StringBuilder(128);
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public abstract long sizeof();

    public boolean isTuple() {
        return false;
    }

    @Override
    public boolean isEMPTY() {
        return false;
    }

    static boolean isSpecialValue(FieldValueImpl val) {
        return val.isNull() || val.isEMPTY() || val.isJsonNull();
    }

    public int size() {
        throw new ClassCastException("Value is not complex (array, map, or record): " + this.getClass());
    }

    public Map<String, FieldValue> getMap() {
        throw new ClassCastException("Value is not a record or map: " + this.getClass());
    }

    @Override
    public int getInt() {
        throw new ClassCastException("Value is not an integer or subtype: " + this.getClass());
    }

    public void setInt(int v) {
        throw new ClassCastException("Value is not an integer or subtype: " + this.getClass());
    }

    @Override
    public long getLong() {
        throw new ClassCastException("Value is not a long or subtype: " + this.getClass());
    }

    public void setLong(long v) {
        throw new ClassCastException("Value is not a long or subtype: " + this.getClass());
    }

    @Override
    public float getFloat() {
        throw new ClassCastException("Value is not a float or subtype: " + this.getClass());
    }

    public void setFloat(float v) {
        throw new ClassCastException("Value is not a float or subtype: " + this.getClass());
    }

    public void setDecimal(BigDecimal v) {
        throw new ClassCastException("Value is not a Number or subtype: " + this.getClass());
    }

    public BigDecimal getDecimal() {
        throw new ClassCastException("Value is not a double or subtype: " + this.getClass());
    }

    @Override
    public double getDouble() {
        throw new ClassCastException("Value is not a double or subtype: " + this.getClass());
    }

    public void setDouble(double v) {
        throw new ClassCastException("Value is not a double or subtype: " + this.getClass());
    }

    @Override
    public String getString() {
        throw new ClassCastException("Value is not a string or subtype: " + this.getClass());
    }

    public void setString(String v) {
        throw new ClassCastException("Value is not a String or subtype: " + this.getClass());
    }

    @Override
    public String getEnumString() {
        throw new ClassCastException("Value is not an enum or subtype: " + this.getClass());
    }

    public void setEnum(String v) {
        throw new ClassCastException("Value is not an enum or subtype: " + this.getClass());
    }

    @Override
    public boolean getBoolean() {
        throw new ClassCastException("Value is not a boolean: " + this.getClass());
    }

    public void setBoolean(boolean v) {
        throw new ClassCastException("Value is not a boolean or subtype: " + this.getClass());
    }

    @Override
    public byte[] getBytes() {
        throw new ClassCastException("Value is not a binary: " + this.getClass());
    }

    public void setTimestamp(Timestamp timestamp) {
        throw new ClassCastException("Value is not a timestamp: " + this.getClass());
    }

    public Timestamp getTimestamp() {
        throw new ClassCastException("Value is not a timestamp: " + this.getClass());
    }

    public FieldValueImpl getElement(int index) {
        if (this.isArray()) {
            return ((ArrayValueImpl)this).get(index);
        }
        if (this.isRecord()) {
            return ((RecordValueImpl)this).get(index);
        }
        if (this.isTuple()) {
            return ((TupleValue)this).get(index);
        }
        throw new ClassCastException("Value is not an array or record: " + this.getClass());
    }

    public FieldValueImpl getElement(String fieldName) {
        if (this.isMap()) {
            return ((MapValueImpl)this).get(fieldName);
        }
        if (this.isRecord()) {
            return ((RecordValueImpl)this).get(fieldName);
        }
        if (this.isTuple()) {
            return ((TupleValue)this).get(fieldName);
        }
        throw new ClassCastException("Value is not a map or a record: " + this.getClass());
    }

    public FieldValueImpl getFieldValue(String fieldName) {
        if (this.isMap()) {
            return ((MapValueImpl)this).get(fieldName);
        }
        if (this.isRecord()) {
            return ((RecordValueImpl)this).get(fieldName);
        }
        if (this.isTuple()) {
            return ((TupleValue)this).get(fieldName);
        }
        throw new ClassCastException("Value is not a map or a record: " + this.getClass());
    }

    FieldValueImpl getNextValue() {
        throw new IllegalArgumentException("Type does not implement getNextValue: " + this.getClass().getName());
    }

    FieldValueImpl getMinimumValue() {
        throw new IllegalArgumentException("Type does not implement getMinimumValue: " + this.getClass().getName());
    }

    public abstract JsonNode toJsonNode();

    public abstract void toStringBuilder(StringBuilder var1);

    static FieldValue fromJavaObjectValue(FieldDef def, Object o) {
        switch (def.getType()) {
            case INTEGER: {
                return def.createInteger((Integer)o);
            }
            case LONG: {
                return def.createLong((Long)o);
            }
            case DOUBLE: {
                return def.createDouble((Double)o);
            }
            case FLOAT: {
                return def.createFloat(((Float)o).floatValue());
            }
            case NUMBER: {
                return def.createNumber((BigDecimal)o);
            }
            case STRING: {
                return def.createString((String)o);
            }
            case BINARY: {
                return def.createBinary((byte[])o);
            }
            case FIXED_BINARY: {
                return def.createFixedBinary((byte[])o);
            }
            case BOOLEAN: {
                return def.createBoolean((Boolean)o);
            }
            case ENUM: {
                return def.createEnum((String)o);
            }
            case TIMESTAMP: {
                return def.createTimestamp((Timestamp)o);
            }
            case RECORD: {
                return RecordValueImpl.fromJavaObjectValue(def, o);
            }
            case ARRAY: {
                return ArrayValueImpl.fromJavaObjectValue(def, o);
            }
            case MAP: {
                return MapValueImpl.fromJavaObjectValue(def, o);
            }
        }
        throw new IllegalArgumentException("Complex classes must override fromJavaObjectValue");
    }

    public String formatForKey(FieldDef field, int storageSize) {
        throw new IllegalArgumentException("Key components must be atomic types");
    }

    String formatForKey(FieldDef field) {
        return this.formatForKey(field, 0);
    }

    FieldValueImpl findFieldValue(TablePath path, int arrayIndex, String mapKey) {
        return this.findFieldValue(path, 0, arrayIndex, mapKey);
    }

    private FieldValueImpl findFieldValue(TablePath path, int pathPos, int arrayIndex, String mapKey) {
        if (pathPos >= path.numSteps()) {
            throw new IllegalStateException("Unexpected end of index path: " + path);
        }
        String next = path.getStep(pathPos++);
        if (!this.isComplex()) {
            if ("[]".equals(next) && pathPos >= path.numSteps()) {
                return this;
            }
            return EmptyValueImpl.getInstance();
        }
        switch (this.getType()) {
            case RECORD: {
                RecordValueImpl rec = (RecordValueImpl)this;
                FieldValueImpl fv = rec.get(next);
                if (fv == null) {
                    throw new IllegalStateException("Unexpected null field value in path " + path + " at step " + next + " in record :\n" + rec);
                }
                if (pathPos >= path.numSteps()) {
                    return fv;
                }
                if (fv.isNull()) {
                    return fv;
                }
                return fv.findFieldValue(path, pathPos, arrayIndex, mapKey);
            }
            case MAP: {
                MapValueImpl map;
                FieldValueImpl fv;
                if (path.isBracketsStep(pathPos - 1)) {
                    if (pathPos >= path.numSteps()) {
                        return this;
                    }
                    next = path.getStep(pathPos++);
                }
                if (path.isKeysStep(pathPos - 1)) {
                    return FieldDefImpl.stringDef.createString(mapKey);
                }
                if (path.isValuesStep(pathPos - 1)) {
                    next = mapKey;
                }
                if ((fv = (map = (MapValueImpl)this).get(next)) == null) {
                    return EmptyValueImpl.getInstance();
                }
                if (pathPos >= path.numSteps()) {
                    return fv;
                }
                return fv.findFieldValue(path, pathPos, arrayIndex, mapKey);
            }
            case ARRAY: {
                if (arrayIndex == -1) {
                    throw new IllegalArgumentException("Unexpected array in path " + path + " at step " + next + " Array value =\n" + this);
                }
                ArrayValueImpl arr = (ArrayValueImpl)this;
                FieldValueImpl fv = arr.get(arrayIndex);
                if (path.isBracketsStep(pathPos - 1)) {
                    if (pathPos >= path.numSteps()) {
                        return fv;
                    }
                } else {
                    --pathPos;
                }
                if (fv.isAtomic()) {
                    return EmptyValueImpl.getInstance();
                }
                return fv.findFieldValue(path, pathPos, -1, mapKey);
            }
        }
        return null;
    }

    protected static Object readTuple(FieldDef.Type type, FieldDef def, TupleInput in) {
        switch (type) {
            case INTEGER: {
                return in.readSortedPackedInt();
            }
            case STRING: {
                return in.readString();
            }
            case LONG: {
                return in.readSortedPackedLong();
            }
            case DOUBLE: {
                return in.readSortedDouble();
            }
            case FLOAT: {
                return Float.valueOf(in.readSortedFloat());
            }
            case NUMBER: {
                return NumberUtils.readTuple(in);
            }
            case ENUM: {
                return in.readSortedPackedInt();
            }
            case BOOLEAN: {
                return in.readBoolean();
            }
            case TIMESTAMP: {
                assert (def != null);
                byte[] buf = new byte[((TimestampDefImpl)def).getNumBytes()];
                in.read(buf);
                return buf;
            }
        }
        throw new IllegalStateException("Type not supported in indexes: " + type);
    }

    public static int compareFieldValues(FieldValue val1, FieldValue val2) {
        FieldValueImpl v1 = (FieldValueImpl)val1;
        FieldValueImpl v2 = (FieldValueImpl)val2;
        if (v1 != null) {
            if (v2 == null) {
                return -1;
            }
            if (FieldValueImpl.isSpecialValue(v1) || FieldValueImpl.isSpecialValue(v2)) {
                if (!FieldValueImpl.isSpecialValue(v1)) {
                    return -1;
                }
                if (!FieldValueImpl.isSpecialValue(v2)) {
                    return 1;
                }
                return FieldValueImpl.compareSpecialValues(v1, v2);
            }
            return v1.compareTo(v2);
        }
        if (v2 != null) {
            return 1;
        }
        return 0;
    }

    private static int compareSpecialValues(FieldValueImpl v1, FieldValueImpl v2) {
        if (v1.isEMPTY()) {
            return v2.isEMPTY() ? 0 : -1;
        }
        if (v1.isJsonNull()) {
            return v2.isJsonNull() ? 0 : (v2.isEMPTY() ? 1 : -1);
        }
        return v2.isNull() ? 0 : 1;
    }

    public int castAsInt() {
        throw new ClassCastException("Value can not be cast to an integer: " + this.getClass());
    }

    public long castAsLong() {
        throw new ClassCastException("Value can not be cast to a long: " + this.getClass());
    }

    public float castAsFloat() {
        throw new ClassCastException("Value can not be cast to a float: " + this.getClass());
    }

    public double castAsDouble() {
        throw new ClassCastException("Value can not be cast to a double: " + this.getClass());
    }

    public BigDecimal castAsDecimal() {
        throw new ClassCastException("Value can not be cast to a Number: " + this.getClass());
    }

    public String castAsString() {
        throw new ClassCastException("Value can not be cast to a String: " + this.getClass());
    }

    FieldValue castToSuperType(FieldDefImpl targetDef) {
        if (this.isNull()) {
            return this;
        }
        FieldDefImpl valDef = this.getDefinition();
        if (targetDef.isWildcard() || targetDef.equals(valDef)) {
            return this;
        }
        assert (valDef.isSubtype(targetDef));
        switch (this.getType()) {
            case INTEGER: {
                return targetDef.isLong() ? targetDef.createLong(this.asInteger().get()) : targetDef.createNumber(this.asInteger().get());
            }
            case LONG: {
                assert (targetDef.isNumber());
                return targetDef.createNumber(this.asLong().get());
            }
            case FLOAT: {
                return targetDef.isDouble() ? targetDef.createDouble(this.asFloat().get()) : targetDef.createNumber(this.asFloat().get());
            }
            case DOUBLE: {
                assert (targetDef.isNumber());
                return targetDef.createNumber(this.asDouble().get());
            }
            case TIMESTAMP: {
                assert (targetDef.isTimestamp());
                int toPrec = targetDef.asTimestamp().getPrecision();
                return ((TimestampValueImpl)this.asTimestamp()).castToPrecision(toPrec);
            }
            case ARRAY: {
                FieldDefImpl elemDef = ((ArrayDefImpl)targetDef).getElement();
                ArrayValueImpl arr = (ArrayValueImpl)this;
                ArrayValueImpl newarr = ((ArrayDefImpl)targetDef).createArray();
                for (FieldValue e : arr.getArrayInternal()) {
                    FieldValueImpl elem = (FieldValueImpl)e;
                    newarr.addInternal(elem.castToSuperType(elemDef));
                }
                return newarr;
            }
            case MAP: {
                FieldDefImpl targetElemDef = ((MapDefImpl)targetDef).getElement();
                MapValueImpl map = (MapValueImpl)this;
                MapValueImpl newmap = ((MapDefImpl)targetDef).createMap();
                for (Map.Entry<String, FieldValue> entry : map.getMap().entrySet()) {
                    String key = entry.getKey();
                    FieldValueImpl elem = (FieldValueImpl)entry.getValue();
                    newmap.put(key, elem.castToSuperType(targetElemDef));
                }
                return newmap;
            }
            case RECORD: {
                RecordValueImpl rec = (RecordValueImpl)this;
                RecordValueImpl newrec = ((RecordDefImpl)targetDef).createRecord();
                int numFields = rec.getNumFields();
                RecordDefImpl recTargetDef = (RecordDefImpl)targetDef;
                for (int i = 0; i < numFields; ++i) {
                    FieldValueImpl fval = rec.get(i);
                    if (fval == null) continue;
                    FieldDefImpl targetFieldDef = recTargetDef.getFieldDef(i);
                    newrec.put(i, fval.castToSuperType(targetFieldDef));
                }
                return newrec;
            }
            case NUMBER: 
            case STRING: 
            case BINARY: 
            case FIXED_BINARY: 
            case BOOLEAN: 
            case ENUM: {
                return this;
            }
        }
        throw new IllegalStateException("Unexpected type: " + this.getType());
    }

    @Override
    public byte[] getFixedBytes() {
        throw new ClassCastException("Value is not a Fixed binary: " + this.getClass());
    }

    @Override
    public byte[] getNumberBytes() {
        throw new ClassCastException("Value is not a Number: " + this.getClass());
    }

    @Override
    public byte[] getTimestampBytes() {
        throw new ClassCastException("Value is not a Timestamp: " + this.getClass());
    }

    @Override
    public ValueSerializer.RecordValueSerializer asRecordValueSerializer() {
        throw new ClassCastException("Field is not a Record: " + this.getClass());
    }

    @Override
    public ValueSerializer.MapValueSerializer asMapValueSerializer() {
        throw new ClassCastException("Field is not a Map: " + this.getClass());
    }

    @Override
    public ValueSerializer.ArrayValueSerializer asArrayValueSerializer() {
        throw new ClassCastException("Field is not an Array: " + this.getClass());
    }

    void putComplex(TablePath path, FieldValueImpl value, String keyForKeysField, int jsonArrayPathPos) {
        this.putComplex(path, 0, value, keyForKeysField, jsonArrayPathPos);
    }

    private FieldValueImpl putComplex(TablePath path, int pathPos, FieldValueImpl value, String keyForKeysField, int jsonArrayPathPos) {
        switch (this.getType()) {
            case RECORD: {
                FieldValueImpl fval;
                if (this.isTuple()) {
                    throw new QueryStateException("Cannot add fields to a TupleValue : " + this + "\nIndex path : " + path);
                }
                RecordValueImpl rec = (RecordValueImpl)this;
                String fname = path.getStep(pathPos);
                int pos = rec.getFieldPos(fname);
                if (pathPos == path.numSteps() - 1) {
                    fval = value;
                } else {
                    fval = rec.get(pos);
                    if (fval == null) {
                        FieldDefImpl elemDef = rec.getFieldDef(pos);
                        fval = FieldValueImpl.createComplexValue(elemDef, this.isJsonArrayPath(elemDef, jsonArrayPathPos, pathPos));
                    }
                    if (fval.isNull()) {
                        return fval;
                    }
                    fval = fval.putComplex(path, ++pathPos, value, keyForKeysField, jsonArrayPathPos);
                }
                if (fval.isEMPTY()) {
                    throw new QueryStateException("Cannot insert EMPTY value at field " + fname + " of record:\n" + rec + "\nIndex path : " + path + " path pos = " + pathPos);
                }
                rec.putInternal(pos, (FieldValue)fval);
                return this;
            }
            case ARRAY: {
                ArrayValueImpl arr = (ArrayValueImpl)this;
                FieldDefImpl elemDef = arr.getElementDef();
                String fname = path.getStep(pathPos);
                if (!path.isBracketsStep(pathPos)) {
                    throw new QueryStateException("Unexpected step " + fname + " in index path : " + path);
                }
                if (value.isEMPTY()) {
                    return this;
                }
                if (pathPos == path.numSteps() - 1) {
                    if (value.isNull()) {
                        return value;
                    }
                    if (arr.size() == 0) {
                        arr.add(value);
                    } else {
                        arr.set(0, value);
                    }
                    return this;
                }
                FieldValueImpl elem = null;
                if (arr.size() == 0) {
                    elem = FieldValueImpl.createComplexValue(elemDef, false);
                    arr.add(elem);
                } else {
                    if (!(arr.get(0) instanceof ComplexValueImpl)) {
                        throw new QueryStateException("Invalid attempt to overwrite an atomic element with a complex element in an array encountered at step " + fname + " in index path : " + path + "\nArray value : \n" + this);
                    }
                    elem = arr.get(0);
                }
                elem = super.putComplex(path, ++pathPos, value, keyForKeysField, -1);
                if (elem.isNull()) {
                    return elem;
                }
                return this;
            }
            case MAP: {
                MapValueImpl map = (MapValueImpl)this;
                if (value.isEMPTY()) {
                    return this;
                }
                FieldDefImpl elemDef = map.getElementDef();
                if (path.isKeysStep(pathPos)) {
                    if (value.isNull()) {
                        return value;
                    }
                    String mapKey = ((StringValueImpl)value).get();
                    assert (keyForKeysField != null);
                    assert (keyForKeysField.equals(mapKey));
                    FieldValueImpl mapVal = map.get("values()");
                    if (mapVal != null) {
                        map.remove("values()");
                        map.put(mapKey, mapVal);
                    } else {
                        map.putNull(mapKey);
                    }
                    return this;
                }
                String mapKey = path.isValuesStep(pathPos) ? (keyForKeysField != null ? keyForKeysField : "values()") : path.getStep(pathPos);
                if (pathPos == path.numSteps() - 1) {
                    if (value.isNull()) {
                        return value;
                    }
                    map.put(mapKey, value);
                    return this;
                }
                FieldValueImpl elem = map.get(mapKey);
                if (elem == null || elem.isNull()) {
                    elem = FieldValueImpl.createComplexValue(elemDef, this.isJsonArrayPath(elemDef, jsonArrayPathPos, pathPos));
                    map.put(mapKey, elem);
                }
                if ((elem = elem.putComplex(path, ++pathPos, value, keyForKeysField, jsonArrayPathPos)).isNull()) {
                    return elem;
                }
                return this;
            }
        }
        throw new QueryStateException("Cannot put a value in an atomic value");
    }

    private boolean isJsonArrayPath(FieldDef def, int jsonArrayPathPos, int pathPos) {
        return def.isJson() && jsonArrayPathPos >= 0 && pathPos == jsonArrayPathPos;
    }

    private static ComplexValueImpl createComplexValue(FieldDef def, boolean jsonIsArray) {
        switch (def.getType()) {
            case MAP: {
                return (ComplexValueImpl)((Object)def.createMap());
            }
            case RECORD: {
                return (ComplexValueImpl)((Object)def.createRecord());
            }
            case ARRAY: {
                return (ComplexValueImpl)((Object)def.createArray());
            }
            case JSON: {
                return (ComplexValueImpl)(jsonIsArray ? def.createArray() : def.createMap());
            }
        }
        throw new IllegalArgumentException("Not a complex type: " + def.getType());
    }
}

