/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueReaderImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.ValueReader;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.TimestampDef;

public class FieldValueSerialization {
    public static final int NULL_VALUE = -1;
    public static final int NULL_REFERENCE = -2;
    public static final int NULL_JSON_VALUE = -3;
    public static final int EMPTY_VALUE = -4;

    public static void writeFieldValue(FieldValue val, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeFieldValueInternal((ValueSerializer.FieldValueSerializer)((Object)val), writeValDef, out, serialVersion);
    }

    static void writeFieldValueInternal(ValueSerializer.FieldValueSerializer val, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        if (val == null) {
            out.writeByte(-2);
        } else if (val.isNull()) {
            out.writeByte(-1);
        } else if (val.isJsonNull()) {
            out.writeByte(-3);
        } else if (val.isEMPTY()) {
            out.writeByte(-4);
        } else {
            val.getType().writeFastExternal(out, serialVersion);
            FieldValueSerialization.writeNonNullFieldValueInternal(val, writeValDef, false, out, serialVersion);
        }
    }

    public static void writeNonNullFieldValue(FieldValue val, boolean writeValDef, boolean writeValKind, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeNonNullFieldValueInternal((ValueSerializer.FieldValueSerializer)((Object)val), writeValDef, writeValKind, out, serialVersion);
    }

    private static void writeNonNullFieldValueInternal(ValueSerializer.FieldValueSerializer value, boolean writeValDef, boolean writeValKind, DataOutput out, short serialVersion) throws IOException {
        if (value == null || value.isNull() || value.isEMPTY()) {
            throw new IllegalStateException("Unexpected value: " + value);
        }
        FieldDefImpl valDef = (FieldDefImpl)value.getDefinition();
        if (valDef.isWildcard() && !value.isJsonNull()) {
            throw new IllegalStateException("An item cannot have a wildcard type\n" + value);
        }
        if (valDef.getType() != value.getType()) {
            throw new IllegalStateException("Mismatch between value kind and associated type\nValue kind : " + value.getType() + "\nType : " + valDef);
        }
        if (writeValDef && writeValKind) {
            if (value.isJsonNull()) {
                out.writeByte(-3);
                return;
            }
            value.getType().writeFastExternal(out, serialVersion);
        }
        switch (value.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, value.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, value.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(value.getDouble());
                break;
            }
            case FLOAT: {
                out.writeFloat(value.getFloat());
                break;
            }
            case STRING: {
                if (serialVersion >= 14) {
                    SerializationUtil.writeNonNullString(out, serialVersion, value.getString());
                    break;
                }
                out.writeUTF(value.getString());
                break;
            }
            case BOOLEAN: {
                out.writeBoolean(value.getBoolean());
                break;
            }
            case NUMBER: {
                SerializationUtil.writeNonNullByteArray(out, value.getNumberBytes());
                break;
            }
            case BINARY: {
                SerializationUtil.writeNonNullByteArray(out, value.getBytes());
                break;
            }
            case FIXED_BINARY: {
                byte[] bytes = value.getFixedBytes();
                int size = value.getDefinition().asFixedBinary().getSize();
                if (size != bytes.length) {
                    throw new IllegalStateException("Definition size " + size + " is different from bytes length " + bytes.length);
                }
                SerializationUtil.writeNonNullByteArray(out, bytes);
                break;
            }
            case ENUM: {
                FieldValueSerialization.writeEnumInternal(value, writeValDef, out, serialVersion);
                break;
            }
            case TIMESTAMP: {
                FieldValueSerialization.writeTimestampInternal(value, writeValDef, out, serialVersion);
                break;
            }
            case RECORD: {
                FieldValueSerialization.writeRecordInternal(value.asRecordValueSerializer(), writeValDef, false, out, serialVersion);
                break;
            }
            case MAP: {
                FieldValueSerialization.writeMapInternal(value.asMapValueSerializer(), writeValDef, out, serialVersion);
                break;
            }
            case ARRAY: {
                FieldValueSerialization.writeArrayInternal(value.asArrayValueSerializer(), writeValDef, out, serialVersion);
                break;
            }
            case ANY: 
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: 
            case ANY_RECORD: {
                throw new IllegalStateException("ANY* types cannot be materialized as values");
            }
            case JSON: {
                throw new IllegalStateException("JSON cannot be materialized as a value");
            }
            case EMPTY: {
                throw new IllegalStateException("EMPTY type does not contain any values");
            }
            case GEOMETRY: 
            case POINT: {
                throw new IllegalStateException("Unexpected value of type GEOMETRY");
            }
        }
    }

    public static void writeEnum(EnumValueImpl value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeEnumInternal(value, writeValDef, out, serialVersion);
    }

    private static void writeEnumInternal(ValueSerializer.FieldValueSerializer value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        EnumDefImpl def = (EnumDefImpl)value.getDefinition();
        if (writeValDef) {
            FieldDefSerialization.writeEnum(def, out, serialVersion);
        }
        out.writeShort(def.indexOf(value.getEnumString()));
    }

    public static void writeTimestamp(TimestampValueImpl value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeTimestampInternal(value, writeValDef, out, serialVersion);
    }

    private static void writeTimestampInternal(ValueSerializer.FieldValueSerializer value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        byte[] bytes;
        if (writeValDef) {
            TimestampDef def = value.getDefinition().asTimestamp();
            FieldDefSerialization.writeTimestamp(def, out, serialVersion);
        }
        if ((bytes = value.getTimestampBytes()).length == 0) {
            throw new IllegalStateException("Bytes must not be empty");
        }
        if (bytes.length > 127) {
            throw new IllegalStateException("Too many bytes in timestamp: " + bytes.length);
        }
        out.writeByte(bytes.length);
        out.write(bytes);
    }

    public static void writeRecord(RecordValueImpl record, boolean writeValDef, boolean partial, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeRecordInternal(record, writeValDef, partial, out, serialVersion);
    }

    private static void writeRecordInternal(ValueSerializer.RecordValueSerializer record, boolean writeValDef, boolean partial, DataOutput out, short serialVersion) throws IOException {
        RecordDefImpl recordDef = (RecordDefImpl)record.getDefinition();
        if (writeValDef) {
            FieldDefSerialization.writeRecord(recordDef, out, serialVersion);
        }
        for (int pos = 0; pos < recordDef.getNumFields(); ++pos) {
            FieldDefImpl fdef = recordDef.getFieldDef(pos);
            ValueSerializer.FieldValueSerializer fval = record.get(pos);
            assert (fval != null || partial);
            if (!partial && !recordDef.isNullable(pos)) {
                FieldValueSerialization.writeNonNullFieldValueInternal(fval, fdef.isWildcard(), true, out, serialVersion);
                continue;
            }
            FieldValueSerialization.writeFieldValueInternal(fval, fdef.isWildcard(), out, serialVersion);
        }
    }

    public static void writeMap(MapValueImpl map, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeMap(map, writeValDef, out, serialVersion);
    }

    private static void writeMapInternal(ValueSerializer.MapValueSerializer map, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        MapDef mapDef = map.getDefinition();
        FieldDefImpl elemDef = (FieldDefImpl)mapDef.getElement();
        boolean wildcard = elemDef.isWildcard();
        if (writeValDef) {
            FieldDefSerialization.writeFieldDef(elemDef, out, serialVersion);
        }
        int size = map.size();
        SerializationUtil.writeNonNullSequenceLength(out, size);
        if (size == 0) {
            return;
        }
        Iterator<Map.Entry<String, ValueSerializer.FieldValueSerializer>> iter = map.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ValueSerializer.FieldValueSerializer> entry = iter.next();
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullString(out, serialVersion, entry.getKey());
            } else {
                out.writeUTF(entry.getKey());
            }
            FieldValueSerialization.writeNonNullFieldValueInternal(entry.getValue(), wildcard, true, out, serialVersion);
        }
    }

    public static void writeArray(ArrayValueImpl array, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeArrayInternal(array, writeValDef, out, serialVersion);
    }

    private static void writeArrayInternal(ValueSerializer.ArrayValueSerializer array, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        boolean homogeneous;
        ArrayDefImpl arrayDef = (ArrayDefImpl)array.getDefinition();
        FieldDefImpl elemDef = arrayDef.getElement();
        FieldDefImpl homogeneousType = array instanceof ArrayValueImpl ? ((ArrayValueImpl)array).getHomogeneousType() : null;
        boolean wildcard = elemDef.isWildcard();
        boolean bl = homogeneous = homogeneousType != null;
        if (writeValDef) {
            FieldDefSerialization.writeFieldDef(elemDef, out, serialVersion);
        }
        if (serialVersion >= 12 && wildcard) {
            out.writeBoolean(homogeneous);
            if (homogeneous) {
                FieldDefSerialization.writeFieldDef(homogeneousType, out, serialVersion);
                wildcard = false;
            }
        }
        int size = array.size();
        SerializationUtil.writeNonNullSequenceLength(out, size);
        Iterator<ValueSerializer.FieldValueSerializer> iter = array.iterator();
        while (iter.hasNext()) {
            ValueSerializer.FieldValueSerializer fieldVal = iter.next();
            FieldValueSerialization.writeNonNullFieldValueInternal(fieldVal, wildcard, true, out, serialVersion);
        }
    }

    public static FieldValue readFieldValue(FieldDef def, DataInput in, short serialVersion) throws IOException {
        FieldValueReaderImpl reader = new FieldValueReaderImpl();
        FieldValueSerialization.readFieldValue(reader, null, def, in, serialVersion);
        return (FieldValue)reader.getValue();
    }

    public static FieldValue readNonNullFieldValue(FieldDef def, FieldDef.Type valKind, DataInput in, short serialVersion) throws IOException {
        FieldValueReaderImpl reader = new FieldValueReaderImpl();
        FieldValueSerialization.readNonNullFieldValue(reader, null, def, valKind, in, serialVersion);
        return (FieldValue)reader.getValue();
    }

    static void readFieldValue(ValueReader<?> reader, String fieldName, FieldDef def, DataInput in, short serialVersion) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal == -2) {
            return;
        }
        if (ordinal == -1) {
            reader.readNull(fieldName);
            return;
        }
        if (ordinal == -3) {
            reader.readJsonNull(fieldName);
            return;
        }
        if (ordinal == -4) {
            reader.readEmpty(fieldName);
            return;
        }
        FieldDef.Type valKind = FieldDef.Type.valueOf(ordinal);
        FieldValueSerialization.readNonNullFieldValue(reader, fieldName, def, valKind, in, serialVersion);
    }

    static void readNonNullFieldValue(ValueReader<?> reader, String fieldName, FieldDef def, FieldDef.Type valKind, DataInput in, short serialVersion) throws IOException {
        if (def == null) {
            if (valKind == null) {
                byte ordinal = in.readByte();
                if (ordinal == -3) {
                    reader.readJsonNull(fieldName);
                    return;
                }
                valKind = FieldDef.Type.valueOf(ordinal);
            }
        } else if (valKind == null) {
            valKind = def.getType();
        }
        switch (valKind) {
            case INTEGER: {
                int val = SerializationUtil.readPackedInt(in);
                reader.readInteger(fieldName, val);
                break;
            }
            case LONG: {
                long val = SerializationUtil.readPackedLong(in);
                reader.readLong(fieldName, val);
                break;
            }
            case DOUBLE: {
                double val = in.readDouble();
                reader.readDouble(fieldName, val);
                break;
            }
            case FLOAT: {
                float val = in.readFloat();
                reader.readFloat(fieldName, val);
                break;
            }
            case STRING: {
                String val = serialVersion >= 14 ? SerializationUtil.readNonNullString(in, serialVersion) : in.readUTF();
                reader.readString(fieldName, val);
                break;
            }
            case BOOLEAN: {
                reader.readBoolean(fieldName, in.readBoolean());
                break;
            }
            case NUMBER: {
                byte[] bytes = SerializationUtil.readNonNullByteArray(in);
                if (bytes.length == 0) {
                    throw new IllegalStateException("Invalid zero length for number");
                }
                reader.readNumber(fieldName, bytes);
                break;
            }
            case BINARY: {
                byte[] bytes = SerializationUtil.readNonNullByteArray(in);
                reader.readBinary(fieldName, bytes);
                break;
            }
            case FIXED_BINARY: {
                byte[] bytes = SerializationUtil.readNonNullByteArray(in);
                reader.readFixedBinary(fieldName, new FixedBinaryDefImpl(bytes.length, null), bytes);
                break;
            }
            case ENUM: {
                EnumDefImpl enumDef;
                EnumDefImpl enumDefImpl = enumDef = def == null ? FieldDefSerialization.readEnum(in, serialVersion) : (EnumDefImpl)def;
                assert (enumDef != null);
                short index = in.readShort();
                reader.readEnum(fieldName, enumDef, index);
                break;
            }
            case TIMESTAMP: {
                TimestampDefImpl timestampDef;
                TimestampDefImpl timestampDefImpl = timestampDef = def == null ? FieldDefSerialization.readTimestamp(in, serialVersion) : (TimestampDefImpl)def;
                assert (timestampDef != null);
                byte len = in.readByte();
                if (len <= 0) {
                    throw new IOException("Invalid timestamp def length: " + len);
                }
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                reader.readTimestamp(fieldName, timestampDef, bytes);
                break;
            }
            case RECORD: {
                FieldValueSerialization.readRecord(reader, fieldName, def, false, in, serialVersion);
                break;
            }
            case MAP: {
                FieldValueSerialization.readMap(reader, fieldName, def, in, serialVersion);
                break;
            }
            case ARRAY: {
                FieldValueSerialization.readArray(reader, fieldName, def, in, serialVersion);
                break;
            }
            default: {
                throw new IllegalStateException("Type not supported: " + valKind);
            }
        }
    }

    public static RecordValueImpl readRecord(FieldDef def, boolean partial, DataInput in, short serialVersion) throws IOException {
        FieldValueReaderImpl reader = new FieldValueReaderImpl();
        FieldValueSerialization.readRecord(reader, null, def, partial, in, serialVersion);
        return (RecordValueImpl)reader.getValue();
    }

    static void readRecord(ValueReader<?> reader, String fieldName, FieldDef def, boolean partial, DataInput in, short serialVersion) throws IOException {
        RecordDefImpl recordDef = def == null ? FieldDefSerialization.readRecord(in, serialVersion) : (RecordDefImpl)def;
        reader.startRecord(fieldName, recordDef);
        for (int pos = 0; pos < recordDef.getNumFields(); ++pos) {
            FieldDefImpl fdef = recordDef.getFieldDef(pos);
            if (fdef.isWildcard()) {
                fdef = null;
            }
            String name = recordDef.getFieldName(pos);
            if (!partial && fdef != null && !recordDef.isNullable(pos)) {
                FieldValueSerialization.readNonNullFieldValue(reader, name, fdef, fdef.getType(), in, serialVersion);
                continue;
            }
            FieldValueSerialization.readFieldValue(reader, name, fdef, in, serialVersion);
        }
        reader.endRecord();
    }

    static void readMap(ValueReader<?> reader, String fieldName, FieldDef def, DataInput in, short serialVersion) throws IOException {
        FieldDefImpl elemDef = null;
        MapDef mapDef = null;
        if (def != null) {
            mapDef = def.asMap();
            elemDef = (FieldDefImpl)mapDef.getElement();
        } else {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            mapDef = FieldDefFactory.createMapDef(elemDef);
        }
        reader.startMap(fieldName, mapDef);
        boolean wildcard = elemDef.isWildcard();
        if (wildcard) {
            elemDef = null;
        }
        int size = SerializationUtil.readNonNullSequenceLength(in);
        for (int i = 0; i < size; ++i) {
            String fname = serialVersion >= 14 ? SerializationUtil.readNonNullString(in, serialVersion) : in.readUTF();
            FieldValueSerialization.readNonNullFieldValue(reader, fname, elemDef, null, in, serialVersion);
        }
        reader.endMap();
    }

    static void readArray(ValueReader<?> reader, String fieldName, FieldDef def, DataInput in, short serialVersion) throws IOException {
        boolean wildcard;
        ArrayDefImpl arrayDef = null;
        FieldDefImpl elemDef = null;
        if (def != null) {
            arrayDef = (ArrayDefImpl)def;
            elemDef = arrayDef.getElement();
            wildcard = elemDef.isWildcard();
        } else {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            arrayDef = FieldDefFactory.createArrayDef(elemDef);
            wildcard = elemDef.isWildcard();
        }
        boolean homogeneous = false;
        if (serialVersion >= 12 && wildcard && (homogeneous = in.readBoolean())) {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            wildcard = false;
        }
        reader.startArray(fieldName, arrayDef, homogeneous ? elemDef : null);
        if (wildcard) {
            elemDef = null;
        }
        int size = SerializationUtil.readNonNullSequenceLength(in);
        for (int i = 0; i < size; ++i) {
            FieldValueSerialization.readNonNullFieldValue(reader, null, elemDef, null, in, serialVersion);
        }
        reader.endArray();
    }
}

