/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatRangeValue;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FloatDef;

public class FloatDefImpl
extends FieldDefImpl
implements FloatDef {
    private static final long serialVersionUID = 1L;
    private Float min;
    private Float max;

    FloatDefImpl(String description, Float min, Float max) {
        super(FieldDef.Type.FLOAT, description);
        this.min = min;
        this.max = max;
        this.validate();
    }

    FloatDefImpl(String description) {
        this(description, null, null);
    }

    FloatDefImpl() {
        super(FieldDef.Type.FLOAT);
        this.min = null;
        this.max = null;
    }

    private FloatDefImpl(FloatDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
    }

    @Override
    public FloatDefImpl clone() {
        if (this == FieldDefImpl.floatDef) {
            return this;
        }
        return new FloatDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof FloatDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public FloatDef asFloat() {
        return this;
    }

    @Override
    public FloatValueImpl createFloat(float value) {
        return this.hasMin() || this.hasMax() ? new FloatRangeValue(value, this) : new FloatValueImpl(value);
    }

    @Override
    FloatValueImpl createFloat(String value) {
        return this.hasMin() || this.hasMax() ? new FloatRangeValue(value, this) : new FloatValueImpl(value);
    }

    @Override
    public Float getMin() {
        return this.min;
    }

    @Override
    public Float getMax() {
        return this.max;
    }

    @Override
    public boolean hasMin() {
        return this.min != null;
    }

    @Override
    public boolean hasMax() {
        return this.max != null;
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isFloat() || superType.isDouble() || superType.isNumber() || superType.isAny() || superType.isAnyJsonAtomic() || superType.isAnyAtomic() || superType.isJson();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
        }
        if (this.max != null) {
            node.put("max", this.max);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isNumber()) {
            throw new IllegalArgumentException("Default value for type FLOAT is not a number");
        }
        return this.createFloat(Float.valueOf(node.asText()).floatValue());
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue()) {
            throw new IllegalArgumentException("Invalid min or max value");
        }
    }

    void validateValue(float val) {
        if (this.min != null && val < this.min.floatValue() || this.max != null && val > this.max.floatValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

